/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable;

import mrriegel.storagenetwork.block.cable.BlockCable;
import mrriegel.storagenetwork.block.cable.TileCableWithFacing;
import mrriegel.storagenetwork.block.cable.UnlistedPropertyBlockNeighbors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockCableWithFacing
extends BlockCable {
    public BlockCableWithFacing(String registryName) {
        super(registryName);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileCableWithFacing)) {
            return super.rotateBlock(world, pos, axis);
        }
        TileCableWithFacing facingTile = (TileCableWithFacing)tile;
        facingTile.rotate();
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileCableWithFacing)) {
            return;
        }
        TileCableWithFacing facingTile = (TileCableWithFacing)tile;
        facingTile.findNewDirection();
        facingTile.func_70296_d();
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileCableWithFacing)) {
            return;
        }
        TileCableWithFacing facingTile = (TileCableWithFacing)tile;
        facingTile.findNewDirection();
        worldServer.func_175646_b(pos, (TileEntity)facingTile);
        worldServer.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }

    @Override
    protected UnlistedPropertyBlockNeighbors.BlockNeighbors getBlockNeighbors(IBlockAccess world, BlockPos pos) {
        UnlistedPropertyBlockNeighbors.BlockNeighbors result = super.getBlockNeighbors(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileCableWithFacing)) {
            return result;
        }
        TileCableWithFacing facingTile = (TileCableWithFacing)tile;
        if (facingTile.hasDirection()) {
            result.setNeighborType(facingTile.getDirection(), UnlistedPropertyBlockNeighbors.EnumNeighborType.SPECIAL);
        }
        return result;
    }
}

