/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable.processing;

import com.google.common.collect.Lists;
import java.io.IOException;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.cable.ContainerCable;
import mrriegel.storagenetwork.block.cable.GuiCableBase;
import mrriegel.storagenetwork.block.cable.GuiCableButton;
import mrriegel.storagenetwork.block.cable.processing.ProcessRequestModel;
import mrriegel.storagenetwork.block.cable.processing.TileCableProcess;
import mrriegel.storagenetwork.gui.IPublicGuiContainer;
import mrriegel.storagenetwork.gui.ItemSlotNetwork;
import mrriegel.storagenetwork.network.CableDataMessage;
import mrriegel.storagenetwork.network.CableFilterMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.inventory.FilterItemStackHandler;
import mrriegel.storagenetwork.util.inventory.ProcessingItemStackHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCableProcessing
extends GuiCableBase
implements IPublicGuiContainer {
    protected GuiCableButton pbtnReset;
    protected GuiCableButton pbtnBottomface;
    protected GuiCableButton pbtnTopface;
    private TileCableProcess tile;

    public GuiCableProcessing(TileCableProcess tileEntity, ContainerCable inventorySlotsIn) {
        super(inventorySlotsIn);
        this.tile = tileEntity;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int y;
        int x;
        int num;
        int index;
        int col;
        int row;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        int xMiddle = (this.field_146294_l - this.field_146999_f) / 2;
        int yMiddle = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xMiddle, yMiddle, 0, 0, this.field_146999_f, this.field_147000_g);
        int u = 176;
        int v = 34;
        int rows = 3;
        int cols = 6;
        for (row = 0; row < rows; ++row) {
            for (col = 0; col < cols; ++col) {
                int x2 = xMiddle + 7 + 18 * row + col / 3 * 108;
                int y2 = yMiddle + 25 + 18 * col;
                if (col > 2) {
                    y2 -= 54;
                }
                this.func_73729_b(x2, y2, u, v, 18, 18);
            }
        }
        this.itemSlotsGhost = Lists.newArrayList();
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                index = col + 3 * row;
                ItemStack stack = this.tile.filters.getStackInSlot(index);
                num = stack.func_190916_E();
                x = col * 18 + 8;
                y = row * 18 + 26;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, num, this.field_147003_i, this.field_147009_r, true));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                index = 9 + col + 3 * row;
                ItemStack stack = this.tile.filters.getStackInSlot(index);
                num = stack.func_190916_E();
                x = col * 18 + 116;
                y = row * 18 + 26;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, num, this.field_147003_i, this.field_147009_r, true));
            }
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(mouseX, mouseY);
        }
    }

    public void drawString(String s, int x, int y) {
        int color = 0xE0E0E0;
        this.func_73731_b(this.field_146289_q, StorageNetwork.lang(s), x, y, color);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.pbtnBottomface.field_146126_j = this.tile.getFacingBottomRow().name().substring(0, 2);
        this.pbtnTopface.field_146126_j = this.tile.getFacingTopRow().name().substring(0, 2);
        int x = -90;
        int y = 48;
        if (this.tile.filters.isOutputEmpty() || this.tile.filters.isInputEmpty()) {
            x = -102;
            this.drawString("tile.storagenetwork:recipe.invalid", x, y);
            if (this.tile.filters.isOutputEmpty()) {
                this.drawString("tile.storagenetwork:recipe.invalidright", x, y += 12);
            }
            if (this.tile.filters.isInputEmpty()) {
                this.drawString("tile.storagenetwork:recipe.invalidleft", x, y += 12);
            }
        } else {
            this.drawString("tile.storagenetwork:recipe.valid", x, y);
        }
        ProcessRequestModel p = this.tile.getProcessModel();
        x = -90;
        y = 4;
        this.drawString("tile.storagenetwork:controller.name", x, y);
        x += 12;
        y += 18;
        TextFormatting f = p.isAlwaysActive() ? TextFormatting.GREEN : TextFormatting.BLUE;
        String txt = StorageNetwork.lang("processing.alwayson." + p.isAlwaysActive());
        if (!p.isAlwaysActive()) {
            txt = txt + p.getCount();
        }
        this.drawString(f + txt, x, y);
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        super.drawTooltips(mouseX, mouseY);
        if (this.pbtnReset.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.refresh", (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.pbtnTopface.func_146115_a()) {
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.processing.recipe", (Object[])new Object[0])}), mouseX, mouseY, this.field_146289_q);
        }
        if (this.pbtnBottomface.func_146115_a()) {
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.processing.extract", (Object[])new Object[0])}), mouseX, mouseY, this.field_146289_q);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = 0;
        int y = 0;
        this.btnImport = new GuiCableButton(CableDataMessage.CableMessageType.IMPORT_FILTER, this.field_147003_i + 78, this.field_147009_r + 5, "I");
        this.func_189646_b(this.btnImport);
        this.btnImport.field_146128_h += 56;
        this.pbtnReset = new GuiCableButton(CableDataMessage.CableMessageType.TOGGLE_P_RESTARTTRIGGER, this.field_147003_i + 154, this.field_147009_r + 5, "R");
        this.func_189646_b(this.pbtnReset);
        int column = 76;
        int ctr = 24;
        this.pbtnBottomface = new GuiCableButton(CableDataMessage.CableMessageType.P_FACE_BOTTOM, this.field_147003_i + column + 20, this.field_147009_r + ctr, "");
        this.func_189646_b(this.pbtnBottomface);
        this.pbtnTopface = new GuiCableButton(CableDataMessage.CableMessageType.P_FACE_TOP, this.field_147003_i + column - 12, this.field_147009_r + ctr, "");
        this.func_189646_b(this.pbtnTopface);
        x = 64;
        y = 62;
        this.checkOreBtn = new GuiCheckBox(10, this.field_147003_i + x, this.field_147009_r + y, I18n.func_135052_a((String)"gui.storagenetwork.checkbox.ore", (Object[])new Object[0]), true);
        this.checkOreBtn.setIsChecked(this.tile.filters.ores);
        this.func_189646_b((GuiButton)this.checkOreBtn);
        this.checkMetaBtn = new GuiCheckBox(11, this.field_147003_i + x, this.field_147009_r + (y += 12), I18n.func_135052_a((String)"gui.storagenetwork.checkbox.meta", (Object[])new Object[0]), true);
        this.checkMetaBtn.setIsChecked(this.tile.filters.meta);
        this.func_189646_b((GuiButton)this.checkMetaBtn);
        this.checkNbtBtn = new GuiCheckBox(12, this.field_147003_i + x, this.field_147009_r + (y -= 24), I18n.func_135052_a((String)"gui.storagenetwork.checkbox.nbt", (Object[])new Object[0]), true);
        this.checkNbtBtn.setIsChecked(this.tile.filters.nbt);
        this.func_189646_b((GuiButton)this.checkNbtBtn);
    }

    @Override
    public FilterItemStackHandler getFilterHandler() {
        return this.tile.filters;
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.pbtnTopface != null && button.field_146127_k == this.pbtnTopface.field_146127_k) {
            int newFace = (this.tile.getFacingTopRow().ordinal() + 1) % EnumFacing.values().length;
            this.tile.processingTop = EnumFacing.values()[newFace];
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k, newFace));
        } else if (this.pbtnBottomface != null && button.field_146127_k == this.pbtnBottomface.field_146127_k) {
            int newFace = (this.tile.getFacingBottomRow().ordinal() + 1) % EnumFacing.values().length;
            this.tile.processingBottom = EnumFacing.values()[newFace];
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k, newFace));
        }
    }

    @Override
    protected void mouseWheelOverSlot(int slot, boolean wheelUp) {
        super.mouseWheelOverSlot(slot, wheelUp);
        if (this.tile == null || this.tile.filters == null) {
            return;
        }
        ProcessingItemStackHandler filters = this.tile.filters;
        ItemStack filter = filters.getStackInSlot(slot);
        boolean changed = false;
        if (wheelUp && filter.func_190916_E() < 64) {
            filter.func_190920_e(filter.func_190916_E() + 1);
            changed = true;
        } else if (!wheelUp && filter.func_190916_E() > 1) {
            filter.func_190920_e(filter.func_190916_E() - 1);
            changed = true;
        }
        if (changed) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableFilterMessage(slot, filter, filters.ores, filters.meta, this.checkNbtBtn.isChecked()));
        }
    }

    @Override
    public void drawGradientRectP(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public boolean isPointInRegionP(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return super.func_146978_c(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    @Override
    public void renderToolTipP(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }
}

