/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.datafixes;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Iterator;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.datafixes.ChunkDataReader;
import mrriegel.storagenetwork.registry.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.BlockPos;

public class ChunkBasedFixer
implements IFixableData {
    public int func_188216_a() {
        return 0;
    }

    private void moveValue(NBTTagCompound sourceTag, NBTTagCompound targetTag, String key) {
        try {
            if (sourceTag.func_74781_a(key) != null) {
                targetTag.func_74782_a(key, sourceTag.func_74781_a(key));
            }
            sourceTag.func_82580_o(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void moveValue(NBTTagCompound sourceTag, NBTTagCompound targetTag, String sourceKey, String targetKey) {
        if (sourceTag.func_74781_a(sourceKey) != null) {
            targetTag.func_74782_a(targetKey, sourceTag.func_74781_a(sourceKey));
        }
        sourceTag.func_82580_o(sourceKey);
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        if (!compound.func_74764_b("Level")) {
            return compound;
        }
        NBTTagCompound levelData = compound.func_74775_l("Level");
        if (!levelData.func_74764_b("TileEntities")) {
            return compound;
        }
        ChunkDataReader reader = new ChunkDataReader(compound.func_74775_l("Level"));
        NBTTagList tileList = levelData.func_150295_c("TileEntities", 10);
        for (NBTBase tileBase : tileList) {
            NBTTagCompound tileData = (NBTTagCompound)tileBase;
            boolean process = false;
            String id = tileData.func_74779_i("id");
            BlockPos pos = new BlockPos(tileData.func_74762_e("x"), tileData.func_74762_e("y"), tileData.func_74762_e("z"));
            if (id.equals("minecraft:tilekabel")) {
                NBTTagCompound nestedStack;
                NBTTagCompound filterStack;
                NBTTagList filterStackList;
                NBTTagCompound filterRulesTag;
                NBTTagCompound filtersTag;
                IBlockState state = reader.getBlockState(pos);
                Block block = state.func_177230_c();
                if (block == ModBlocks.exKabel || block == ModBlocks.imKabel) {
                    tileData.func_74778_a("id", "storagenetwork:tilekabelio");
                    NBTTagCompound ioStorageTag = new NBTTagCompound();
                    filtersTag = new NBTTagCompound();
                    filtersTag.func_74768_a("Size", 18);
                    filterRulesTag = new NBTTagCompound();
                    this.moveValue(tileData, filterRulesTag, "nbtFilter", "nbt");
                    this.moveValue(tileData, filterRulesTag, "metas", "meta");
                    this.moveValue(tileData, filterRulesTag, "white", "whitelist");
                    this.moveValue(tileData, filterRulesTag, "ores");
                    filtersTag.func_74782_a("rules", (NBTBase)filterRulesTag);
                    filterStackList = tileData.func_150295_c("crunchTE", 10);
                    for (NBTBase filterStackBase : filterStackList) {
                        filterStack = (NBTTagCompound)filterStackBase;
                        nestedStack = filterStack.func_74775_l("stack");
                        this.moveValue(nestedStack, filterStack, "id");
                        this.moveValue(nestedStack, filterStack, "Count");
                        this.moveValue(nestedStack, filterStack, "Damage");
                        filterStack.func_82580_o("stack");
                        filterStack.func_82580_o("size");
                    }
                    this.moveValue(tileData, filtersTag, "crunchTE", "Items");
                    ioStorageTag.func_74782_a("filters", (NBTBase)filtersTag);
                    Iterator upgradesTag = new NBTTagCompound();
                    upgradesTag.func_74768_a("Size", 4);
                    this.moveValue(tileData, (NBTTagCompound)upgradesTag, "Items");
                    ioStorageTag.func_74782_a("upgrades", (NBTBase)upgradesTag);
                    NBTTagCompound operationTag = new NBTTagCompound();
                    this.moveValue(tileData, operationTag, "mode", "mustBeSmaller");
                    this.moveValue(tileData, operationTag, "limit");
                    this.moveValue(tileData, operationTag, "stack");
                    ioStorageTag.func_74782_a("operation", (NBTBase)operationTag);
                    this.moveValue(tileData, ioStorageTag, "prio");
                    this.moveValue(tileData, ioStorageTag, "inventoryFace");
                    tileData.func_74782_a("ioStorage", (NBTBase)ioStorageTag);
                }
                if (block == ModBlocks.storageKabel) {
                    tileData.func_74778_a("id", "storagenetwork:tilekabellink");
                    NBTTagCompound linkStorageTag = new NBTTagCompound();
                    filtersTag = new NBTTagCompound();
                    filtersTag.func_74768_a("Size", 18);
                    filterRulesTag = new NBTTagCompound();
                    this.moveValue(tileData, filterRulesTag, "nbtFilter", "nbt");
                    this.moveValue(tileData, filterRulesTag, "metas", "meta");
                    this.moveValue(tileData, filterRulesTag, "white", "whitelist");
                    this.moveValue(tileData, filterRulesTag, "ores");
                    filtersTag.func_74782_a("rules", (NBTBase)filterRulesTag);
                    filterStackList = tileData.func_150295_c("crunchTE", 10);
                    for (NBTBase filterStackBase : filterStackList) {
                        filterStack = (NBTTagCompound)filterStackBase;
                        nestedStack = filterStack.func_74775_l("stack");
                        this.moveValue(nestedStack, filterStack, "id");
                        this.moveValue(nestedStack, filterStack, "Count");
                        this.moveValue(nestedStack, filterStack, "Damage");
                        filterStack.func_82580_o("stack");
                        filterStack.func_82580_o("size");
                    }
                    this.moveValue(tileData, filtersTag, "crunchTE", "Items");
                    linkStorageTag.func_74782_a("filters", (NBTBase)filtersTag);
                    NBTTagCompound operationTag = new NBTTagCompound();
                    this.moveValue(tileData, operationTag, "mode", "mustBeSmaller");
                    this.moveValue(tileData, operationTag, "limit");
                    this.moveValue(tileData, operationTag, "stack");
                    linkStorageTag.func_74782_a("operation", (NBTBase)operationTag);
                    this.moveValue(tileData, linkStorageTag, "way");
                    this.moveValue(tileData, linkStorageTag, "prio");
                    this.moveValue(tileData, linkStorageTag, "inventoryFace");
                    tileData.func_74782_a("itemStorage", (NBTBase)linkStorageTag);
                }
                if (block == ModBlocks.processKabel) {
                    tileData.func_74778_a("id", "storagenetwork:tilekabelprocess");
                    NBTTagCompound filtersTag2 = new NBTTagCompound();
                    filtersTag2.func_74768_a("Size", 18);
                    NBTTagCompound filterRulesTag2 = new NBTTagCompound();
                    this.moveValue(tileData, filterRulesTag2, "nbtFilter", "nbt");
                    this.moveValue(tileData, filterRulesTag2, "metas", "meta");
                    this.moveValue(tileData, filterRulesTag2, "white", "whitelist");
                    this.moveValue(tileData, filterRulesTag2, "ores");
                    filtersTag2.func_74782_a("rules", (NBTBase)filterRulesTag2);
                    NBTTagList filterStackList2 = tileData.func_150295_c("crunchTE", 10);
                    for (NBTBase filterStackBase : filterStackList2) {
                        NBTTagCompound filterStack2 = (NBTTagCompound)filterStackBase;
                        NBTTagCompound nestedStack2 = filterStack2.func_74775_l("stack");
                        this.moveValue(nestedStack2, filterStack2, "id");
                        this.moveValue(nestedStack2, filterStack2, "Count");
                        this.moveValue(nestedStack2, filterStack2, "Damage");
                        filterStack2.func_82580_o("stack");
                        filterStack2.func_82580_o("size");
                    }
                    this.moveValue(tileData, filtersTag2, "crunchTE", "Items");
                    tileData.func_74782_a("filters", (NBTBase)filtersTag2);
                }
                process = true;
            }
            if (id.equals("minecraft:tilemaster")) {
                tileData.func_74778_a("id", "storagenetwork:tilemaster");
                process = true;
            }
            if (id.equals("minecraft:tilerequest")) {
                tileData.func_74778_a("id", "storagenetwork:tilerequest");
                process = true;
            }
            if (id.equals("minecraft:tilecontrol")) {
                tileData.func_74778_a("id", "storagenetwork:tilecontrol");
                process = true;
            }
            if (!process) continue;
            StorageNetwork.instance.logger.info("Renamed '{}' to '{}'", (Object)id, (Object)tileData.func_74779_i("id"));
            if (tileData.func_74764_b("master")) {
                NBTTagCompound connectableTag = new NBTTagCompound();
                BlockPos posMaster = (BlockPos)new Gson().fromJson(tileData.func_74779_i("master"), new TypeToken<BlockPos>(){}.getType());
                DimPos newMasterPos = new DimPos(0, posMaster);
                connectableTag.func_74782_a("master", (NBTBase)newMasterPos.serializeNBT());
                tileData.func_74782_a("connectable", (NBTBase)connectableTag);
                StorageNetwork.instance.logger.info("Converted 'master={}' to 'connectable={}'", (Object)tileData.func_74779_i("master"), (Object)connectableTag);
                tileData.func_82580_o("master");
            }
            if (tileData.func_74764_b("inventoryFace")) {
                EnumFacing inventoryFace = EnumFacing.func_176739_a((String)tileData.func_74779_i("inventoryFace"));
                if (inventoryFace != null) {
                    StorageNetwork.instance.logger.info("Converted 'inventoryFace={}' to 'direction={}'", (Object)tileData.func_74779_i("inventoryFace"), (Object)inventoryFace.func_176745_a());
                    tileData.func_74768_a("direction", inventoryFace.func_176745_a());
                    tileData.func_82580_o("inventoryFace");
                } else {
                    StorageNetwork.instance.logger.info("Unable to convert inventoryFace={}", (Object)tileData.func_74779_i("inventoryFace"));
                }
            }
            tileData.func_82580_o("north");
            tileData.func_82580_o("south");
            tileData.func_82580_o("east");
            tileData.func_82580_o("west");
            tileData.func_82580_o("up");
            tileData.func_82580_o("down");
            tileData.func_82580_o("connectedInventory");
        }
        return compound;
    }
}

