/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block.data;

import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.RotationUtil;
import net.minecraft.util.EnumFacing;

public abstract class RotatableData {
    private static final int ROT_BITMASK = 63;

    public static void rotate(CbTileEntity cbTileEntity, EnumFacing.Axis axis) {
        int cbMetadata = cbTileEntity.getCbMetadata();
        RotationUtil.Rotation rotation = RotationUtil.Rotation.get(cbMetadata).getNext(axis);
        cbMetadata &= 0xFFFFFFC0;
        cbTileEntity.setCbMetadata(cbMetadata |= rotation.asInt().intValue());
    }

    public static void resetRotation(CbTileEntity cbTileEntity) {
        int data = RotationUtil.Rotation.X0_Y0_Z0.asInt();
        cbTileEntity.setCbMetadata(data);
    }

    public static RotationUtil.Rotation getRotation(CbTileEntity cbTileEntity) {
        return RotationUtil.Rotation.get(cbTileEntity.getCbMetadata());
    }
}

