/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.RenderPkg;
import com.carpentersblocks.util.IConstants;
import com.carpentersblocks.util.block.BlockUtil;
import com.carpentersblocks.util.registry.ConfigRegistry;
import com.carpentersblocks.util.registry.SpriteRegistry;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractBakedModel
implements IBakedModel {
    private VertexFormat _vertexFormat;

    public AbstractBakedModel(IModelState modelState, VertexFormat vertexFormat, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this._vertexFormat = vertexFormat;
    }

    public VertexFormat getVertexFormat() {
        if (ConfigRegistry.enableOptifineCompatibility) {
            return this._vertexFormat;
        }
        return new VertexFormat(this._vertexFormat).func_181721_a(DefaultVertexFormats.field_181716_p);
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing facing, long rand) {
        if (blockState == null && facing == null) {
            RenderPkg renderPkg = new RenderPkg(this._vertexFormat, facing, rand);
            this.fillQuads(renderPkg);
            return renderPkg.getInventoryQuads();
        }
        if (!BlockUtil.validateBlockState(blockState) || facing != null || MinecraftForgeClient.getRenderLayer() == null) {
            return Collections.emptyList();
        }
        RenderPkg renderPkg = new RenderPkg(this.getVertexFormat(), blockState, facing, rand);
        this.fillQuads(renderPkg);
        return renderPkg.getQuads();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return SpriteRegistry.sprite_uncovered_full;
    }

    protected abstract void fillQuads(RenderPkg var1);

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)IConstants.perspectiveMatrix[cameraTransformType.ordinal()]);
    }
}

