/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.state.Property;
import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.renderer.QuadContainer;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.RotationUtil;
import com.carpentersblocks.util.attribute.AbstractAttribute;
import com.carpentersblocks.util.attribute.AttributeHelper;
import com.carpentersblocks.util.attribute.AttributeItemStack;
import com.carpentersblocks.util.attribute.AttributeString;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import com.carpentersblocks.util.block.BlockUtil;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.registry.SpriteRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class RenderPkg {
    public static ThreadLocal<IBlockState> _threadLocalBlockState = new ThreadLocal();
    public static ThreadLocal<VertexFormat> _threadLocalVertexFormat = new ThreadLocal();
    private long _rand;
    private AttributeHelper _cbAttrHelper;
    private BlockPos _blockPos;
    private Integer _cbMetadata;
    private QuadContainer _quadContainer;
    private BlockRenderLayer _uncoveredRenderLayer;
    private boolean _isSideCover;
    private double _sideDepth;
    private boolean _isSnowCover;
    private EnumAttributeLocation _location;
    private IModelState _modelState;
    private static final double SIDE_DEPTH = 0.0625;
    private static final double SNOW_SIDE_DEPTH = 0.125;

    public RenderPkg(VertexFormat vertexFormat, IBlockState blockState, EnumFacing facing, long rand) {
        _threadLocalBlockState.set(blockState);
        _threadLocalVertexFormat.set(vertexFormat);
        this._rand = rand;
        this._blockPos = (BlockPos)RenderPkg.getThreadedProperty(Property.BLOCK_POS);
        this._cbMetadata = (Integer)RenderPkg.getThreadedProperty(Property.CB_METADATA);
        Block block = Minecraft.func_71410_x().field_71441_e.func_180495_p(this._blockPos).func_177230_c();
        this._uncoveredRenderLayer = block.func_180664_k();
        this._cbAttrHelper = new AttributeHelper((Map)RenderPkg.getThreadedProperty(Property.ATTR_MAP));
        this._quadContainer = new QuadContainer(EnumAttributeLocation.HOST);
    }

    public RenderPkg(VertexFormat vertexFormat, EnumFacing facing, long rand) {
        _threadLocalVertexFormat.set(vertexFormat);
        this._cbMetadata = 0;
        this._rand = rand;
        this._quadContainer = new QuadContainer(EnumAttributeLocation.HOST);
    }

    public void addAll(Collection<Quad> collection) {
        this._quadContainer.addAll(collection);
    }

    public void add(Quad quad) {
        this._quadContainer.add(quad);
    }

    public void rotate(RotationUtil.Rotation rotation) {
        this._quadContainer.rotate(rotation);
    }

    public IBlockState appendAttributeBlockState(CbTileEntity cbTileEntity, IBlockState blockState, EnumAttributeLocation location, EnumAttributeType type) {
        if (cbTileEntity.getAttributeHelper().hasAttribute(location, type)) {
            ItemStack itemStack = (ItemStack)((AttributeItemStack)cbTileEntity.getAttributeHelper().getAttribute(location, type)).getModel();
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            IBlockState attrBlockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), location, type);
            return ((IExtendedBlockState)blockState).withProperty(Property.ATTR_BLOCKSTATE, (Object)attrBlockState);
        }
        return blockState;
    }

    public List<BakedQuad> getInventoryQuads() {
        return this._quadContainer.bakeQuads();
    }

    public List<BakedQuad> getQuads() {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        IBlockState hostBlockState = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.HOST, EnumAttributeType.COVER) ? BlockUtil.getAttributeBlockState(this._cbAttrHelper, EnumAttributeLocation.HOST, EnumAttributeType.COVER) : null;
        boolean hasHostCoverOverride = this._quadContainer.hasCoverOverride();
        EnumAttributeLocation[] enumAttributeLocationArray = EnumAttributeLocation.values();
        int n = enumAttributeLocationArray.length;
        for (int i = 0; i < n; ++i) {
            TextureAtlasSprite overlaySprite;
            EnumAttributeLocation location;
            this._location = location = enumAttributeLocationArray[i];
            QuadContainer quadContainer = this._quadContainer;
            boolean hasLocationCover = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.COVER);
            this._isSideCover = !EnumAttributeLocation.HOST.equals((Object)location);
            if (this._isSideCover && !hasLocationCover) continue;
            boolean hasOverlay = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.OVERLAY);
            boolean hasChiselDesign = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.DESIGN_CHISEL);
            if (!EnumAttributeLocation.HOST.equals((Object)location)) {
                this._sideDepth = this.getSideCoverDepth(location);
                quadContainer = this._quadContainer.toSideLocation(null, location, this._sideDepth);
            }
            Map<EnumFacing, List<Quad>> coverQuadMap = this.getCoveredQuads(quadContainer, location, renderLayer);
            boolean renderAttribute = false;
            IBlockState attributeState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, location, EnumAttributeType.COVER);
            if (attributeState != null) {
                renderAttribute = attributeState.func_177230_c().canRenderInLayer(attributeState, renderLayer);
            }
            boolean canRenderBaseQuads = quadContainer.getRenderLayers(renderAttribute).contains(renderLayer);
            BlockRenderLayer outermostCoverRenderLayer = this._uncoveredRenderLayer;
            if (attributeState != null && hasLocationCover) {
                for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                    if (!attributeState.func_177230_c().canRenderInLayer(attributeState, blockRenderLayer)) continue;
                    if (blockRenderLayer.equals((Object)renderLayer)) {
                        canRenderBaseQuads = true;
                    }
                    outermostCoverRenderLayer = blockRenderLayer;
                }
            } else {
                canRenderBaseQuads |= renderLayer.equals((Object)this._uncoveredRenderLayer);
            }
            if (!canRenderBaseQuads) {
                for (BlockRenderLayer blockRenderLayer : EnumFacing.field_82609_l) {
                    if (coverQuadMap.containsKey(blockRenderLayer)) {
                        for (Quad quad : coverQuadMap.get(blockRenderLayer)) {
                            if (!renderLayer.equals((Object)quad.getRenderLayer())) continue;
                            canRenderBaseQuads = true;
                            break;
                        }
                    }
                    if (canRenderBaseQuads) break;
                }
            }
            BlockRenderLayer overlayRenderLayer = BlockRenderLayer.CUTOUT_MIPPED;
            if (hasOverlay) {
                overlayRenderLayer = BlockRenderLayer.TRANSLUCENT;
            } else if (BlockRenderLayer.CUTOUT_MIPPED.ordinal() < outermostCoverRenderLayer.ordinal()) {
                overlayRenderLayer = outermostCoverRenderLayer;
            }
            BlockRenderLayer chiselDesignRenderLayer = BlockRenderLayer.TRANSLUCENT;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!coverQuadMap.containsKey(facing)) continue;
                for (Quad quad : coverQuadMap.get(facing)) {
                    quads.add(quad.bake(location));
                }
            }
            if (hasChiselDesign && chiselDesignRenderLayer.equals((Object)renderLayer)) {
                String design = (String)((AttributeString)this._cbAttrHelper.getAttribute(location, EnumAttributeType.DESIGN_CHISEL)).getModel();
                TextureAtlasSprite textureAtlasSprite = SpriteRegistry.sprite_design_chisel.get(DesignHandler.listChisel.indexOf(design));
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    quads.addAll(this.getQuadsForSide(quadContainer, facing, textureAtlasSprite, 0xFFFFFF, false));
                }
            }
            if (hasOverlay && overlayRenderLayer.equals((Object)renderLayer)) {
                int n2;
                OverlayHandler.Overlay overlay = OverlayHandler.getOverlayType((ItemStack)((AttributeItemStack)this._cbAttrHelper.getAttribute(location, EnumAttributeType.OVERLAY)).getModel());
                int n3 = 0xFFFFFF;
                if (OverlayHandler.Overlay.GRASS.equals((Object)overlay)) {
                    IBlockState overlayBlockState = Blocks.field_150349_c.func_176223_P();
                    n2 = blockColors.func_186724_a(overlayBlockState, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, this._blockPos, ForgeHooksClient.getWorldRenderPass());
                }
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    overlaySprite = OverlayHandler.getOverlaySprite(overlay, facing);
                    if (overlaySprite == null) continue;
                    quads.addAll(this.getQuadsForSide(quadContainer, facing, overlaySprite, n2, false));
                }
            }
            AbstractAttribute.Key upKey = AbstractAttribute.generateKey(EnumAttributeLocation.UP, EnumAttributeType.COVER);
            IBlockState iBlockState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, upKey.getLocation(), upKey.getType());
            if (!EnumAttributeLocation.HOST.equals((Object)location) || !this._cbAttrHelper.hasAttribute(upKey) || !this.isSnowState(iBlockState) || hostBlockState == null || this.isSnowState(hostBlockState) || !overlayRenderLayer.equals((Object)renderLayer)) continue;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                overlaySprite = OverlayHandler.getOverlaySprite(OverlayHandler.Overlay.SNOW, facing);
                if (overlaySprite == null) continue;
                quads.addAll(this.getQuadsForSide(quadContainer, facing, overlaySprite, null, false));
            }
        }
        return quads;
    }

    private boolean isSnowState(IBlockState blockState) {
        return blockState.func_177230_c().equals(Blocks.field_150433_aE) || blockState.func_177230_c().equals(Blocks.field_150431_aC);
    }

    private Map<EnumFacing, List<Quad>> getCoveredQuads(QuadContainer quadContainer, EnumAttributeLocation location, BlockRenderLayer renderLayer) {
        ItemStack coverStack;
        HashMap<EnumFacing, List<Quad>> map = new HashMap<EnumFacing, List<Quad>>();
        boolean canRenderCover = false;
        boolean hasDye = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.DYE);
        int dyeRgb = 0;
        if (hasDye) {
            dyeRgb = DyeHandler.getColor((ItemStack)((AttributeItemStack)this._cbAttrHelper.getAttribute(location, EnumAttributeType.DYE)).getModel());
        }
        boolean hasCover = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.COVER);
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        IBlockState blockState = null;
        HashMap<EnumFacing, List> bakedQuads = new HashMap<EnumFacing, List>();
        if (hasCover && (coverStack = (ItemStack)((AttributeItemStack)this._cbAttrHelper.getAttribute(location, EnumAttributeType.COVER)).getModel()) != null) {
            IBakedModel itemModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(coverStack);
            blockState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, location, EnumAttributeType.COVER);
            canRenderCover = blockState.func_177230_c().canRenderInLayer(blockState, renderLayer);
            EnumFacing[] enumFacingArray = EnumFacing.values();
            int n = enumFacingArray.length;
            for (int i = 0; i < n; ++i) {
                EnumFacing facing = enumFacingArray[i];
                bakedQuads.put(facing, itemModel.func_188616_a(blockState, facing, this._rand));
            }
        }
        int attrRgb = -1;
        if (blockState != null) {
            attrRgb = blockColors.func_186724_a(blockState, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, this._blockPos, ForgeHooksClient.getWorldRenderPass());
        }
        for (EnumFacing facing : EnumFacing.values()) {
            map.put(facing, new ArrayList());
            for (Quad quad : quadContainer.getQuads(blockState, facing)) {
                if (quad.canCover() && hasCover) {
                    if (!canRenderCover || bakedQuads.get(facing) == null) continue;
                    for (BakedQuad bakedQuad : (List)bakedQuads.get(facing)) {
                        Quad newQuad = new Quad(quad);
                        if (Blocks.field_150349_c.equals(blockState.func_177230_c())) {
                            if (this.isTintedGrassSprite(bakedQuad.func_187508_a())) {
                                newQuad.setRgb(attrRgb);
                            } else if (hasDye) {
                                newQuad.setRgb(dyeRgb);
                            }
                        } else if (bakedQuad.func_178211_c() > -1) {
                            if (hasDye) {
                                newQuad.setRgb(dyeRgb);
                            } else {
                                newQuad.setRgb(attrRgb);
                            }
                        } else if (hasDye) {
                            newQuad.setRgb(dyeRgb);
                        }
                        newQuad.setSprite(bakedQuad.func_187508_a());
                        ((List)map.get(facing)).add(newQuad);
                    }
                    continue;
                }
                if (!quad.getRenderLayer().equals((Object)renderLayer)) continue;
                if (hasDye) {
                    quad.setRgb(dyeRgb);
                }
                ((List)map.get(facing)).add(quad);
            }
        }
        return map;
    }

    private boolean isTintedGrassSprite(TextureAtlasSprite sprite) {
        return "minecraft:blocks/grass_top".equalsIgnoreCase(sprite.func_94215_i()) || "minecraft:blocks/grass_side_overlay".equalsIgnoreCase(sprite.func_94215_i());
    }

    private List<BakedQuad> getQuadsForSide(QuadContainer quadContainer, EnumFacing facing, TextureAtlasSprite spriteOverride, Integer rgbOverride, boolean isCover) {
        List<Quad> srcQuads = quadContainer.getQuads(null, facing);
        ArrayList<Quad> destQuads = new ArrayList<Quad>(srcQuads.size());
        for (Quad quad : srcQuads) {
            Quad newQuad = new Quad(quad);
            if (quad.canCover() && spriteOverride != null) {
                newQuad.setSprite(spriteOverride);
            }
            if (rgbOverride != null) {
                newQuad.setRgb(rgbOverride);
            }
            destQuads.add(newQuad);
        }
        return quadContainer.bakeQuads(destQuads);
    }

    protected boolean canRenderSide(EnumFacing facing) {
        return true;
    }

    protected Quad transform(BakedQuad bakedQuad, EnumFacing facing) {
        int[] data = bakedQuad.func_178209_a();
        float xMin = Float.MAX_VALUE;
        float xMax = Float.MIN_VALUE;
        float yMin = Float.MAX_VALUE;
        float yMax = Float.MIN_VALUE;
        float zMin = Float.MAX_VALUE;
        float zMax = Float.MIN_VALUE;
        for (int i = 0; i < 4; ++i) {
            float x = Float.intBitsToFloat(data[i * 7]);
            float y = Float.intBitsToFloat(data[i * 7 + 1]);
            float z = Float.intBitsToFloat(data[i * 7 + 2]);
            xMin = Math.min(xMin, x);
            yMin = Math.min(yMin, y);
            zMin = Math.min(zMin, z);
            xMax = Math.max(xMax, x);
            yMax = Math.max(yMax, y);
            zMax = Math.max(zMax, z);
        }
        switch (facing) {
            case DOWN: {
                return Quad.getQuad(facing, bakedQuad.func_187508_a(), bakedQuad.func_178211_c(), new Vec3d((double)xMin, (double)yMin, (double)zMax), new Vec3d((double)xMin, (double)yMin, (double)zMin), new Vec3d((double)xMax, (double)yMin, (double)zMin), new Vec3d((double)xMax, (double)yMin, (double)zMax));
            }
            case UP: {
                return Quad.getQuad(facing, bakedQuad.func_187508_a(), bakedQuad.func_178211_c(), new Vec3d((double)xMin, (double)yMax, (double)zMin), new Vec3d((double)xMin, (double)yMax, (double)zMax), new Vec3d((double)xMax, (double)yMax, (double)zMax), new Vec3d((double)xMax, (double)yMax, (double)zMin));
            }
            case NORTH: {
                return Quad.getQuad(facing, bakedQuad.func_187508_a(), bakedQuad.func_178211_c(), new Vec3d((double)xMax, (double)yMax, (double)zMin), new Vec3d((double)xMax, (double)yMin, (double)zMin), new Vec3d((double)xMin, (double)yMin, (double)zMin), new Vec3d((double)xMin, (double)yMax, (double)zMin));
            }
            case SOUTH: {
                return Quad.getQuad(facing, bakedQuad.func_187508_a(), bakedQuad.func_178211_c(), new Vec3d((double)xMin, (double)yMax, (double)zMax), new Vec3d((double)xMin, (double)yMin, (double)zMax), new Vec3d((double)xMax, (double)yMin, (double)zMax), new Vec3d((double)xMax, (double)yMax, (double)zMax));
            }
            case WEST: {
                return Quad.getQuad(facing, bakedQuad.func_187508_a(), bakedQuad.func_178211_c(), new Vec3d((double)xMin, (double)yMax, (double)zMin), new Vec3d((double)xMin, (double)yMin, (double)zMin), new Vec3d((double)xMin, (double)yMin, (double)zMax), new Vec3d((double)xMin, (double)yMax, (double)zMax));
            }
        }
        return Quad.getQuad(facing, bakedQuad.func_187508_a(), bakedQuad.func_178211_c(), new Vec3d((double)xMax, (double)yMax, (double)zMax), new Vec3d((double)xMax, (double)yMin, (double)zMax), new Vec3d((double)xMax, (double)yMin, (double)zMin), new Vec3d((double)xMax, (double)yMax, (double)zMin));
    }

    private double getSideCoverDepth(EnumAttributeLocation location) {
        IBlockState blockState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, location, EnumAttributeType.COVER);
        if (EnumAttributeLocation.UP.equals((Object)location) && blockState != null && this.isSnowState(blockState)) {
            return 0.125;
        }
        return 0.0625;
    }

    protected List<Quad> transform(List<BakedQuad> quads) {
        ArrayList<Quad> outQuads = new ArrayList<Quad>();
        for (BakedQuad bakedQuad : quads) {
        }
        return outQuads;
    }

    public Integer getData() {
        return this._cbMetadata;
    }

    public static Object getThreadedProperty(IProperty property) {
        IBlockState blockState = _threadLocalBlockState.get();
        if (blockState != null) {
            return blockState.func_177229_b(property);
        }
        return null;
    }

    public static Object getThreadedProperty(IUnlistedProperty property) {
        IBlockState blockState = _threadLocalBlockState.get();
        if (blockState != null) {
            return ((IExtendedBlockState)blockState).getValue(property);
        }
        return null;
    }
}

