/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.bakedblock;

import com.carpentersblocks.block.data.SlopeData;
import com.carpentersblocks.renderer.AbstractBakedModel;
import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.renderer.RenderPkg;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.util.RotationUtil;
import com.carpentersblocks.util.registry.SpriteRegistry;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakedSlope
extends AbstractBakedModel {
    public BakedSlope(IModelState modelState, VertexFormat vertexFormat, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(modelState, vertexFormat, bakedTextureGetter);
    }

    @Override
    protected void fillQuads(RenderPkg renderPkg) {
        SlopeData.Type type = SlopeData.getType(renderPkg.getData());
        switch (type) {
            case WEDGE: {
                this.fillWedgeQuads(renderPkg);
                break;
            }
            case OBLIQUE_INTERIOR: {
                this.fillObliqueInteriorQuads(renderPkg);
                break;
            }
            case OBLIQUE_EXTERIOR: {
                this.fillObliqueExteriorQuads(renderPkg);
            }
        }
        RotationUtil.Rotation rotation = RotationUtil.Rotation.get(renderPkg.getData());
        renderPkg.rotate(rotation);
    }

    private void fillWedgeQuads(RenderPkg renderPkg) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.UP, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0)));
    }

    private void fillObliqueInteriorQuads(RenderPkg renderPkg) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadXNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.UP, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.UP, SpriteRegistry.sprite_uncovered_oblique_pos, new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 0.0)));
    }

    private void fillObliqueExteriorQuads(RenderPkg renderPkg) {
        renderPkg.add(Quad.getQuad(EnumFacing.DOWN, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.UP, SpriteRegistry.sprite_uncovered_oblique_neg, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.NORTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0)));
    }
}

