/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.computer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerPeripheral;
import it.zerono.mods.zerocore.lib.compat.computer.Connector;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import li.cil.oc.api.API;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers")})
public class ConnectorOpenComputers
extends Connector
implements ManagedPeripheral,
Environment {
    @CapabilityInject(value=Environment.class)
    private static Capability<Environment> ENVIRONMENT_CAPABILITY = null;
    private static final String NODE_TAG = "ocNode";
    private final Node _node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getConnectionName()).create();

    public static Connector create(@Nonnull String connectionName, @Nonnull ComputerPeripheral peripheral) {
        return new ConnectorOpenComputers(connectionName, peripheral);
    }

    @Override
    public void onAttachedToController() {
        if (null != this._node && this._node.network() == null) {
            API.network.joinOrCreateNetwork(this.getPeripheral().getTileEntity());
            this.getPeripheral().getTileEntity().func_70296_d();
        }
    }

    @Override
    public void onDetachedFromController() {
        if (null != this._node) {
            this._node.remove();
        }
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (null != this.node() && data.func_74764_b(NODE_TAG)) {
            this.node().load(data.func_74775_l(NODE_TAG));
        }
    }

    @Override
    public void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (this.node() != null) {
            if (this.node().address() == null) {
                Network.joinNewNetwork((Node)this.node());
                NBTTagCompound nodeTag = new NBTTagCompound();
                this.node().save(nodeTag);
                data.func_74782_a(NODE_TAG, (NBTBase)nodeTag);
                this.node().remove();
            } else {
                NBTTagCompound nodeTag = new NBTTagCompound();
                this.node().save(nodeTag);
                data.func_74782_a(NODE_TAG, (NBTBase)nodeTag);
            }
        }
    }

    public static boolean isComputerCapability(Capability<?> capability) {
        return null != ENVIRONMENT_CAPABILITY && ENVIRONMENT_CAPABILITY == capability;
    }

    @Optional.Method(modid="opencomputers")
    public String[] methods() {
        return this.getPeripheral().getMethodsNames();
    }

    @Optional.Method(modid="opencomputers")
    public Object[] invoke(String methodName, Context context, Arguments arguments) throws Exception {
        ComputerMethod method = this.getPeripheral().getMethod(methodName);
        if (null == method) {
            throw new RuntimeException("Invalid method");
        }
        try {
            Object[] argsCopy = new Object[arguments.count()];
            for (int idx = 0; idx < arguments.count(); ++idx) {
                Object arg = arguments.checkAny(idx);
                argsCopy[idx] = arg instanceof Map ? ImmutableMap.copyOf((Map)((Map)arg)) : (arg instanceof List ? ImmutableList.copyOf((Collection)((List)arg)) : arg);
            }
            return method.invoke(this.getPeripheral(), argsCopy);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Node node() {
        return this._node;
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    private ConnectorOpenComputers(@Nonnull String connectionName, @Nonnull ComputerPeripheral peripheral) {
        super(connectionName, peripheral);
    }
}

