/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.client;

import com.mr208.rewired.ReWIRED;
import com.mr208.rewired.client.OverlayHandler;
import com.mr208.rewired.client.ReWIREDEssentialsMissingHandlerClient;
import com.mr208.rewired.client.gui.InventoryTabERA;
import com.mr208.rewired.client.render.ReWIREDMeshDefinition;
import com.mr208.rewired.client.render.RenderCyberSkeleton;
import com.mr208.rewired.client.render.TESRCanopicJar;
import com.mr208.rewired.client.render.item.CustomItemModelFactory;
import com.mr208.rewired.common.CommonProxy;
import com.mr208.rewired.common.ReWIREDContent;
import com.mr208.rewired.common.blocks.tiles.TileCanopicJar;
import com.mr208.rewired.common.entities.EntityCyberSkeleton;
import com.mr208.rewired.common.items.ItemReWIRED;
import com.mr208.rewired.common.items.augments.ItemAugment;
import com.mr208.rewired.common.items.equipment.IColorableEquipment;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.handler.EssentialsMissingHandlerClient;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;

public class ClientProxy
extends CommonProxy {
    public static final String[] CUSTOM_RENDERS = new String[]{"visor"};

    @Override
    public void onPreInit() {
        super.onPreInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (Block block : ReWIREDContent.registeredBlocks) {
            this.registerRenders(block);
        }
        for (Item item : ReWIREDContent.registeredItems) {
            this.registerRenders(item);
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileCanopicJar.class, (TileEntitySpecialRenderer)new TESRCanopicJar());
        RenderingRegistry.registerEntityRenderingHandler(EntityCyberSkeleton.class, RenderCyberSkeleton::new);
    }

    @Override
    public void onInit() {
        super.onInit();
        MinecraftForge.EVENT_BUS.unregister((Object)EssentialsMissingHandlerClient.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ReWIREDEssentialsMissingHandlerClient.INSTANCE);
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        if (TabRegistry.getTabList().size() == 0) {
            MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
            TabRegistry.registerTab(new InventoryTabVanilla());
        }
        TabRegistry.registerTab(new InventoryTabERA());
        if (Loader.isModLoaded((String)"theoneprobe") && ReWIRED.hudjackCompatActive) {
            MinecraftForge.EVENT_BUS.register((Object)new OverlayHandler());
        }
        this.registerColorableItems((Item)ReWIREDContent.armorARVisor);
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private void registerRenders(Block block) {
        Item item = Item.func_150898_a((Block)block);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    private void registerRenders(Item item) {
        if (item instanceof ItemAugment) {
            ItemAugment ware = (ItemAugment)item;
            ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
            if (ware.subNames.length > 0) {
                for (int i = 0; i < ware.subNames.length; ++i) {
                    String name = ware.getRegistryName() + "_" + ware.subNames[i];
                    for (ICyberware.Quality q : ICyberware.Quality.qualities) {
                        if (q.getSpriteSuffix() == null || !ware.canHoldQuality(new ItemStack((Item)ware, 1, i), q)) continue;
                        models.add(new ModelResourceLocation(name + "_" + q.getSpriteSuffix(), "inventory"));
                    }
                    models.add(new ModelResourceLocation(name, "inventory"));
                }
            } else {
                String name = ware.getRegistryName() + "";
                for (ICyberware.Quality q : ICyberware.Quality.qualities) {
                    if (q.getSpriteSuffix() == null || !ware.canHoldQuality(new ItemStack((Item)ware), q)) continue;
                    models.add(new ModelResourceLocation(name + "_" + q.getSpriteSuffix(), "inventory"));
                }
                models.add(new ModelResourceLocation(name, "inventory"));
            }
            ModelLoader.registerItemVariants((Item)ware, (ResourceLocation[])((ResourceLocation[])models.toArray(new ModelResourceLocation[models.size()])));
            ModelLoader.setCustomMeshDefinition((Item)ware, (ItemMeshDefinition)new ReWIREDMeshDefinition());
        } else if (item instanceof ItemReWIRED) {
            ItemReWIRED base = (ItemReWIRED)item;
            if (base.subNames.length > 0) {
                for (int i = 0; i < base.subNames.length; ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + base.subNames[i], "inventory"));
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    public void onModelBake(ModelBakeEvent event) {
        for (String itemRender : CUSTOM_RENDERS) {
            ModelResourceLocation model = new ModelResourceLocation("rewired:" + itemRender, "inventory");
            Object obj = event.getModelRegistry().func_82594_a((Object)model);
            if (obj == null) continue;
            event.getModelRegistry().func_82595_a((Object)model, (Object)new CustomItemModelFactory((IBakedModel)obj));
        }
    }

    protected void registerColorableItems(Item item) {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex != 0 && stack.func_77973_b() instanceof IColorableEquipment) {
                    return ((IColorableEquipment)stack.func_77973_b()).getColorInt(stack);
                }
                return -1;
            }
        }, new Item[]{item});
    }
}

