/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.entities;

import com.mojang.authlib.GameProfile;
import com.mr208.rewired.ReWIRED;
import com.mr208.rewired.common.ReWIREDContent;
import com.mr208.rewired.common.handlers.ConfigHandler;
import com.mr208.rewired.common.util.CyberwareHelper;
import com.mr208.rewired.common.util.ModdedStuff;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUserDataImpl;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemSwordCyberware;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber(modid="rewired")
public class EntityDrops {
    private static ArrayList<Class> augmentedEntityClasses = new ArrayList();
    private static ArrayList<Class> bodyPartEntityClasses = new ArrayList();
    private static ArrayList<Class> necroticLimbEntityClasses = new ArrayList();

    public static void onPostInit() {
        EntityEntry entityEntry;
        for (String entry : ConfigHandler.Entities.augmentation.additionCyberEntities) {
            entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entry));
            if (entityEntry == null) continue;
            ReWIRED.LOGGER.info("Found Entry for {}, Let's do some upgrades", (Object)entry);
            augmentedEntityClasses.add(entityEntry.getEntityClass());
        }
        ReWIRED.LOGGER.info("{} Entities have been registered for augmentation", (Object)augmentedEntityClasses.size());
        for (String entry : ConfigHandler.Entities.bodyPartEntities) {
            entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entry));
            if (entityEntry == null) continue;
            ReWIRED.LOGGER.info("Found an Entry for {}, Making them drop Body Parts", (Object)entry);
            bodyPartEntityClasses.add(entityEntry.getEntityClass());
        }
        ReWIRED.LOGGER.info("{} Entities have been registered to drop Body Parts", (Object)bodyPartEntityClasses.size());
        for (String entry : ConfigHandler.Entities.necroPartEntities) {
            entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entry));
            if (entityEntry == null) continue;
            ReWIRED.LOGGER.info("Found an Entry for {}, Making them drop Necrotic Limbs", (Object)entry);
            necroticLimbEntityClasses.add(entityEntry.getEntityClass());
        }
        ReWIRED.LOGGER.info("{} Entities have been registered to drop Necrotic Limbs", (Object)necroticLimbEntityClasses.size());
    }

    @SubscribeEvent
    public static void attachCyberwareData(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase && augmentedEntityClasses.contains(((Entity)event.getObject()).getClass())) {
            event.addCapability(CyberwareUserDataImpl.Provider.NAME, (ICapabilityProvider)new CyberwareUserDataImpl.Provider());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving().field_70173_aa == 1 && augmentedEntityClasses.contains(event.getEntityLiving().getClass())) {
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            CyberwareHelper.addRandomCyberware(entityLivingBase, true);
        }
    }

    @SubscribeEvent
    public static void entityDeathEvent(LivingDropsEvent event) {
        EntityPlayer player;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        World world = entityLivingBase.func_130014_f_();
        float rarity = Math.min(100.0f, CyberwareConfig.MOBS_CYBER_ZOMBIE_DROP_RARITY + (float)event.getLootingLevel() * 5.0f);
        if (augmentedEntityClasses.contains(entityLivingBase.getClass())) {
            ICyberwareUserData cyberware = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
            if (cyberware == null) {
                return;
            }
            if (world.field_73012_v.nextFloat() < rarity / 100.0f) {
                int count;
                ArrayList<ItemStack> allWares = new ArrayList<ItemStack>();
                for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                    NonNullList stuff = cyberware.getInstalledCyberware(slot);
                    for (ItemStack stack : stuff) {
                        if (stack.func_190926_b()) continue;
                        allWares.add(stack);
                    }
                }
                allWares.removeAll(Collections.singleton(null));
                ItemStack drop = null;
                for (count = 0; count < 50 && (drop == null || drop.func_77973_b() == CyberwareContent.creativeBattery || drop.func_77973_b() == CyberwareContent.bodyPart); ++count) {
                    int random = world.field_73012_v.nextInt(allWares.size());
                    drop = ((ItemStack)allWares.get(random)).func_77946_l();
                    drop = CyberwareAPI.sanitize((ItemStack)drop);
                    drop = CyberwareAPI.getCyberware((ItemStack)drop).setQuality(drop, CyberwareAPI.QUALITY_SCAVENGED);
                    drop.func_190920_e(1);
                }
                if (count < 50) {
                    event.getDrops().add(new EntityItem(world, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, drop));
                }
            }
        }
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemSwordCyberware) {
            ItemStack toDrop;
            float headRarity = Math.min(100.0f, 5.0f * (float)(event.getLootingLevel() + 1));
            if (world.field_73012_v.nextFloat() < headRarity / 100.0f) {
                event.getDrops().add(new EntityItem(world, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, EntityDrops.getSkull((Entity)entityLivingBase).func_77946_l()));
            }
            if (necroticLimbEntityClasses.contains(entityLivingBase.getClass()) && world.field_73012_v.nextFloat() < rarity / 100.0f) {
                toDrop = ReWIREDContent.limbsNecro.getCachedStack(world.field_73012_v.nextInt(4)).func_77946_l();
                event.getDrops().add(new EntityItem(world, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, toDrop));
            }
            if (bodyPartEntityClasses.contains(entityLivingBase.getClass()) && world.field_73012_v.nextFloat() < rarity / 100.0f) {
                toDrop = new ItemStack(CyberwareContent.bodyPart, 1, world.field_73012_v.nextInt(12));
                event.getDrops().add(new EntityItem(world, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, toDrop));
            }
        }
    }

    protected static ItemStack getSkull(Entity entity) {
        if (entity instanceof EntitySkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (entity instanceof EntityWitherSkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 1);
        }
        if (entity instanceof EntityZombie) {
            return new ItemStack(Items.field_151144_bL, 1, 2);
        }
        if (entity instanceof EntityCreeper) {
            return new ItemStack(Items.field_151144_bL, 1, 4);
        }
        if (entity instanceof EntityPlayer) {
            ItemStack playerSkull = new ItemStack(Items.field_151144_bL, 1, 3);
            playerSkull.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)tag, (GameProfile)((EntityPlayer)entity).func_146103_bH());
            playerSkull.func_77978_p().func_74782_a("SkullOwner", (NBTBase)tag);
            return playerSkull.func_77946_l();
        }
        if (entity instanceof EntityEnderman && ModdedStuff.EnderIO.block_enderman_skull != null) {
            return new ItemStack(ModdedStuff.EnderIO.block_enderman_skull, 1, 0);
        }
        return ItemStack.field_190927_a;
    }
}

