/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.handlers.packets;

import com.mr208.rewired.common.handlers.NetworkHandler;
import com.mr208.rewired.common.handlers.packets.PacketReturnInfo;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetInfo
implements IMessage {
    private int dim;
    private BlockPos pos;
    private ProbeMode mode;
    private EnumFacing sideHit;
    private Vec3d hitVec;
    private ItemStack pickBlock;

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.mode = ProbeMode.values()[buf.readByte()];
        byte sideByte = buf.readByte();
        this.sideHit = sideByte == 127 ? null : EnumFacing.values()[sideByte];
        if (buf.readBoolean()) {
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        this.pickBlock = buf.readBoolean() ? NetworkTools.readItemStack((ByteBuf)buf) : ItemStack.field_190927_a;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeByte(this.mode.ordinal());
        buf.writeByte(this.sideHit == null ? 127 : this.sideHit.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.field_72450_a);
            buf.writeDouble(this.hitVec.field_72448_b);
            buf.writeDouble(this.hitVec.field_72449_c);
        }
        if (this.pickBlock.func_190926_b()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.pickBlock);
        }
    }

    public PacketGetInfo() {
    }

    public PacketGetInfo(int dim, BlockPos pos, ProbeMode mode, RayTraceResult mouseOver, ItemStack pickBlock) {
        this.dim = dim;
        this.pos = pos;
        this.mode = mode;
        this.sideHit = mouseOver.field_178784_b;
        this.hitVec = mouseOver.field_72307_f;
        this.pickBlock = pickBlock;
    }

    private static ProbeInfo getProbeInfo(EntityPlayer player, ProbeMode mode, World world, BlockPos blockPos, EnumFacing sideHit, Vec3d hitVec, ItemStack pickBlock) {
        mode = player.func_70093_af() && player.func_184614_ca() == null ? ProbeMode.EXTENDED : ProbeMode.NORMAL;
        IBlockState state = world.func_180495_p(blockPos);
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitData data = new ProbeHitData(blockPos, hitVec, sideHit, pickBlock);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, state, (IProbeHitData)data);
        }
        Config.setRealConfig((IProbeConfig)probeConfig);
        List providers = TheOneProbe.theOneProbeImp.getProviders();
        for (IProbeInfoProvider provider : providers) {
            try {
                provider.addProbeInfo(mode, (IProbeInfo)probeInfo, player, world, state, (IProbeHitData)data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable((Throwable)e);
                probeInfo.text(TextStyleClass.LABEL + "Error: " + TextStyleClass.ERROR + provider.getID());
            }
        }
        return probeInfo;
    }

    public static class Handler
    implements IMessageHandler<PacketGetInfo, IMessage> {
        public IMessage onMessage(PacketGetInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetInfo message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world != null) {
                ProbeInfo probeInfo = PacketGetInfo.getProbeInfo((EntityPlayer)ctx.getServerHandler().field_147369_b, message.mode, (World)world, message.pos, message.sideHit, message.hitVec, message.pickBlock);
                NetworkHandler.INSTANCE.sendTo((IMessage)new PacketReturnInfo(message.dim, message.pos, probeInfo), ctx.getServerHandler().field_147369_b);
            }
        }
    }
}

