/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.mr208.rewired.ReWIRED;
import com.mr208.rewired.common.items.ItemReWIRED;
import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.ICyberwareTabItem;
import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAugment
extends ItemReWIRED
implements ICyberware,
ICyberwareTabItem,
IDeconstructable,
IMenuItem {
    private ICyberware.EnumSlot[] slots;
    private int[] essence;
    private NonNullList<NonNullList<ItemStack>> components;
    private int[] weight;
    private final ItemStack[] cachedStacks;
    private final float[] enabledColor = new float[]{1.0f, 0.0f, 0.0f};

    public ItemAugment(String name, ICyberware.EnumSlot[] slots, String[] subnames) {
        super(name, subnames);
        this.slots = slots;
        this.essence = new int[subnames.length + 1];
        this.weight = new int[subnames.length + 1];
        this.components = NonNullList.func_191196_a();
        this.cachedStacks = new ItemStack[Math.max(subnames.length, 1)];
        this.func_77637_a(Cyberware.creativeTab);
    }

    public ItemAugment(String name, ICyberware.EnumSlot slot, String[] subnames) {
        this(name, new ICyberware.EnumSlot[]{slot}, subnames);
    }

    public ItemAugment(String name, ICyberware.EnumSlot slot) {
        this(name, slot, new String[0]);
    }

    public int getWeight(ItemStack stack) {
        return this.weight[stack.func_77952_i()];
    }

    public ItemAugment setWeights(int ... weights) {
        this.weight = new int[weights.length];
        for (int meta = 0; meta < weights.length; ++meta) {
            ItemStack stack = new ItemStack((Item)this, 1, meta);
            int installedStackSize = this.installedStackSize(stack);
            stack.func_190920_e(installedStackSize);
            this.setQuality(stack, CyberwareAPI.QUALITY_SCAVENGED);
            CyberwareContent.zombieItems.add(new CyberwareContent.ZombieItem(weights[meta], stack));
            this.weight[meta] = weights[meta];
        }
        return this;
    }

    public ItemAugment setEssenceCost(int ... essence) {
        this.essence = essence;
        return this;
    }

    public ItemAugment setComponents(NonNullList<ItemStack> ... components) {
        NonNullList list = NonNullList.func_191196_a();
        for (NonNullList<ItemStack> l : components) {
            list.add(l);
        }
        this.components = list;
        return this;
    }

    public int getEssenceCost(ItemStack itemStack) {
        int cost = this.getUnmodifiedEssenceCost(itemStack);
        if (this.getQuality(itemStack) == CyberwareAPI.QUALITY_SCAVENGED) {
            float half = (float)cost / 2.0f;
            cost = cost > 0 ? (cost += (int)Math.ceil(half)) : (cost -= (int)Math.ceil(half));
        }
        return cost;
    }

    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        return this.essence[Math.min(this.subNames.length, stack.func_77952_i())];
    }

    public ICyberware.EnumSlot getSlot(ItemStack itemStack) {
        return this.slots[Math.min(this.slots.length - 1, itemStack.func_77952_i())];
    }

    public int installedStackSize(ItemStack itemStack) {
        return 1;
    }

    public boolean isIncompatible(ItemStack itemStack, ItemStack itemStack1) {
        return false;
    }

    public boolean isEssential(ItemStack itemStack) {
        return false;
    }

    public List<String> getInfo(ItemStack itemStack) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> desc = this.getDescription(itemStack);
        if (desc != null && desc.size() > 0) {
            ret.addAll(desc);
        }
        return ret;
    }

    public List<String> getStackDesc(ItemStack itemStack) {
        String[] toReturnArray = I18n.func_135052_a((String)("cyberware.tooltip." + this.getRegistryName().toString().substring(8) + (this.subNames.length > 0 ? "." + itemStack.func_77952_i() : "")), (Object[])new Object[0]).split("\\\\n");
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(toReturnArray));
        if (toReturn.size() > 0 && ((String)toReturn.get(0)).length() == 0) {
            toReturn.remove(0);
        }
        return toReturn;
    }

    public List<String> getDescription(ItemStack stack) {
        List<String> toReturn = this.getStackDesc(stack);
        if (this.installedStackSize(stack) > 1) {
            toReturn.add(ChatFormatting.BLUE + I18n.func_135052_a((String)"cyberware.tooltip.max_install", (Object[])new Object[]{this.installedStackSize(stack)}));
        }
        boolean hasPowerConsumption = false;
        String toAddPowerConsumption = "";
        for (int i = 0; i < this.installedStackSize(stack); ++i) {
            ItemStack temp = stack.func_77946_l();
            temp.func_190920_e(i + 1);
            int cost = this.getPowerConsumption(temp);
            if (cost > 0) {
                hasPowerConsumption = true;
            }
            if (i != 0) {
                toAddPowerConsumption = toAddPowerConsumption + I18n.func_135052_a((String)"cyberware.tooltip.joiner", (Object[])new Object[0]);
            }
            toAddPowerConsumption = toAddPowerConsumption + " " + cost;
        }
        if (hasPowerConsumption) {
            String toTranslate = this.hasCustomPowerMessage(stack) ? "cyberware.tooltip." + this.getRegistryName().toString().substring(8) + (this.subNames.length > 0 ? "." + stack.func_77952_i() : "") + ".power_consumption" : "cyberware.tooltip.power_consumption";
            toReturn.add(ChatFormatting.GREEN + I18n.func_135052_a((String)toTranslate, (Object[])new Object[]{toAddPowerConsumption}));
        }
        boolean hasPowerProduction = false;
        String toAddPowerProduction = "";
        for (int i = 0; i < this.installedStackSize(stack); ++i) {
            ItemStack temp = stack.func_77946_l();
            temp.func_190920_e(i + 1);
            int cost = this.getPowerProduction(temp);
            if (cost > 0) {
                hasPowerProduction = true;
            }
            if (i != 0) {
                toAddPowerProduction = toAddPowerProduction + I18n.func_135052_a((String)"cyberware.tooltip.joiner", (Object[])new Object[0]);
            }
            toAddPowerProduction = toAddPowerProduction + " " + cost;
        }
        if (hasPowerProduction) {
            String toTranslate = this.hasCustomPowerMessage(stack) ? "cyberware.tooltip." + this.getRegistryName().toString().substring(8) + (this.subNames.length > 0 ? "." + stack.func_77952_i() : "") + ".power_production" : "cyberware.tooltip.power_production";
            toReturn.add(ChatFormatting.GREEN + I18n.func_135052_a((String)toTranslate, (Object[])new Object[]{toAddPowerProduction}));
        }
        if (this.getCapacity(stack) > 0) {
            String toTranslate = this.hasCustomCapacityMessage(stack) ? "cyberware.tooltip." + this.getRegistryName().toString().substring(8) + (this.subNames.length > 0 ? "." + stack.func_77952_i() : "") + ".capacity" : "cyberware.tooltip.capacity";
            toReturn.add(ChatFormatting.GREEN + I18n.func_135052_a((String)toTranslate, (Object[])new Object[]{this.getCapacity(stack)}));
        }
        boolean hasEssenceCost = false;
        boolean essenceCostNegative = true;
        String toAddEssence = "";
        for (int i = 0; i < this.installedStackSize(stack); ++i) {
            ItemStack temp = stack.func_77946_l();
            temp.func_190920_e(i + 1);
            int cost = this.getEssenceCost(temp);
            if (cost != 0) {
                hasEssenceCost = true;
            }
            if (cost < 0) {
                essenceCostNegative = false;
            }
            if (i != 0) {
                toAddEssence = toAddEssence + I18n.func_135052_a((String)"cyberware.tooltip.joiner", (Object[])new Object[0]);
            }
            toAddEssence = toAddEssence + " " + Math.abs(cost);
        }
        if (hasEssenceCost) {
            toReturn.add(ChatFormatting.DARK_PURPLE + I18n.func_135052_a((String)(essenceCostNegative ? "cyberware.tooltip.essence" : "cyberware.tooltip.essence_add"), (Object[])new Object[]{toAddEssence}));
        }
        return toReturn;
    }

    public int getPowerConsumption(ItemStack itemStack) {
        return 0;
    }

    public int getPowerProduction(ItemStack itemStack) {
        return 0;
    }

    public boolean hasCustomPowerMessage(ItemStack itemStack) {
        return false;
    }

    public boolean hasCustomCapacityMessage(ItemStack itemStack) {
        return false;
    }

    public NonNullList<NonNullList<ItemStack>> required(ItemStack itemStack) {
        return NonNullList.func_191196_a();
    }

    public ICyberwareTabItem.EnumCategory getCategory(ItemStack itemStack) {
        return ICyberwareTabItem.EnumCategory.values()[this.getSlot(itemStack).ordinal()];
    }

    public int getCapacity(ItemStack itemStack) {
        return 0;
    }

    public void onAdded(EntityLivingBase entityLivingBase, ItemStack itemStack) {
    }

    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack itemStack) {
    }

    public boolean canDestroy(ItemStack itemStack) {
        return itemStack.func_77952_i() < this.components.size();
    }

    public NonNullList<ItemStack> getComponents(ItemStack itemStack) {
        return (NonNullList)this.components.get(Math.min(this.components.size() - 1, itemStack.func_77952_i()));
    }

    public ICyberware.Quality getQuality(ItemStack itemStack) {
        ICyberware.Quality q = CyberwareAPI.getQualityTag((ItemStack)itemStack);
        if (q == null) {
            return CyberwareAPI.QUALITY_MANUFACTURED;
        }
        return q;
    }

    public ItemStack setQuality(ItemStack itemStack, ICyberware.Quality quality) {
        if (quality == CyberwareAPI.QUALITY_MANUFACTURED) {
            if (!itemStack.func_190926_b() && itemStack.func_77942_o()) {
                itemStack.func_77978_p().func_82580_o("cyberwareQuality");
                if (itemStack.func_77978_p().func_82582_d()) {
                    itemStack.func_77982_d(null);
                }
            }
            return itemStack;
        }
        return this.canHoldQuality(itemStack, quality) ? CyberwareAPI.writeQualityTag((ItemStack)itemStack, (ICyberware.Quality)quality) : itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack itemStack) {
        ICyberware.Quality q = this.getQuality(itemStack);
        if (q != null && q.getNameModifier() != null) {
            return I18n.func_135052_a((String)q.getNameModifier(), (Object[])new Object[]{("" + I18n.func_135052_a((String)(this.func_77657_g(itemStack) + ".name"), (Object[])new Object[0])).trim()}).trim();
        }
        return "" + I18n.func_135052_a((String)(this.func_77657_g(itemStack) + ".name"), (Object[])new Object[0]).trim();
    }

    public boolean canHoldQuality(ItemStack itemStack, ICyberware.Quality quality) {
        return true;
    }

    protected boolean isAugmentEnabled(EntityPlayer player, ItemStack augment) {
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)player);
        return data != null && EnableDisableHelper.isEnabled((ItemStack)data.getCyberware(augment));
    }

    protected boolean isAugmentEnabled(EntityLivingBase entityLivingBase, ItemStack augment) {
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        return data != null && EnableDisableHelper.isEnabled((ItemStack)data.getCyberware(augment));
    }

    public boolean hasMenu(ItemStack itemStack) {
        return false;
    }

    public void use(Entity entity, ItemStack itemStack) {
        EnableDisableHelper.toggle((ItemStack)itemStack);
    }

    public String getUnlocalizedLabel(ItemStack itemStack) {
        return EnableDisableHelper.getUnlocalizedLabel((ItemStack)itemStack);
    }

    public float[] getColor(ItemStack itemStack) {
        return EnableDisableHelper.isEnabled((ItemStack)itemStack) ? this.enabledColor : null;
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            if (this.subNames.length == 0) {
                items.add((Object)new ItemStack((Item)this));
            }
            for (int i = 0; i < this.subNames.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public ItemStack getCachedStack(int damage) {
        ItemStack itemStack = this.cachedStacks[damage];
        if (!(itemStack == null || itemStack.func_77973_b().getClass().isAssignableFrom(((Object)((Object)this)).getClass()) && itemStack.func_190916_E() == 1 && this.getDamage(itemStack) == damage)) {
            ReWIRED.LOGGER.error(String.format("Corrupted item stack cache: found %s as %s:%d, expected %s:%d", new Object[]{itemStack, itemStack.func_77973_b(), itemStack.func_77952_i(), this, damage}));
            itemStack = null;
        }
        if (itemStack == null) {
            this.cachedStacks[damage] = itemStack = new ItemStack((Item)this, 1, damage);
        }
        return itemStack;
    }
}

