/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments;

import com.mr208.rewired.common.handlers.ConfigHandler;
import com.mr208.rewired.common.items.augments.ItemAugment;
import com.mr208.rewired.common.items.equipment.INeuralInterlinkItem;
import com.mr208.rewired.common.util.CyberwareHelper;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemCraniumAugment
extends ItemAugment {
    protected static List<Item> BLACKLIST;
    public static final int META_ECD = 0;
    public static final int META_NEURAL_INT = 1;

    public ItemCraniumAugment(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public int getPowerConsumption(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            return ConfigHandler.Augments.ecd.ENERGY_COST;
        }
        return super.getPowerConsumption(itemStack);
    }

    @Override
    public boolean hasCustomPowerMessage(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            return true;
        }
        return super.hasCustomPowerMessage(itemStack);
    }

    @Override
    public boolean hasMenu(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            return true;
        }
        return super.hasMenu(itemStack);
    }

    @Override
    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.onRemoved(entityLivingBase, itemStack);
        if (itemStack.func_77952_i() == 1 && entityLivingBase instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (!(stack.func_77973_b() instanceof INeuralInterlinkItem) || !((INeuralInterlinkItem)stack.func_77973_b()).isNeuralInterfaceRequired(stack)) continue;
                EntityEquipmentSlot entityEquipmentSlot = EntityLiving.func_184640_d((ItemStack)stack);
                player.func_184201_a(entityEquipmentSlot, ItemStack.field_190927_a);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack.func_77946_l());
            }
        }
    }

    @SubscribeEvent
    public void onCyberUpdate(CyberwareUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (!entityLivingBase.field_70170_p.field_72995_K && entityLivingBase.field_70173_aa % 20 == 0 && CyberwareHelper.isAugmentAvailable(entityLivingBase, this.getCachedStack(0))) {
            EnderTeleportEvent teleportEvent;
            if (BLACKLIST == null) {
                this.populateBlacklist();
            }
            double x = entityLivingBase.field_70165_t;
            double y = entityLivingBase.field_70163_u;
            double z = entityLivingBase.field_70161_v;
            List itemsInRange = entityLivingBase.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(x - (double)ConfigHandler.Augments.ecd.RANGE, y - (double)ConfigHandler.Augments.ecd.RANGE, z - (double)ConfigHandler.Augments.ecd.RANGE, x + (double)ConfigHandler.Augments.ecd.RANGE, y + (double)ConfigHandler.Augments.ecd.RANGE, z + (double)ConfigHandler.Augments.ecd.RANGE));
            ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
            boolean hasCollected = false;
            int maximum = 0;
            if (itemsInRange.size() > 0 && !MinecraftForge.EVENT_BUS.post((Event)(teleportEvent = new EnderTeleportEvent(entityLivingBase, x, y, z, 0.0f)))) {
                for (EntityItem item : itemsInRange) {
                    if (!this.canItemBeTeleported(item) || !(entityLivingBase.func_70032_d((Entity)item) > 2.0f)) continue;
                    if (maximum > ConfigHandler.Augments.ecd.AMOUNT || !data.usePower(this.getCachedStack(0), this.getPowerConsumption(this.getCachedStack(0)))) break;
                    item.func_70634_a(x, y + 0.75, z);
                    hasCollected = true;
                    ++maximum;
                }
                if (hasCollected && entityLivingBase.field_70173_aa % 80 == 0) {
                    entityLivingBase.field_70170_p.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.6f, 1.0f);
                }
                CyberwareAPI.updateData((Entity)entityLivingBase);
            }
        }
    }

    private boolean canItemBeTeleported(EntityItem item) {
        if (item.field_70128_L) {
            return false;
        }
        if (BLACKLIST.contains(item.func_92059_d().func_77973_b())) {
            return false;
        }
        NBTTagCompound nbtTagCompound = item.getEntityData();
        if (nbtTagCompound.func_74764_b("PreventRemoteMovement")) {
            return false;
        }
        return !nbtTagCompound.func_74764_b("EIOPuller");
    }

    private void populateBlacklist() {
        BLACKLIST = new ArrayList<Item>();
        for (String item : ConfigHandler.Augments.ecd.BLACKLIST) {
            Item blItem;
            String[] blacklistedItem = item.split(":");
            if (blacklistedItem.length != 2 || (blItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(blacklistedItem[0], blacklistedItem[1]))) == null) continue;
            BLACKLIST.add(blItem);
        }
    }
}

