/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments;

import com.mr208.rewired.common.handlers.ConfigHandler;
import com.mr208.rewired.common.handlers.NetworkHandler;
import com.mr208.rewired.common.handlers.packets.PacketEntityMovement;
import com.mr208.rewired.common.items.augments.ItemAugment;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.misc.NNLUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemHandAugment
extends ItemAugment {
    public static final int META_FIST = 0;
    public static final int META_PKB = 1;
    private static ItemStack pickCache;
    @GameRegistry.ObjectHolder(value="cyberware:hand_upgrades")
    public static final Item CYBERWARE_HAND_UPGRADE;
    private static final float[] f;

    public ItemHandAugment(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean hasCustomPowerMessage(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1;
    }

    @Override
    public int getPowerConsumption(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1 ? ConfigHandler.Augments.pkb.ENERGY_COST : super.getPowerConsumption(itemStack);
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> required(ItemStack itemStack) {
        return NNLUtil.fromArray((ItemStack[][])new ItemStack[][]{{CyberwareContent.cyberlimbs.getCachedStack(0), CyberwareContent.cyberlimbs.getCachedStack(1)}});
    }

    @Override
    public boolean isIncompatible(ItemStack itemStack, ItemStack otherStack) {
        return otherStack.func_77973_b() == this || otherStack.func_77973_b() == CYBERWARE_HAND_UPGRADE;
    }

    @Override
    public boolean hasMenu(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1;
    }

    @Override
    public void use(Entity entity, ItemStack itemStack) {
        EnableDisableHelper.toggle((ItemStack)itemStack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack itemStack) {
        return EnableDisableHelper.getUnlocalizedLabel((ItemStack)itemStack);
    }

    @Override
    public float[] getColor(ItemStack itemStack) {
        return (float[])(EnableDisableHelper.isEnabled((ItemStack)itemStack) ? f : null);
    }

    @SubscribeEvent
    public void handleMineSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer p = event.getEntityPlayer();
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)p);
        if (this.isPrimaryLimbCybernetic(p) && data != null && data.isCyberwareInstalled(this.getCachedStack(0)) && p.func_184614_ca().func_190926_b()) {
            event.setNewSpeed(event.getNewSpeed() * ItemHandAugment.getPickCache().func_150997_a(event.getState()));
        }
    }

    @SubscribeEvent
    public void handleMining(PlayerEvent.HarvestCheck event) {
        EntityPlayer p = event.getEntityPlayer();
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)p);
        if (this.isPrimaryLimbCybernetic(p) && data != null && data.isCyberwareInstalled(this.getCachedStack(0)) && p.func_184614_ca().func_190926_b() && ItemHandAugment.getPickCache().func_150998_b(event.getTargetBlock())) {
            event.setCanHarvest(true);
        }
    }

    private boolean isPrimaryLimbCybernetic(EntityPlayer player) {
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)player);
        return data != null && (player.func_184591_cq() == EnumHandSide.RIGHT ? data.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(1)) : data.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(0)));
    }

    @SubscribeEvent
    public void onProjectileHit(LivingAttackEvent event) {
        if (!event.getSource().func_76352_a() || event.getSource().func_76363_c()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)event.getEntityLiving());
        if (cyberwareUserData == null) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        World world = player.func_130014_f_();
        ItemStack test = new ItemStack((Item)this, 1, 1);
        if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(1)) && this.isAugmentEnabled(player, this.getCachedStack(1)) && cyberwareUserData.usePower(test, ConfigHandler.Augments.pkb.ENERGY_COST, false)) {
            Entity projectile = null;
            if (event.getSource().func_76364_f() != null) {
                projectile = event.getSource().func_76364_f();
            }
            double difference = 0.0;
            Vec3d vectorMotion = null;
            Vec3d vectorLook = null;
            if (projectile != null) {
                vectorMotion = new Vec3d(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y);
                vectorLook = player.func_70040_Z();
                difference = -vectorLook.func_72430_b(vectorMotion.func_72432_b());
            }
            if (difference < 0.1) {
                return;
            }
            cyberwareUserData.updateCapacity();
            if (!player.field_70170_p.field_72995_K) {
                CyberwareAPI.updateData((Entity)player);
            }
            event.setCanceled(true);
            if (this.getQuality(cyberwareUserData.getCyberware(new ItemStack((Item)this))).equals(CyberwareAPI.QUALITY_MANUFACTURED)) {
                player.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 2.5f);
                double returnSpeed = projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y;
                returnSpeed = Math.sqrt(returnSpeed);
                projectile.field_70159_w = vectorLook.field_72450_a * (returnSpeed += 0.5);
                projectile.field_70181_x = vectorLook.field_72448_b * returnSpeed;
                projectile.field_70179_y = vectorLook.field_72449_c * returnSpeed;
                projectile.field_70177_z = (float)(Math.atan2(projectile.field_70159_w, projectile.field_70179_y) * 180.0 / Math.PI);
                projectile.field_70125_A = (float)(Math.atan2(projectile.field_70181_x, returnSpeed) * 180.0 / Math.PI);
                NetworkHandler.INSTANCE.sendToAll((IMessage)new PacketEntityMovement(projectile));
                if (projectile instanceof IProjectile) {
                    projectile.field_70159_w /= (double)-0.1f;
                    projectile.field_70181_x /= (double)-0.1f;
                    projectile.field_70179_y /= (double)-0.1f;
                }
            }
        }
    }

    public static ItemStack getPickCache() {
        if (pickCache == null || pickCache.func_190926_b()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ConfigHandler.Augments.plasteelFist.PICK));
            if (item == Items.field_190931_a || item == null) {
                item = Items.field_151035_b;
            }
            pickCache = new ItemStack(item);
        }
        return pickCache;
    }

    static {
        CYBERWARE_HAND_UPGRADE = null;
        f = new float[]{1.0f, 0.0f, 0.0f};
    }
}

