/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments;

import com.mr208.rewired.common.handlers.ConfigHandler;
import com.mr208.rewired.common.handlers.NetworkHandler;
import com.mr208.rewired.common.handlers.packets.PacketParticle;
import com.mr208.rewired.common.items.augments.ItemAugment;
import com.mr208.rewired.common.util.CyberwareHelper;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemTorsoAugment
extends ItemAugment
implements ICyberware {
    public static final int META_DERPS = 0;
    public static final int META_CYBERSTOMACH = 1;

    public ItemTorsoAugment(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public int getPowerConsumption(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            return ConfigHandler.Augments.derps.ENERGY_COST;
        }
        return super.getPowerConsumption(itemStack);
    }

    @Override
    public boolean isIncompatible(ItemStack augment, ItemStack otherAugment) {
        return augment.func_77952_i() == 1 && CyberwareAPI.getCyberware((ItemStack)otherAugment).isEssential(otherAugment);
    }

    @Override
    public boolean isEssential(ItemStack augment) {
        return augment.func_77952_i() == 1;
    }

    @Override
    public boolean hasMenu(ItemStack itemStack) {
        return itemStack.func_77952_i() == 0;
    }

    @Override
    public boolean hasCustomPowerMessage(ItemStack itemStack) {
        return itemStack.func_77952_i() == 0;
    }

    @SubscribeEvent
    public void onCyberwareUpdate(CyberwareUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntityLiving().field_70122_E) {
            return;
        }
        if (event.getEntityLiving().func_184218_aH()) {
            return;
        }
        if (event.getEntityLiving().func_70090_H()) {
            return;
        }
        if (event.getEntityLiving().func_70617_f_()) {
            return;
        }
        if (event.getEntityLiving().func_184613_cA()) {
            return;
        }
        if (event.getEntityLiving().field_70160_al) {
            return;
        }
        if (event.getEntityLiving().field_70181_x > -0.75) {
            return;
        }
        if (CyberwareHelper.isAugmentAvailable(event.getEntityLiving(), this.getCachedStack(0))) {
            EnderTeleportEvent enderTeleportEvent;
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            World world = entityLivingBase.func_130014_f_();
            BlockPos topPos = this.getTopSolidOrLiquidBlock(world, entityLivingBase.func_180425_c());
            if (topPos.func_177956_o() < 1) {
                return;
            }
            if (world.func_180495_p(topPos).func_185904_a() == Material.field_151586_h || world.func_180495_p(topPos).func_185904_a() == Material.field_151587_i) {
                return;
            }
            int distance = entityLivingBase.func_180425_c().func_177956_o() - topPos.func_177956_o() + 3;
            if (distance > 0 && !MinecraftForge.EVENT_BUS.post((Event)(enderTeleportEvent = new EnderTeleportEvent(entityLivingBase, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, 0.0f)))) {
                World entityWorld = entityLivingBase.func_130014_f_();
                ICyberwareUserData data = CyberwareAPI.getCapability((Entity)entityLivingBase);
                int entityPower = data.getStoredPower();
                if (distance * this.getPowerConsumption(new ItemStack((Item)this, 1, 0)) <= entityPower) {
                    data.usePower(new ItemStack((Item)this, 1, 0), distance * this.getPowerConsumption(new ItemStack((Item)this, 1, 0)));
                    entityLivingBase.field_70181_x = 0.0;
                    entityLivingBase.func_184595_k((double)topPos.func_177958_n(), (double)(topPos.func_177956_o() + 3), (double)topPos.func_177952_p());
                } else {
                    int maxBlocks = Math.floorDiv(entityPower, this.getPowerConsumption(new ItemStack((Item)this, 1, 0)));
                    data.usePower(new ItemStack((Item)this, 1, 0), maxBlocks * this.getPowerConsumption(new ItemStack((Item)this, 1, 0)));
                    entityLivingBase.field_70181_x = 0.0;
                    entityLivingBase.func_184595_k((double)topPos.func_177958_n(), (double)(topPos.func_177956_o() + 3 + distance - maxBlocks), (double)topPos.func_177952_p());
                }
                PacketParticle pkt = new PacketParticle(entityLivingBase.func_180425_c(), 1);
                NetworkHandler.INSTANCE.sendToAllTracking((IMessage)pkt, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, 32.0));
                entityWorld.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                data.updateCapacity();
                if (!entityLivingBase.field_70170_p.field_72995_K) {
                    CyberwareAPI.updateData((Entity)entityLivingBase);
                }
            }
        }
    }

    public BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    @SubscribeEvent
    public void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)entity);
        if (entity instanceof EntityPlayer && data != null && !stack.func_190926_b() && this.isFood(stack) && data.isCyberwareInstalled(this.getCachedStack(1))) {
            ((EntityPlayer)event.getEntity()).func_71024_bL().func_75122_a(2, 2.0f);
        }
    }

    private boolean isFood(ItemStack itemStack) {
        if (itemStack.func_77975_n() == EnumAction.EAT) {
            return true;
        }
        return itemStack.func_77975_n() == EnumAction.DRINK && !(itemStack.func_77973_b() instanceof ItemPotion);
    }
}

