/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments;

import com.google.common.collect.HashMultimap;
import com.mr208.rewired.common.items.IAttributeAugment;
import com.mr208.rewired.common.items.augments.ItemAugment;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemWoodenlimb
extends ItemAugment
implements ICyberware.ISidedLimb,
IAttributeAugment {
    private static HashMap<Integer, HashMultimap<String, AttributeModifier>> metaAttributes = new HashMap();
    public static final int META_LEFT_WOOD_ARM = 0;
    public static final int META_RIGHT_WOOD_ARM = 1;
    public static final int META_LEFT_WOOD_LEG = 2;
    public static final int META_RIGHT_WOOD_LEG = 3;

    public ItemWoodenlimb(String name, ICyberware.EnumSlot[] slots, String[] subnames) {
        super(name, slots, subnames);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)player);
        if (data == null) {
            return EnumActionResult.PASS;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        ICyberware.EnumSlot stackSlot = this.getSlot(heldStack);
        boolean missing = true;
        NonNullList installedStacks = data.getInstalledCyberware(stackSlot);
        for (ItemStack stack : installedStacks) {
            ICyberware installedAug;
            if (!missing || stack.func_190926_b() || !(installedAug = CyberwareAPI.getCyberware((ItemStack)stack)).isEssential(stack) || !installedAug.isIncompatible(stack, heldStack)) continue;
            missing = false;
        }
        if (missing) {
            installedStacks.add((Object)heldStack);
            data.setInstalledCyberware((EntityLivingBase)player, stackSlot, installedStacks);
            CyberwareAPI.updateData((Entity)player);
            if (!player.func_184812_l_()) {
                heldStack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean isEssential(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        ICyberware ware = CyberwareAPI.getCyberware((ItemStack)other);
        if (ware instanceof ICyberware.ISidedLimb) {
            return ware.isEssential(other) && ((ICyberware.ISidedLimb)ware).getSide(other) == this.getSide(stack);
        }
        return false;
    }

    public ICyberware.ISidedLimb.EnumSide getSide(ItemStack itemStack) {
        return itemStack.func_77952_i() % 2 == 0 ? ICyberware.ISidedLimb.EnumSide.LEFT : ICyberware.ISidedLimb.EnumSide.RIGHT;
    }

    @Override
    public List<String> getStackDesc(ItemStack itemStack) {
        List<String> list = super.getStackDesc(itemStack);
        list.addAll(this.getAttributeDesc(itemStack));
        return list;
    }

    @Override
    public int getPowerConsumption(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean canHoldQuality(ItemStack itemStack, ICyberware.Quality quality) {
        return false;
    }

    @Override
    public ICyberware.Quality getQuality(ItemStack itemStack) {
        return super.getQuality(itemStack);
    }

    @Override
    public HashMultimap<String, AttributeModifier> getAugmentAttributeModifiers(ItemStack stack) {
        if (metaAttributes.get(stack.func_77952_i()) == null) {
            int meta = stack.func_77952_i();
            HashMultimap map = HashMultimap.create();
            switch (meta) {
                case 0: {
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                    break;
                }
                case 1: {
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                    break;
                }
                case 2: {
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                    break;
                }
                case 3: {
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                }
            }
        }
        return metaAttributes.getOrDefault(stack.func_77952_i(), (HashMultimap<String, AttributeModifier>)HashMultimap.create());
    }

    @Override
    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        entityLivingBase.func_110140_aT().func_111148_a(this.getAugmentAttributeModifiers(itemStack));
    }

    @Override
    public void onAdded(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        entityLivingBase.func_110140_aT().func_111147_b(this.getAugmentAttributeModifiers(itemStack));
    }

    @SubscribeEvent
    public void handleJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)event.getEntity();
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (data != null) {
            for (int i = 0; i < 4; ++i) {
                ItemStack limbStack = data.getCyberware(this.getCachedStack(i));
                if (!limbStack.func_190926_b()) {
                    this.onAdded(entityLivingBase, data.getCyberware(limbStack));
                    continue;
                }
                this.onRemoved(entityLivingBase, limbStack);
            }
        }
    }
}

