/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments.overrides;

import com.google.common.collect.HashMultimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.mr208.rewired.common.items.IAttributeAugment;
import com.mr208.rewired.common.util.CyberwareHelper;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.ICyberwareTabItem;
import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.common.item.ItemCyberlimb;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCyberlimbOverride
extends ItemCyberlimb
implements ICyberware,
ICyberwareTabItem,
IDeconstructable,
ICyberware.ISidedLimb,
IAttributeAugment {
    private static HashMap<Integer, HashMultimap<String, AttributeModifier>> metaAttributes = new HashMap();
    private ItemStack[] cachedStacks;

    public ItemCyberlimbOverride(String name, ICyberware.EnumSlot[] slots, String[] subnames) {
        super("cyberware:" + name, slots, subnames);
        this.func_77655_b("cyberware." + name);
        MinecraftForge.EVENT_BUS.unregister(ItemCyberlimb.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.cachedStacks = new ItemStack[Math.max(subnames.length, 1)];
    }

    @Override
    public HashMultimap<String, AttributeModifier> getAugmentAttributeModifiers(ItemStack stack) {
        if (metaAttributes.get(stack.func_77952_i()) == null) {
            int meta = stack.func_77952_i();
            HashMultimap map = HashMultimap.create();
            switch (meta) {
                case 0: {
                    map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idArmLeft, "Limb bonus", 0.05, 1));
                    map.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idArmLeft, "Limb bonus", 2.0, 0));
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                    break;
                }
                case 1: {
                    map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idArmRight, "Limb bonus", 0.05, 1));
                    map.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idArmRight, "Limb bonus", 2.0, 0));
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                    break;
                }
                case 2: {
                    map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idLegLeft, "Limb bonus", 2.0, 0));
                    map.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idLegLeft, "Limb bonus", 2.0, 0));
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                    break;
                }
                case 3: {
                    map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idLegRight, "Limb bonus", 2.0, 0));
                    map.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(CyberwareHelper.idLegRight, "Limb bonus", 2.0, 0));
                    metaAttributes.put(meta, (HashMultimap<String, AttributeModifier>)map);
                }
            }
        }
        return metaAttributes.getOrDefault(stack.func_77952_i(), (HashMultimap<String, AttributeModifier>)HashMultimap.create());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(ChatFormatting.GOLD + I18n.func_135052_a((String)"tooltip.rewired.changed", (Object[])new Object[0]));
    }

    public List<String> getStackDesc(ItemStack stack) {
        List list = super.getStackDesc(stack);
        list.addAll(this.getAttributeDesc(stack));
        return list;
    }

    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack stack) {
        entityLivingBase.func_110140_aT().func_111148_a(this.getAugmentAttributeModifiers(stack));
    }

    public void onAdded(EntityLivingBase entityLivingBase, ItemStack stack) {
        entityLivingBase.func_110140_aT().func_111147_b(this.getAugmentAttributeModifiers(stack));
    }

    @SubscribeEvent
    public void handleJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)event.getEntity();
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (data != null) {
            for (int i = 0; i < 4; ++i) {
                ItemStack limbStack = data.getCyberware(this.getCachedStack(i));
                if (!limbStack.func_190926_b()) {
                    this.onAdded(entityLivingBase, data.getCyberware(limbStack));
                    continue;
                }
                this.onRemoved(entityLivingBase, limbStack);
            }
        }
    }

    public int getPowerConsumption(ItemStack stack) {
        return 2;
    }
}

