/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.builderpattern;

import com.lothrazar.cyclicmagic.block.builderpattern.BlockPatternBuilder;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.item.locationgps.ItemLocationGps;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPatternBuilder
extends TileEntityBaseMachineInvo
implements ITickable,
ITilePreviewToggle,
ITileRedstoneToggle {
    private static final int MAXIMUM = 32;
    private static final int TIMER_FULL = 20;
    private static final int TIMER_SKIP = 1;
    private int timer = 1;
    private int flipX = 0;
    private int flipY = 0;
    private int flipZ = 0;
    private int rotation = 0;
    private static Map<String, String> blockToItemOverrides = new HashMap<String, String>();
    private static final String NBT_SHAPEINDEX = "shapeindex";
    private int shapeIndex;
    public static final int SLOT_SRCA = 18;
    public static final int SLOT_SRCB = 19;
    public static final int SLOT_TARGET = 20;

    public TileEntityPatternBuilder() {
        super(21);
        this.initEnergy(new EnergyStore(64000), BlockPatternBuilder.FUEL_COST);
        this.setSlotsForBoth();
        this.syncBlockItemMap();
        this.needsRedstone = 0;
    }

    private void syncBlockItemMap() {
        blockToItemOverrides.put("minecraft:redstone_wire", "minecraft:redstone");
        blockToItemOverrides.put("minecraft:powered_repeater", "minecraft:repeater");
        blockToItemOverrides.put("minecraft:unpowered_repeater", "minecraft:repeater");
        blockToItemOverrides.put("minecraft:powered_comparator", "minecraft:comparator");
        blockToItemOverrides.put("minecraft:unpowered_comparator", "minecraft:comparator");
        blockToItemOverrides.put("minecraft:lit_redstone_ore", "minecraft:redstone_ore");
        blockToItemOverrides.put("minecraft:tripwire", "minecraft:string");
        blockToItemOverrides.put("minecraft:wall_sign", "minecraft:sign");
        blockToItemOverrides.put("minecraft:standing_sign", "minecraft:sign");
        blockToItemOverrides.put("minecraft:lit_furnace", "minecraft:furnace");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= 18) {
            return stack.func_77973_b() instanceof ItemLocationGps;
        }
        return true;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    private int findSlotForMatch(IBlockState stateToMatch) {
        int slot = -1;
        if (stateToMatch == null || stateToMatch.func_177230_c() == null) {
            return slot;
        }
        for (int i = 0; i < this.func_70302_i_() - 3; ++i) {
            String itemInSlot;
            String itemKey;
            ItemStack is = this.func_70301_a(i);
            if (UtilItemStack.isEmpty(is)) continue;
            Item itemFromState = Item.func_150898_a((Block)stateToMatch.func_177230_c());
            if (itemFromState == is.func_77973_b()) {
                slot = i;
                break;
            }
            String blockKey = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)stateToMatch.func_177230_c())).toString();
            if (!blockToItemOverrides.containsKey(blockKey) || !(itemKey = blockToItemOverrides.get(blockKey)).equalsIgnoreCase(itemInSlot = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)is.func_77973_b())).toString())) continue;
            slot = i;
            break;
        }
        return slot;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass < 2;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 0;
            List<BlockPos> shapeSrc = this.getSourceShape();
            List<BlockPos> shapeTarget = this.getTargetShape();
            if (shapeSrc.size() <= 0 || shapeTarget.size() <= 0) {
                return;
            }
            if (this.shapeIndex < 0 || this.shapeIndex >= shapeSrc.size()) {
                this.shapeIndex = 0;
            }
            BlockPos posSrc = shapeSrc.get(this.shapeIndex);
            BlockPos posTarget = shapeTarget.get(this.shapeIndex);
            if (this.renderParticles != 0) {
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posSrc);
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posTarget);
            }
            if (!this.field_145850_b.func_175623_d(posSrc) && this.field_145850_b.func_175623_d(posTarget)) {
                IBlockState stateToMatch = this.field_145850_b.func_180495_p(posSrc);
                int slot = this.findSlotForMatch(stateToMatch);
                if (slot < 0) {
                    ++this.shapeIndex;
                    return;
                }
                this.timer = 20;
                this.field_145850_b.func_175656_a(posTarget, stateToMatch);
                ++this.shapeIndex;
                this.func_70298_a(slot, 1);
            } else {
                this.timer = 1;
                ++this.shapeIndex;
            }
        }
    }

    public BlockPos getGpsTargetPos(int slot) {
        ItemStack gpsA = this.func_70301_a(slot);
        BlockPosDim targetA = ItemLocationGps.getPosition(gpsA);
        return targetA == null ? null : targetA.toBlockPos();
    }

    public List<BlockPos> getSourceShape() {
        BlockPos targetA = this.getGpsTargetPos(18);
        BlockPos targetB = this.getGpsTargetPos(19);
        if (targetA == null || targetB == null) {
            return new ArrayList<BlockPos>();
        }
        return UtilShape.cubeFilledSolid(this.field_145850_b, targetA, targetB);
    }

    private BlockPos getCenterSource() {
        BlockPos targetA = this.getGpsTargetPos(18);
        BlockPos targetB = this.getGpsTargetPos(19);
        if (targetA == null || targetB == null) {
            return null;
        }
        return new BlockPos((targetA.func_177958_n() + targetB.func_177958_n()) / 2, (targetA.func_177956_o() + targetB.func_177956_o()) / 2, (targetA.func_177952_p() + targetB.func_177952_p()) / 2);
    }

    private BlockPos getCenterTarget() {
        BlockPos otherCenter = this.getCenterSource();
        if (otherCenter == null) {
            return null;
        }
        return this.convertPosSrcToTarget(otherCenter);
    }

    private BlockPos convertPosSrcToTarget(BlockPos posSrc) {
        BlockPos newOrigin = this.getGpsTargetPos(20);
        BlockPos targetA = this.getGpsTargetPos(18);
        BlockPos targetB = this.getGpsTargetPos(19);
        if (newOrigin == null || targetA == null || targetB == null) {
            return null;
        }
        int xOffset = Math.abs(posSrc.func_177958_n() - targetA.func_177958_n());
        int yOffset = Math.abs(posSrc.func_177956_o() - targetA.func_177956_o());
        int zOffset = Math.abs(posSrc.func_177952_p() - targetA.func_177952_p());
        return newOrigin.func_177982_a(xOffset, yOffset, zOffset);
    }

    public List<BlockPos> getTargetShape() {
        List<BlockPos> shapeSrc = this.getSourceShape();
        List<BlockPos> shapeTarget = new ArrayList<BlockPos>();
        for (BlockPos p : shapeSrc) {
            BlockPos conv = this.convertPosSrcToTarget(new BlockPos((Vec3i)p));
            if (conv == null) continue;
            shapeTarget.add(conv);
        }
        BlockPos trueCenter = this.getCenterTarget();
        if (trueCenter == null) {
            return shapeTarget;
        }
        shapeTarget = UtilShape.rotateShape(trueCenter, shapeTarget, this.getRotation());
        if (this.getField(Fields.FLIPX) == 1) {
            shapeTarget = UtilShape.flipShape(trueCenter, shapeTarget, EnumFacing.Axis.X);
        }
        if (this.getField(Fields.FLIPY) == 1) {
            shapeTarget = UtilShape.flipShape(trueCenter, shapeTarget, EnumFacing.Axis.Y);
        }
        if (this.getField(Fields.FLIPZ) == 1) {
            shapeTarget = UtilShape.flipShape(trueCenter, shapeTarget, EnumFacing.Axis.Z);
        }
        return shapeTarget;
    }

    public Map<BlockPos, IBlockState> getShapeFancy(List<BlockPos> sourceShape, List<BlockPos> targetShape) {
        HashMap<BlockPos, IBlockState> map = new HashMap<BlockPos, IBlockState>();
        for (int i = 0; i < targetShape.size(); ++i) {
            BlockPos src = sourceShape.get(i);
            BlockPos targ = targetShape.get(i);
            if (!this.field_145850_b.func_175623_d(targ)) continue;
            map.put(targ, this.field_145850_b.func_180495_p(src));
        }
        return map;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.shapeIndex = compound.func_74762_e(NBT_SHAPEINDEX);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(NBT_SHAPEINDEX, this.shapeIndex);
        return super.func_189515_b(compound);
    }

    public Rotation getRotation() {
        return Rotation.values()[this.rotation];
    }

    public String getRotationName() {
        switch (this.getRotation()) {
            case CLOCKWISE_90: {
                return "90";
            }
            case CLOCKWISE_180: {
                return "180";
            }
            case COUNTERCLOCKWISE_90: {
                return "270";
            }
        }
        return "None";
    }

    public int getField(Fields f) {
        switch (f) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case ROTATION: {
                return this.rotation;
            }
            case FLIPX: {
                return this.flipX;
            }
            case FLIPY: {
                return this.flipY;
            }
            case FLIPZ: {
                return this.flipZ;
            }
        }
        return 0;
    }

    public void setField(Fields f, int value) {
        if (value > 32 && f.ordinal() < Fields.ROTATION.ordinal()) {
            value = 32;
        }
        switch (f) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % RenderType.values().length;
                break;
            }
            case ROTATION: {
                this.rotation = value % Rotation.values().length;
                break;
            }
            case FLIPX: {
                this.flipX = value % 2;
                break;
            }
            case FLIPY: {
                this.flipY = value % 2;
                break;
            }
            case FLIPZ: {
                this.flipZ = value % 2;
            }
        }
    }

    public RenderType getRenderType() {
        return RenderType.values()[this.renderParticles];
    }

    @Override
    public int func_174887_a_(int id) {
        return this.getField(Fields.values()[id]);
    }

    @Override
    public void func_174885_b(int id, int value) {
        this.setField(Fields.values()[id], value);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.renderParticles == 1;
    }

    @Override
    public List<BlockPos> getShape() {
        return this.getTargetShape();
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        RENDERPARTICLES,
        ROTATION,
        FLIPX,
        FLIPY,
        FLIPZ;

    }

    static enum RenderType {
        OFF,
        OUTLINE,
        PHANTOM,
        SOLID;

    }
}

