/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.silentchaos512.gems.api.stats.CommonItemStats;
import net.silentchaos512.gems.compat.VeinMinerCompat;
import net.silentchaos512.gems.compat.gear.SGearStatHandler;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.entity.ModEntities;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.init.ModPotions;
import net.silentchaos512.gems.init.ModRecipes;
import net.silentchaos512.gems.init.ModSounds;
import net.silentchaos512.gems.lib.part.ModParts;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.lib.soul.ToolSoulPart;
import net.silentchaos512.gems.proxy.GemsCommonProxy;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.gems.world.GemsGeodeWorldGenerator;
import net.silentchaos512.gems.world.GemsWorldGenerator;
import net.silentchaos512.lib.base.IModBase;
import net.silentchaos512.lib.registry.SRegistry;
import net.silentchaos512.lib.util.I18nHelper;
import net.silentchaos512.lib.util.LogHelper;

@Mod(modid="silentgems", name="Silent's Gems", version="2.8.18", dependencies="required-after:silentlib@[3.0.9,);after:baubles;after:enderio;after:enderzoo;after:veinminer;after:silentgear", guiFactory="net.silentchaos512.gems.client.gui.config.GuiFactorySilentGems", acceptedMinecraftVersions="[1.12.2]")
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SilentGems
implements IModBase {
    public static final String MODID = "silentgems";
    public static final String MODID_NBT = "SilentGems";
    public static final String MOD_NAME = "Silent's Gems";
    public static final String VERSION = "2.8.18";
    public static final String VERSION_SILENTLIB = "3.0.9";
    public static final int BUILD_NUM = 327;
    public static final String DEPENDENCIES = "required-after:silentlib@[3.0.9,);after:baubles;after:enderio;after:enderzoo;after:veinminer;after:silentgear";
    public static final String RESOURCE_PREFIX = "silentgems:";
    public static final Random random = new Random();
    public static final LogHelper logHelper = new LogHelper("Silent's Gems", 327);
    public static final I18nHelper i18n = new I18nHelper("silentgems", logHelper, false);
    public static final SRegistry registry = new SRegistry();
    @Mod.Instance(value="silentgems")
    public static SilentGems instance;
    @SidedProxy(clientSide="net.silentchaos512.gems.proxy.GemsClientProxy", serverSide="net.silentchaos512.gems.proxy.GemsCommonProxy")
    public static GemsCommonProxy proxy;
    private static final boolean RECIPE_HELL_IN_DEV = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        registry.setMod((Object)this);
        registry.getRecipeMaker().setJsonHellMode(false);
        CommonItemStats.init();
        ToolHelper.init();
        GemsConfig.INSTANCE.init(event.getSuggestedConfigurationFile());
        registry.addRegistrationHandler(ModEnchantments::registerAll, Enchantment.class);
        registry.addRegistrationHandler(ModBlocks::registerAll, Block.class);
        registry.addRegistrationHandler(ModItems::registerAll, Item.class);
        registry.addRegistrationHandler(ModPotions::registerAll, Potion.class);
        registry.addRegistrationHandler(ModRecipes::registerAll, IRecipe.class);
        registry.addRegistrationHandler(ModSounds::registerAll, SoundEvent.class);
        ModParts.init();
        SoulSkill.init();
        GemsConfig.INSTANCE.loadModuleConfigs();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GemsWorldGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GemsGeodeWorldGenerator(), (int)-10);
        FMLInterModComms.sendMessage((String)"headcrumbs", (String)"add-username", (String)"SilentChaos512");
        VeinMinerCompat.init();
        proxy.preInit(registry, event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModEntities.init(registry);
        GemsConfig.INSTANCE.save();
        proxy.init(registry, event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(registry, event);
    }

    public String getModId() {
        return MODID;
    }

    public String getModName() {
        return MOD_NAME;
    }

    public String getVersion() {
        return VERSION;
    }

    public int getBuildNum() {
        return 327;
    }

    public LogHelper getLog() {
        return logHelper;
    }

    static {
        if (Loader.isModLoaded((String)"silentgear")) {
            MinecraftForge.EVENT_BUS.register((Object)new SGearStatHandler());
            logHelper.info("Registering tool soul part for Silent Gear: {}", new Object[]{ToolSoulPart.PART_TYPE});
        }
    }
}

