/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.recipe.altar;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeChaosAltar {
    public static final List<RecipeChaosAltar> ALL_RECIPES = Lists.newArrayList();
    private ItemStack input;
    private ItemStack output;
    private ItemStack catalyst;
    private int chaosCost;

    public RecipeChaosAltar(ItemStack output, ItemStack input, int chaosCost) {
        this(output, input, chaosCost, null);
    }

    public RecipeChaosAltar(ItemStack output, ItemStack input, int chaosCost, ItemStack catalyst) {
        this.output = output;
        this.input = input;
        this.chaosCost = chaosCost;
        this.catalyst = catalyst;
    }

    public static RecipeChaosAltar getMatchingRecipe(ItemStack inputStack, ItemStack catalystStack) {
        if (inputStack.func_190926_b()) {
            return null;
        }
        for (RecipeChaosAltar recipe : ALL_RECIPES) {
            if (!recipe.matches(inputStack, catalystStack)) continue;
            return recipe;
        }
        return null;
    }

    public static RecipeChaosAltar getRecipeByOutput(ItemStack outputStack) {
        if (outputStack.func_190926_b()) {
            return null;
        }
        for (RecipeChaosAltar recipe : ALL_RECIPES) {
            if (!recipe.output.func_77969_a(outputStack)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack inputStack) {
        if (inputStack.func_190926_b()) {
            return false;
        }
        for (RecipeChaosAltar recipe : ALL_RECIPES) {
            if (!recipe.input.func_77969_a(inputStack)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(ItemStack inputStack, ItemStack catalystStack) {
        boolean catalystMatch = catalystStack.func_190926_b() && this.catalyst.func_190926_b() || !catalystStack.func_190926_b() && catalystStack.func_77969_a(this.catalyst);
        return !inputStack.func_190926_b() && !this.input.func_190926_b() && !this.output.func_190926_b() && inputStack.func_77969_a(this.input) && inputStack.func_190916_E() >= this.input.func_190916_E() && catalystMatch;
    }

    public ItemStack getInput() {
        return this.input.func_77946_l();
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public ItemStack getCatalyst() {
        return this.catalyst.func_77946_l();
    }

    public int getChaosCost() {
        return this.chaosCost;
    }
}

