/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.tool.part;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;

public class ToolPartRegistry {
    private static Map<String, ToolPart> map = new THashMap();
    private static List<ToolPartMain> mains = new ArrayList<ToolPartMain>();
    private static List<ToolPartRod> rods = new ArrayList<ToolPartRod>();
    private static Map<ItemStack, ToolPart> STACK_TO_PART = new THashMap();

    public static ToolPart getPart(String key) {
        return map.get(key.toLowerCase(Locale.ROOT));
    }

    public static void putPart(ToolPart part) {
        String key = part.key;
        if (map.containsKey(key)) {
            throw new IllegalArgumentException("Already have a part with key " + part.key);
        }
        map.put(key, part);
        if (part instanceof ToolPartMain) {
            mains.add((ToolPartMain)part);
        } else if (part instanceof ToolPartRod) {
            rods.add((ToolPartRod)part);
        }
        if (part.stats == null) {
            part.setStatsFromOldMethods();
        }
    }

    @Nullable
    public static ToolPart fromStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (STACK_TO_PART.containsKey(stack)) {
            return STACK_TO_PART.get(stack);
        }
        for (ToolPart part : map.values()) {
            if (!part.matchesForCrafting(stack, true)) continue;
            STACK_TO_PART.put(stack, part);
            return part;
        }
        return null;
    }

    @Nullable
    public static ToolPart fromDecoStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (ToolPart part : map.values()) {
            if (!part.matchesForDecorating(stack, true)) continue;
            return part;
        }
        return null;
    }

    public static Set<String> getKeySet() {
        return map.keySet();
    }

    public static Collection<ToolPart> getValues() {
        return map.values();
    }

    public static List<ToolPartMain> getMains() {
        return mains;
    }

    public static List<ToolPartRod> getRods() {
        return rods;
    }
}

