/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.tool.part;

import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.stats.CommonItemStats;
import net.silentchaos512.gems.api.stats.ItemStat;
import net.silentchaos512.gems.api.stats.ItemStatModifier;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ToolPart;

public abstract class ToolPartTip
extends ToolPart {
    private int miningLevel;
    private int durabilityBoost;
    private float speedBoost;
    private float meleeBoost;
    private float magicBoost;

    protected ToolPartTip(String key, ItemStack craftingStack, int harvestLevel, int durabilityBoost, float speedBoost, float meleeDamage, float magicDamage) {
        super(key, craftingStack);
        this.miningLevel = harvestLevel;
        this.durabilityBoost = durabilityBoost;
        this.speedBoost = speedBoost;
        this.meleeBoost = meleeDamage;
        this.magicBoost = magicDamage;
    }

    @Override
    public ItemStatModifier getStatModifier(ItemStat stat, EnumMaterialGrade grade) {
        float val = this.stats.getStat(stat);
        ItemStatModifier.Operation op = ItemStatModifier.Operation.ADD;
        if (stat == CommonItemStats.ATTACK_SPEED) {
            val -= 1.0f;
        } else if (stat == CommonItemStats.HARVEST_LEVEL) {
            op = ItemStatModifier.Operation.MAX;
        }
        return new ItemStatModifier(this.getUnlocalizedName(), val, op);
    }

    @Override
    public void applyStats(ToolStats stats) {
        stats.durability += (float)this.getDurability();
        stats.harvestSpeed += this.getHarvestSpeed();
        stats.meleeDamage += this.getMeleeDamage();
        stats.magicDamage += this.getMagicDamage();
        stats.meleeSpeed += this.getMeleeSpeed() - 1.0f;
        stats.chargeSpeed += this.getChargeSpeed();
        stats.enchantability += (float)this.getEnchantability();
        stats.harvestLevel = Math.max(stats.harvestLevel, this.getHarvestLevel());
    }

    @Override
    public int getDurability() {
        return this.durabilityBoost;
    }

    @Override
    public float getHarvestSpeed() {
        return this.speedBoost;
    }

    @Override
    public int getHarvestLevel() {
        return this.miningLevel;
    }

    @Override
    public float getMeleeDamage() {
        return this.meleeBoost;
    }

    @Override
    public float getMagicDamage() {
        return this.magicBoost;
    }

    @Override
    public int getEnchantability() {
        return 0;
    }

    @Override
    public float getMeleeSpeed() {
        return 1.0f;
    }

    @Override
    public float getChargeSpeed() {
        return 0.0f;
    }

    @Override
    public final float getProtection() {
        return 0.0f;
    }

    @Override
    public boolean validForPosition(IPartPosition pos) {
        return pos == ToolPartPosition.TIP;
    }

    @Override
    public boolean validForToolOfTier(EnumMaterialTier toolTier) {
        return true;
    }
}

