/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.silentchaos512.gems.client.gui.GuiTypes;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.tile.TileChaosAltar;
import net.silentchaos512.lib.block.ITileEntityBlock;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.RecipeMaker;

public class BlockChaosAltar
extends BlockContainer
implements ITileEntityBlock,
IAddRecipes {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    @Deprecated
    public IRecipe recipe;

    public BlockChaosAltar() {
        super(Material.field_151573_f);
        this.func_149711_c(12.0f);
        this.func_149752_b(6000.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileChaosAltar();
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return TileChaosAltar.class;
    }

    public void addRecipes(RecipeMaker recipes) {
        ItemStack result = new ItemStack((Block)this);
        this.recipe = recipes.makeShapedOre("chaos_altar", result, new Object[]{"rer", "dod", "ooo", Character.valueOf('e'), CraftingItems.ENRICHED_CHAOS_ESSENCE.getStack(), Character.valueOf('r'), "dustRedstone", Character.valueOf('o'), "obsidian", Character.valueOf('d'), "gemDiamond"});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileChaosAltar) {
            GuiTypes.ALTAR.open(player, world, pos);
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileAltar = world.func_175625_s(pos);
        if (tileAltar instanceof TileChaosAltar) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileChaosAltar)tileAltar));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileChaosAltar) {
            TileChaosAltar altar = (TileChaosAltar)tile;
            float storedRatio = (float)altar.getCharge() / (float)altar.getMaxCharge();
            return (int)(15.0f * storedRatio);
        }
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }
}

