/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.tile.TileChaosFlowerPot;
import net.silentchaos512.lib.block.ITileEntityBlock;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.wit.api.IWitHudInfo;

public class BlockChaosFlowerPot
extends Block
implements ITileEntityProvider,
ITileEntityBlock,
IAddRecipes,
IWitHudInfo {
    private static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    @Deprecated
    public IRecipe recipe;

    public BlockChaosFlowerPot() {
        super(Material.field_151594_q);
        this.func_149711_c(1.0f);
        this.func_149752_b(30.0f);
        this.field_149784_t = 2;
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return TileChaosFlowerPot.class;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock) {
            TileChaosFlowerPot tileentityflowerpot = this.getTileEntity((IBlockAccess)worldIn, pos);
            if (tileentityflowerpot == null) {
                return false;
            }
            if (!tileentityflowerpot.getFlowerItemStack().func_190926_b()) {
                return false;
            }
            Block block = Block.func_149634_a((Item)heldItem.func_77973_b());
            if (block != ModBlocks.glowRose) {
                return false;
            }
            ItemStack flower = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77952_i());
            tileentityflowerpot.setFlowerItemStack(flower);
            tileentityflowerpot.func_70296_d();
            worldIn.func_184138_a(pos, state, state, 3);
            worldIn.func_175664_x(pos);
            playerIn.func_71029_a(StatList.field_188088_V);
            if (playerIn instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)playerIn, pos, heldItem);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileChaosFlowerPot tile = this.getTileEntity(world, pos);
        return tile != null && !tile.getFlowerItemStack().func_190926_b() ? 15 : this.field_149784_t;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public TileChaosFlowerPot getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileChaosFlowerPot)) {
            return null;
        }
        return (TileChaosFlowerPot)tile;
    }

    public void addRecipes(RecipeMaker recipes) {
        this.recipe = recipes.makeShaped("chaos_flower_pot", new ItemStack((Block)this), new Object[]{"c", "f", Character.valueOf('c'), CraftingItems.ENRICHED_CHAOS_ESSENCE.getStack(), Character.valueOf('f'), Items.field_151162_bE});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        TileChaosFlowerPot te = this.getTileEntity(world, pos);
        if (te != null && !te.getFlowerItemStack().func_190926_b()) {
            drops.add((Object)te.getFlowerItemStack());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileChaosFlowerPot();
    }

    @Override
    public List<String> getWitLines(IBlockState state, BlockPos pos, EntityPlayer player, boolean advanced) {
        int flowerId;
        ArrayList<String> list = new ArrayList<String>();
        TileEntity te = player.field_70170_p.func_175625_s(pos);
        if (te instanceof TileChaosFlowerPot && (flowerId = ((TileChaosFlowerPot)te).getFlowerId()) >= 0 && flowerId < 16) {
            String key = "tile.silentgems.glowrose" + flowerId + ".name";
            list.add(TextFormatting.GRAY + SilentGems.i18n.translate(key, new Object[0]));
        }
        return list;
    }
}

