/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.registry.ICustomModel;

public class BlockFluffyPuffPlant
extends BlockCrops
implements ICustomModel {
    public BlockFluffyPuffPlant() {
        this.func_149711_c(0.1f);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(this.func_149866_i()));
        int age = this.func_185527_x(state);
        if (age >= 7) {
            int i;
            int seedCount = 1 + fortune;
            int puffCount = 2 + fortune + SilentGems.random.nextInt(3);
            for (i = 0; i < seedCount; ++i) {
                if (SilentGems.random.nextInt(15) > age) continue;
                drops.add((Object)new ItemStack(this.func_149866_i()));
            }
            for (i = 0; i < puffCount; ++i) {
                drops.add((Object)new ItemStack(this.func_149865_P()));
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.sickle) {
            return false;
        }
        ArrayList drops = Lists.newArrayList();
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        if (age >= 7) {
            for (int i = 0; i < 3; ++i) {
                if (i != 0 && RANDOM.nextInt(15) > age) continue;
                drops.add(new ItemStack(this.func_149865_P(), 1, this.func_180651_a(state)));
            }
            if (SilentGems.random.nextFloat() < 0.025f) {
                drops.add(ModItems.soulGem.getStack("FluffyPuff"));
            }
            world.func_175656_a(pos, this.func_176223_P());
        }
        for (ItemStack stack : drops) {
            BlockFluffyPuffPlant.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
        return !drops.isEmpty();
    }

    protected Item func_149866_i() {
        return ModItems.fluffyPuffSeeds;
    }

    protected Item func_149865_P() {
        return ModItems.fluffyPuff;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        String fullName = "silentgems:fluffyplant";
        for (int i = 0; i < 4; ++i) {
            ModelResourceLocation model = new ModelResourceLocation(fullName + i, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)model);
        }
    }
}

