/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.block.BlockGemSubtypes;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.registry.IAddRecipes;

public class BlockGem
extends BlockGemSubtypes
implements IAddRecipes {
    public final boolean supercharged;

    public BlockGem(EnumGem.Set set, boolean supercharged) {
        super(set);
        this.supercharged = supercharged;
        this.func_149711_c(supercharged ? 7.0f : 3.0f);
        this.func_149752_b(supercharged ? 6000000.0f : 30.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", supercharged ? 3 : 1);
    }

    public void addOreDict() {
        for (int i = 0; i < 16; ++i) {
            EnumGem gem = this.getGem(i);
            if (this.supercharged) {
                OreDictionary.registerOre((String)gem.getBlockSuperOreName(), (ItemStack)gem.getBlockSuper());
                continue;
            }
            OreDictionary.registerOre((String)gem.getBlockOreName(), (ItemStack)gem.getBlock());
        }
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (this.supercharged) {
            return entity instanceof EntityPlayer;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    @Override
    String getBlockName() {
        return BlockGem.nameForSet(this.getGemSet(), "gemblock");
    }
}

