/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.block.BlockMetaSubtypes;
import net.silentchaos512.lib.registry.ICustomModel;

public abstract class BlockGemSubtypes
extends BlockMetaSubtypes
implements ICustomModel {
    @Nullable
    private final EnumGem.Set gemSet;

    BlockGemSubtypes(EnumGem.Set set) {
        this(set, Material.field_151576_e);
    }

    BlockGemSubtypes(@Nullable EnumGem.Set set, Material material) {
        super(material, 16);
        this.gemSet = set;
        if (set != null) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumGem.VARIANT_GEM, (Comparable)((Object)EnumGem.RUBY)));
        }
    }

    abstract String getBlockName();

    public EnumGem getGem(int meta) {
        if (meta < 0 || meta > 15) {
            return EnumGem.RUBY;
        }
        return EnumGem.values()[meta + this.getGemSet().startMeta];
    }

    @Nonnull
    public EnumGem.Set getGemSet() {
        return this.gemSet == null ? EnumGem.Set.CLASSIC : this.gemSet;
    }

    public int func_180651_a(IBlockState state) {
        return this.getGem(this.func_176201_c(state)).ordinal() & 0xF;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumGem.VARIANT_GEM, (Comparable)((Object)EnumGem.values()[meta & 0xF]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumGem)((Object)state.func_177229_b(EnumGem.VARIANT_GEM))).ordinal() & 0xF;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumGem.VARIANT_GEM});
    }

    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        String fullName = "silentgems:" + this.getBlockName();
        for (int i = 0; i < 16; ++i) {
            EnumGem gem = EnumGem.values()[i];
            ModelResourceLocation model = new ModelResourceLocation(fullName, "gem=" + gem.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)model);
        }
    }

    static String nameForSet(EnumGem.Set set, String baseName) {
        switch (set) {
            case CLASSIC: {
                return baseName;
            }
            case DARK: {
                return baseName + "dark";
            }
            case LIGHT: {
                return baseName + "light";
            }
        }
        return baseName + "unknown";
    }
}

