/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.BlockGemSubtypes;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.tile.TileTeleporter;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.DimensionalPosition;
import net.silentchaos512.wit.api.IWitHudInfo;

public class BlockTeleporter
extends BlockGemSubtypes
implements ITileEntityProvider,
IWitHudInfo {
    private final boolean isAnchor;
    private final String blockName;

    public BlockTeleporter(String name) {
        super(null, Material.field_151573_f);
        this.isAnchor = true;
        this.blockName = name;
    }

    public BlockTeleporter(EnumGem.Set set, boolean isAnchor) {
        this(set, isAnchor, "teleporter");
    }

    public BlockTeleporter(EnumGem.Set set, boolean isAnchor, String name) {
        super(set, Material.field_151573_f);
        this.isAnchor = isAnchor;
        this.blockName = name;
        this.func_149711_c(15.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public List<String> getWitLines(IBlockState state, BlockPos pos, EntityPlayer player, boolean advanced) {
        TileEntity tile = player.field_70170_p.func_175625_s(pos);
        if (!(tile instanceof TileTeleporter)) {
            return null;
        }
        TileTeleporter teleporter = (TileTeleporter)tile;
        DimensionalPosition destination = teleporter.getDestination();
        return Lists.newArrayList((Object[])new String[]{destination != null ? destination.toString() : "null"});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean holdingReturnHome;
        ItemStack heldItem = player.func_184586_b(hand);
        boolean holdingLinker = !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.teleporterLinker;
        boolean bl = holdingReturnHome = !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.returnHomeCharm;
        if (world.field_72995_K) {
            return holdingLinker || holdingReturnHome || !this.isAnchor;
        }
        TileTeleporter tile = (TileTeleporter)world.func_175625_s(pos);
        if (tile == null) {
            SilentGems.logHelper.warn("Teleporter tile at {} not found!", new Object[]{pos});
            return false;
        }
        if (holdingLinker) {
            return tile.linkTeleporters(player, world, pos, heldItem, hand);
        }
        if (holdingReturnHome) {
            return tile.linkReturnHomeCharm(player, world, pos, heldItem, hand);
        }
        if (this.isAnchor) {
            return false;
        }
        if (!tile.isDestinationSet()) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "noDestination", new Object[0]));
            return true;
        }
        if (!tile.isDestinationSane(player)) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "notSane", new Object[0]));
            return true;
        }
        if (!tile.isDestinationSafe(player)) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "notSafe", new Object[0]));
            return true;
        }
        if (!tile.isDestinationAllowedIfDumb(player)) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "noReceiver", new Object[0]));
            return true;
        }
        if (!tile.checkAndDrainChaos(player)) {
            return true;
        }
        tile.teleportEntityToDestination((Entity)player);
        float pitch = 0.7f + 0.3f * SilentGems.random.nextFloat();
        for (BlockPos p : new BlockPos[]{pos, tile.getDestination().toBlockPos()}) {
            world.func_184133_a(null, p, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, pitch);
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTeleporter(this.isAnchor);
    }

    @Override
    String getBlockName() {
        return BlockTeleporter.nameForSet(this.getGemSet(), this.blockName);
    }
}

