/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.urn;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.urn.TileSoulUrn;
import net.silentchaos512.gems.client.gui.GuiTypes;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.init.ModSounds;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.lib.urn.UrnHelper;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;
import net.silentchaos512.lib.block.IColoredBlock;
import net.silentchaos512.lib.block.ITileEntityBlock;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.util.DyeHelper;
import net.silentchaos512.lib.util.MathUtils;

public class BlockSoulUrn
extends BlockContainer
implements ITileEntityBlock,
IColoredBlock,
ICustomModel,
IAddRecipes {
    private static final AxisAlignedBB BOUNDING_BOX_CLOSED = MathUtils.boundingBoxByPixels((int)1, (int)0, (int)1, (int)15, (int)15, (int)15);
    private static final AxisAlignedBB BOUNDING_BOX_OPEN = MathUtils.boundingBoxByPixels((int)1, (int)0, (int)1, (int)15, (int)14, (int)15);
    static final PropertyEnum<LidState> PROPERTY_LID = PropertyEnum.func_177709_a((String)"lid", LidState.class);
    private static final PropertyEnum<EnumFacing> PROPERTY_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockSoulUrn() {
        super(Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSoulUrn();
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return TileSoulUrn.class;
    }

    public ItemStack getStack(int color, @Nullable EnumGem gem) {
        ItemStack stack = new ItemStack((Block)this);
        if (color != 9985861) {
            UrnHelper.setClayColor(stack, color);
        }
        if (gem != null) {
            UrnHelper.setGem(stack, gem);
        }
        return stack;
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String str;
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        int color = UrnHelper.getClayColor(stack);
        EnumGem gem = UrnHelper.getGem(stack);
        if (color != 9985861) {
            tooltip.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "color", new Object[]{String.format("#%06X", color)}));
        } else {
            str = SilentGems.i18n.subText((IForgeRegistryEntry)this, "color.uncolored", new Object[0]);
            tooltip.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "color", new Object[]{str}));
        }
        if (gem != null) {
            str = SilentGems.i18n.translatedName(gem.getItem());
            tooltip.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "gem", new Object[]{str}));
        }
        if (KeyTracker.isControlDown()) {
            tooltip.add(TextFormatting.YELLOW + SilentGems.i18n.subText((IForgeRegistryEntry)this, "upgrades", new Object[]{""}));
            NonNullList<UrnUpgrade> upgrades = UrnUpgrade.ListHelper.load(stack);
            for (UrnUpgrade upgrade : upgrades) {
                String upgradeName = SilentGems.i18n.translate(upgrade.getTranslationKey(), new Object[0]);
                tooltip.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "upgrade_list", new Object[]{upgradeName}));
            }
        } else {
            String pressCtrl = TextFormatting.DARK_GRAY + SilentGems.i18n.miscText("pressCtrl", new Object[0]);
            tooltip.add(TextFormatting.YELLOW + SilentGems.i18n.subText((IForgeRegistryEntry)this, "upgrades", new Object[]{pressCtrl}));
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileSoulUrn) {
            TileSoulUrn tileSoulUrn = (TileSoulUrn)tile;
            tileSoulUrn.setDestroyedByCreativePlayer(player.field_71075_bZ.field_75098_d);
            tileSoulUrn.func_184281_d(player);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            LidState lid = (LidState)((Object)state.func_177229_b(PROPERTY_LID));
            if (lid != LidState.NO_LID && (playerIn.func_70093_af() || !lid.isOpen())) {
                worldIn.func_180501_a(pos, BlockSoulUrn.toggleLid(state), 2);
                worldIn.func_184133_a(null, pos, ModSounds.SOUL_URN_LID, SoundCategory.BLOCKS, 0.6f, (float)((double)1.1f + (double)0.05f * SilentGems.random.nextGaussian()));
            } else {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof TileSoulUrn) {
                    GuiTypes.SOUL_URN.open(playerIn, worldIn, pos);
                    worldIn.func_184133_a(null, pos, ModSounds.SOUL_URN_OPEN, SoundCategory.BLOCKS, 0.6f, (float)((double)1.1f + (double)0.05f * SilentGems.random.nextGaussian()));
                }
            }
        }
        return true;
    }

    private static IBlockState toggleLid(IBlockState state) {
        LidState lid = (LidState)((Object)state.func_177229_b(PROPERTY_LID));
        if (lid == LidState.NO_LID) {
            return state;
        }
        return state.func_177226_a(PROPERTY_LID, (Comparable)((Object)(lid == LidState.CLOSED ? LidState.OPEN : LidState.CLOSED)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing side = placer.func_174811_aO().func_176734_d();
        IBlockState newState = state.func_177226_a(PROPERTY_FACING, (Comparable)side).func_177226_a(PROPERTY_LID, (Comparable)((Object)(UrnHelper.isLidless(stack) ? LidState.NO_LID : LidState.CLOSED)));
        worldIn.func_180501_a(pos, newState, 2);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileSoulUrn) {
            TileSoulUrn tileSoulUrn = (TileSoulUrn)tile;
            if (stack.func_82837_s()) {
                tileSoulUrn.func_190575_a(stack.func_82833_r());
            }
            tileSoulUrn.setColorAndGem(UrnHelper.getClayColor(stack), UrnHelper.getGem(stack));
            NBTTagCompound tagCompound = stack.func_190925_c("BlockEntityTag");
            tileSoulUrn.setUpgrades((List<UrnUpgrade>)UrnUpgrade.ListHelper.load(tagCompound));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileSoulUrn) {
            TileSoulUrn tileSoulUrn = (TileSoulUrn)tile;
            if (!tileSoulUrn.isCleared() && tileSoulUrn.shouldDrop()) {
                ItemStack stack = new ItemStack((Block)this);
                if (state.func_177229_b(PROPERTY_LID) == LidState.NO_LID) {
                    UrnHelper.setLidless(stack, true);
                }
                NBTTagCompound compound = new NBTTagCompound();
                NBTTagCompound compound1 = new NBTTagCompound();
                compound.func_74782_a("BlockEntityTag", (NBTBase)tileSoulUrn.saveToNBT(compound1));
                stack.func_77982_d(compound);
                if (tileSoulUrn.func_145818_k_()) {
                    stack.func_151001_c(tileSoulUrn.func_70005_c_());
                    tileSoulUrn.func_190575_a("");
                }
                if (tileSoulUrn.getColor() != 9985861) {
                    UrnHelper.setClayColor(stack, tileSoulUrn.getColor());
                }
                if (tileSoulUrn.getGem() != null) {
                    UrnHelper.setGem(stack, tileSoulUrn.getGem());
                }
                BlockSoulUrn.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
            worldIn.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack = super.func_185473_a(worldIn, pos, state);
        TileSoulUrn tileSoulUrn = (TileSoulUrn)worldIn.func_175625_s(pos);
        if (tileSoulUrn != null) {
            NBTTagCompound compound = tileSoulUrn.saveToNBT(new NBTTagCompound());
            if (!compound.func_82582_d()) {
                stack.func_77983_a("BlockEntityInfo", (NBTBase)compound);
            }
            UrnHelper.setClayColor(stack, tileSoulUrn.getColor());
            if (tileSoulUrn.getGem() != null) {
                UrnHelper.setGem(stack, tileSoulUrn.getGem());
            }
        }
        return stack;
    }

    public IBlockColor getColorHandler() {
        return (state, worldIn, pos, tintIndex) -> {
            EnumGem gem;
            TileEntity tile;
            if (tintIndex == 0) {
                TileEntity tile2;
                if (worldIn != null && pos != null && (tile2 = worldIn.func_175625_s(pos)) instanceof TileSoulUrn) {
                    return ((TileSoulUrn)tile2).getColor();
                }
                return 9985861;
            }
            if (tintIndex == 1 && worldIn != null && pos != null && (tile = worldIn.func_175625_s(pos)) instanceof TileSoulUrn && (gem = ((TileSoulUrn)tile).getGem()) != null) {
                return gem.getColor();
            }
            return 0xFFFFFF;
        };
    }

    public IItemColor getItemColorHandler() {
        return (stack, tintIndex) -> {
            if (tintIndex == 0) {
                return UrnHelper.getClayColor(stack);
            }
            if (tintIndex == 1) {
                EnumGem gem = UrnHelper.getGem(stack);
                return gem != null ? gem.getColor() : 0xFFFFFF;
            }
            return 0xFFFFFF;
        };
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return ((LidState)((Object)blockState.func_177229_b(PROPERTY_LID))).isOpen() ? BOUNDING_BOX_OPEN : BOUNDING_BOX_CLOSED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((LidState)((Object)state.func_177229_b(PROPERTY_LID))).isOpen() ? BOUNDING_BOX_OPEN : BOUNDING_BOX_CLOSED;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(PROPERTY_FACING, (Comparable)placer.func_174811_aO()).func_177226_a(PROPERTY_LID, (Comparable)((Object)(meta == 0 ? LidState.CLOSED : LidState.NO_LID)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PROPERTY_FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a(PROPERTY_LID, (Comparable)((Object)BlockSoulUrn.lidStateFromMeta(meta)));
    }

    private static LidState lidStateFromMeta(int meta) {
        if ((meta >>= 2) < 0 || meta >= LidState.values().length) {
            return LidState.NO_LID;
        }
        return LidState.values()[meta];
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(PROPERTY_FACING)).func_176736_b() + (((LidState)((Object)state.func_177229_b(PROPERTY_LID))).ordinal() << 2);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_LID, PROPERTY_FACING});
    }

    public void registerModels() {
        for (LidState lidState : LidState.values()) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                IBlockState state = this.func_176223_P().func_177226_a(PROPERTY_LID, (Comparable)((Object)lidState)).func_177226_a(PROPERTY_FACING, (Comparable)facing);
                int meta = this.func_176201_c(state);
                String variant = String.format("facing=%s,lid=%s", facing.func_176610_l(), lidState.func_176610_l());
                SilentGems.registry.setModel((Block)this, meta, "soul_urn", variant);
            }
        }
    }

    public static class ItemBlockSoulUrn
    extends ItemBlock {
        private static List<ItemStack> SAMPLE_SUB_ITEMS;
        private final BlockSoulUrn blockSoulUrn;

        public ItemBlockSoulUrn(BlockSoulUrn block) {
            super((Block)block);
            this.blockSoulUrn = block;
            this.func_77625_d(1);
            this.func_77656_e(0);
        }

        public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            IBlockState state = worldIn.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150383_bp) {
                int waterLevel = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
                if (waterLevel > 0) {
                    UrnHelper.setClayColor(player.func_184586_b(hand), 9985861);
                    Blocks.field_150383_bp.func_176590_a(worldIn, pos, state, waterLevel - 1);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }

        public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
            super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        }

        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
            if (!this.func_194125_a(tab)) {
                return;
            }
            if (SAMPLE_SUB_ITEMS == null) {
                SAMPLE_SUB_ITEMS = new ArrayList<ItemStack>();
                SAMPLE_SUB_ITEMS.add(this.blockSoulUrn.getStack(9985861, EnumGem.getRandom()));
                for (EnumDyeColor color : EnumDyeColor.values()) {
                    SAMPLE_SUB_ITEMS.add(this.blockSoulUrn.getStack(DyeHelper.getColor((EnumDyeColor)color), EnumGem.getRandom()));
                }
            }
            items.addAll(SAMPLE_SUB_ITEMS);
        }

        public String func_77667_c(ItemStack stack) {
            return super.func_77667_c(stack) + (stack.func_77952_i() >> 2 == LidState.NO_LID.ordinal() ? "_no_lid" : "");
        }
    }

    public static enum LidState implements IStringSerializable
    {
        CLOSED,
        OPEN,
        NO_LID;


        public boolean isOpen() {
            return this == OPEN || this == NO_LID;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

