/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.gui;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.supercharger.ContainerSupercharger;
import net.silentchaos512.gems.block.supercharger.GuiSupercharger;
import net.silentchaos512.gems.block.supercharger.TileSupercharger;
import net.silentchaos512.gems.block.urn.ContainerSoulUrn;
import net.silentchaos512.gems.block.urn.GuiSoulUrn;
import net.silentchaos512.gems.block.urn.TileSoulUrn;
import net.silentchaos512.gems.client.gui.GuiBurnerPylon;
import net.silentchaos512.gems.client.gui.GuiChaosAltar;
import net.silentchaos512.gems.client.gui.GuiMaterialGrader;
import net.silentchaos512.gems.client.gui.GuiQuiver;
import net.silentchaos512.gems.inventory.ContainerBurnerPylon;
import net.silentchaos512.gems.inventory.ContainerChaosAltar;
import net.silentchaos512.gems.inventory.ContainerMaterialGrader;
import net.silentchaos512.gems.inventory.ContainerQuiver;
import net.silentchaos512.gems.tile.TileChaosAltar;
import net.silentchaos512.gems.tile.TileChaosPylon;
import net.silentchaos512.gems.tile.TileMaterialGrader;

public enum GuiTypes {
    ALTAR(0, TileChaosAltar.class){

        @Override
        Container getContainer(TileEntity tile, EntityPlayer player, int subtype) {
            return new ContainerChaosAltar(player.field_71071_by, (IInventory)((TileChaosAltar)tile));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        GuiScreen getGuiScreen(TileEntity tile, EntityPlayer player, int subtype) {
            return new GuiChaosAltar(player.field_71071_by, (TileChaosAltar)tile);
        }
    }
    ,
    BURNER_PYLON(1, TileChaosPylon.class){

        @Override
        Container getContainer(TileEntity tile, EntityPlayer player, int subtype) {
            return new ContainerBurnerPylon(player.field_71071_by, (IInventory)((TileChaosPylon)tile));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        GuiScreen getGuiScreen(TileEntity tile, EntityPlayer player, int subtype) {
            return new GuiBurnerPylon(player.field_71071_by, (TileChaosPylon)tile);
        }
    }
    ,
    MATERIAL_GRADER(2, TileMaterialGrader.class){

        @Override
        Container getContainer(TileEntity tile, EntityPlayer player, int subtype) {
            return new ContainerMaterialGrader(player.field_71071_by, (IInventory)((TileMaterialGrader)tile));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        GuiScreen getGuiScreen(TileEntity tile, EntityPlayer player, int subtype) {
            return new GuiMaterialGrader(player.field_71071_by, (TileMaterialGrader)tile);
        }
    }
    ,
    QUIVER(3, null){

        @Override
        Container getContainer(TileEntity tile, EntityPlayer player, int subtype) {
            EnumHand hand = subtype == 1 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184586_b(hand);
            return new ContainerQuiver(stack, player.field_71071_by, hand);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        GuiScreen getGuiScreen(TileEntity tile, EntityPlayer player, int subtype) {
            return new GuiQuiver((ContainerQuiver)this.getContainer(tile, player, subtype));
        }
    }
    ,
    SOUL_URN(4, TileSoulUrn.class){

        @Override
        Container getContainer(TileEntity tile, EntityPlayer player, int subtype) {
            return new ContainerSoulUrn(player.field_71071_by, (TileSoulUrn)tile);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        GuiScreen getGuiScreen(TileEntity tile, EntityPlayer player, int subtype) {
            return new GuiSoulUrn(player.field_71071_by, (TileSoulUrn)tile);
        }
    }
    ,
    SUPERCHARGER(5, TileSupercharger.class){

        @Override
        Container getContainer(TileEntity tile, EntityPlayer player, int subtype) {
            return new ContainerSupercharger(player.field_71071_by, (TileSupercharger)tile);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        GuiScreen getGuiScreen(TileEntity tile, EntityPlayer player, int subtype) {
            return new GuiSupercharger(player.field_71071_by, (TileSupercharger)tile);
        }
    };

    private final int id;
    @Nullable
    private final Class<? extends TileEntity> tileClass;

    private GuiTypes(int id, Class<? extends TileEntity> tileClass) {
        this.id = id;
        this.tileClass = tileClass;
    }

    public void open(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)SilentGems.instance, this.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void open(EntityPlayer player, World world, int subtype) {
        player.openGui((Object)SilentGems.instance, this.id, world, subtype, 0, 0);
    }

    abstract Container getContainer(TileEntity var1, EntityPlayer var2, int var3);

    @SideOnly(value=Side.CLIENT)
    abstract GuiScreen getGuiScreen(TileEntity var1, EntityPlayer var2, int var3);

    boolean tileEntityMatches(@Nullable TileEntity tile) {
        return this.tileClass == null || this.tileClass.isInstance(tile);
    }

    @Nullable
    static GuiTypes byId(int id) {
        for (GuiTypes type : GuiTypes.values()) {
            if (type.id != id) continue;
            return type;
        }
        return null;
    }
}

