/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.handler;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.tile.TileChaosNode;
import net.silentchaos512.lib.util.Color;

public class ClientTickHandler {
    public static volatile Queue<Runnable> scheduledActions = new ArrayDeque<Runnable>();
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float delta = 0.0f;
    public static float total = 0.0f;
    public static float fovModifier;
    public static Color nodeMoverColor;

    private void calcDelta() {
        float oldTotal = total;
        total = (float)ticksInGame + partialTicks;
        delta = total - oldTotal;
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                ItemStack heldItem = player.func_184614_ca();
                if (heldItem != null && heldItem.func_77969_a(CraftingItems.MAGNIFYING_GLASS.getStack())) {
                    if (fovModifier < 30.0f) {
                        fovModifier += partialTicks / 3.0f;
                    }
                } else if (fovModifier > 0.0f) {
                    fovModifier = Math.max(fovModifier - partialTicks / 3.0f, 0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                PlayerDataHandler.cleanup();
            } else if (mc.field_71439_g != null) {
                while (!scheduledActions.isEmpty()) {
                    scheduledActions.poll().run();
                }
                ItemStack mainHand = mc.field_71439_g.func_184614_ca();
                ItemStack offHand = mc.field_71439_g.func_184592_cb();
                if (mainHand != null && mainHand.func_77973_b() == ModItems.drawingCompass) {
                    ModItems.drawingCompass.spawnParticles(mainHand, (EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e);
                }
                if (offHand != null && offHand.func_77973_b() == ModItems.drawingCompass) {
                    ModItems.drawingCompass.spawnParticles(offHand, (EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e);
                }
            }
            GuiScreen gui = mc.field_71462_r;
            if (gui == null || !gui.func_73868_f()) {
                partialTicks = 0.0f;
                if (++ticksInGame % 7 == 0) {
                    nodeMoverColor = TileChaosNode.selectParticleColor(SilentGems.random);
                }
            }
            this.calcDelta();
        }
    }

    static {
        nodeMoverColor = TileChaosNode.selectParticleColor(SilentGems.random);
    }
}

