/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.crafttweaker;

import crafttweaker.mc1120.recipes.MCRecipeManager;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.recipe.RecipeMixedMaterialItem;
import net.silentchaos512.gems.util.ToolHelper;

public class ActionAddMixedMaterialRecipe
extends MCRecipeManager.ActionBaseAddRecipe {
    static int lastIndex = -1;
    Item toolItem;
    EnumMaterialTier tier;
    Object[] recipe;
    int nameIndex;

    public ActionAddMixedMaterialRecipe(Item toolItem, EnumMaterialTier tier, Object ... recipe) {
        this.toolItem = toolItem;
        this.tier = tier;
        this.recipe = recipe;
        this.nameIndex = ++lastIndex;
    }

    public void apply() {
        RecipeMixedMaterialItem irecipe = new RecipeMixedMaterialItem(this.tier, this.toolItem, this.recipe);
        irecipe.setRegistryName(new ResourceLocation("crafttweaker", this.calculateName()));
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)irecipe);
        ArrayList<EnumMaterialTier> tiers = new ArrayList<EnumMaterialTier>();
        if (this.tier == null) {
            for (EnumMaterialTier t : EnumMaterialTier.values()) {
                tiers.add(t);
            }
        } else {
            tiers.add(this.tier);
        }
        ArrayList<String> recipeLines = new ArrayList<String>();
        int index = 0;
        while (index < this.recipe.length && this.recipe[index] instanceof String) {
            recipeLines.add((String)this.recipe[index++]);
        }
        ArrayList<Object> extraParams = new ArrayList<Object>();
        while (index < this.recipe.length) {
            extraParams.add(this.recipe[index]);
            ++index;
        }
        EnumMaterialTier[] arrayTiers = tiers.toArray(new EnumMaterialTier[0]);
        String[] arrayLines = recipeLines.toArray(new String[0]);
        Object[] arrayExtraParams = extraParams.toArray();
        if (this.toolItem instanceof ITool) {
            ToolHelper.addExampleRecipe(this.toolItem, arrayTiers, arrayLines, arrayExtraParams);
        }
    }

    public String describe() {
        return "Adding custom tool recipes for " + this.toolItem;
    }

    public String calculateName() {
        return "multipart_custom" + this.nameIndex;
    }
}

