/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.gear;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gems.init.SGearMaterials;
import net.silentchaos512.gems.lib.EnumToolType;
import net.silentchaos512.gems.lib.soul.ToolSoulPart;

public final class SGearCompat {
    private SGearCompat() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getGradeString(ItemStack stack) {
        MaterialGrade grade = MaterialGrade.fromStack((ItemStack)stack);
        return grade.name();
    }

    public static int getPartTier(ItemStack stack) {
        ItemPartData part = ItemPartData.fromStack((ItemStack)stack);
        return part != null ? part.getPart().getTier() : -1;
    }

    public static boolean isGearItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ICoreItem;
    }

    public static boolean isMainPart(ItemStack stack) {
        return PartRegistry.get((ItemStack)stack) instanceof PartMain;
    }

    public static EnumToolType getSGemsTypeFromGearItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICoreArmor) {
            return EnumToolType.ARMOR;
        }
        if (stack.func_77973_b() instanceof ICoreItem) {
            ICoreItem item = (ICoreItem)stack.func_77973_b();
            if (item.getGearType().matches("melee_weapon")) {
                return EnumToolType.SWORD;
            }
            if (item.getGearType().matches("ranged_weapon")) {
                return EnumToolType.BOW;
            }
            if (item.getGearType().matches("harvest_tool")) {
                return EnumToolType.HARVEST;
            }
        }
        return EnumToolType.NONE;
    }

    public static void recalculateStats(ItemStack stack, @Nullable EntityPlayer player) {
        GearData.recalculateStats((EntityPlayer)player, (ItemStack)stack);
    }

    public static void addSoulPart(ItemStack stack) {
        PartDataList parts = GearData.getConstructionParts((ItemStack)stack);
        parts.removeIf(p -> p.getPart().getType() == ToolSoulPart.PART_TYPE);
        parts.add(ItemPartData.instance((ItemPart)SGearMaterials.soulPart));
        GearData.writeConstructionParts((ItemStack)stack, (Collection)parts);
    }
}

