/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.gui.GuiChaosAltar;
import net.silentchaos512.gems.compat.jei.altar.AltarRecipeCategory;
import net.silentchaos512.gems.compat.jei.altar.AltarRecipeMaker;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.ChaosBuff;
import net.silentchaos512.gems.recipe.RecipeSoulUrnModify;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.StackHelper;

@JEIPlugin
public class SilentGemsPlugin
implements IModPlugin {
    private static boolean initFailed = true;

    public static boolean hasInitFailed() {
        return initFailed;
    }

    public void register(IModRegistry reg) {
        initFailed = true;
        this.doItemBlacklist(reg.getJeiHelpers().getIngredientBlacklist());
        this.doRecipeRegistration(reg, reg.getJeiHelpers().getGuiHelper());
        this.doAddDescriptions(reg);
        initFailed = false;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        initFailed = true;
        reg.addRecipeCategories(new IRecipeCategory[]{new AltarRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        initFailed = false;
    }

    private void doItemBlacklist(IIngredientBlacklist list) {
        int any = Short.MAX_VALUE;
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampInverted, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampInvertedDark, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampInvertedLight, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampLit, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampLitDark, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampLitLight, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.fluffyPuffPlant));
        list.addIngredientToBlacklist((Object)new ItemStack((Item)ModItems.toolRenderHelper));
        list.addIngredientToBlacklist((Object)new ItemStack((Item)ModItems.debugItem));
    }

    private void doRecipeRegistration(IModRegistry reg, IGuiHelper guiHelper) {
        reg.addRecipes(AltarRecipeMaker.getRecipes(), "silentgems:ChaosAltar");
        reg.addRecipes(ToolHelper.EXAMPLE_RECIPES, "minecraft.crafting");
        reg.addRecipes(RecipeSoulUrnModify.getExampleRecipes(), "minecraft.crafting");
        reg.addRecipeClickArea(GuiChaosAltar.class, 80, 34, 25, 16, new String[]{"silentgems:ChaosAltar"});
        reg.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.chaosAltar), new String[]{"silentgems:ChaosAltar"});
    }

    private void doAddDescriptions(IModRegistry reg) {
        this.addIngredientInfoPages(reg, SilentGems.registry.getBlocks());
        this.addIngredientInfoPages(reg, SilentGems.registry.getItems());
        reg.addIngredientInfo((Object)new ItemStack((Block)ModBlocks.chaosPylon, 1, 0), ItemStack.class, new String[]{this.getDescKey("chaospylon0")});
        reg.addIngredientInfo((Object)new ItemStack((Block)ModBlocks.chaosPylon, 1, 1), ItemStack.class, new String[]{this.getDescKey("chaospylon1")});
    }

    public void registerIngredients(IModIngredientRegistration arg0) {
    }

    public void registerItemSubtypes(ISubtypeRegistry reg) {
        initFailed = true;
        reg.registerSubtypeInterpreter((Item)ModItems.enchantmentToken, stack -> {
            Enchantment ench = ModItems.enchantmentToken.getSingleEnchantment(stack);
            return ench == null ? "none" : ench.func_77320_a();
        });
        reg.registerSubtypeInterpreter((Item)ModItems.chaosRune, stack -> {
            ChaosBuff buff = ModItems.chaosRune.getBuff(stack);
            return buff == null ? "none" : buff.getKey();
        });
        initFailed = false;
    }

    private void addIngredientInfoPages(IModRegistry registry, Collection<? extends IForgeRegistryEntry<?>> list) {
        for (IForgeRegistryEntry<?> obj : list) {
            String key = this.getDescKey(Objects.requireNonNull(obj.getRegistryName()));
            if (!SilentGems.i18n.hasKey(key)) continue;
            ItemStack stack = StackHelper.fromBlockOrItem(obj);
            stack.func_77964_b(Short.MAX_VALUE);
            registry.addIngredientInfo((Object)stack, ItemStack.class, new String[]{key});
        }
    }

    private String getDescKey(String name) {
        return "jei.silentgems." + name + ".desc";
    }

    private String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }
}

