/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.config.ConfigOption;

public class ConfigOptionToolClass
extends ConfigOption {
    public final String toolName;
    public Set<EnumMaterialTier> validTiers;
    public boolean isDisabled;

    public ConfigOptionToolClass(String toolName) {
        this.toolName = toolName;
    }

    public ConfigOption loadValue(Configuration c) {
        return this.loadValue(c, "main.items.tools." + this.toolName);
    }

    @Override
    public ConfigOption loadValue(Configuration c, String category) {
        return this.loadValue(c, category, "Configure tool class " + this.toolName);
    }

    @Override
    public ConfigOption loadValue(Configuration c, String category, String comment) {
        c.setCategoryComment(category, comment);
        c.setCategoryRequiresMcRestart(category, true);
        ArrayList tierList = Lists.newArrayList();
        for (EnumMaterialTier tier : EnumMaterialTier.values()) {
            boolean allowed = c.get(category, "Tier " + tier.name() + " Allowed", true).getBoolean();
            if (!allowed) continue;
            tierList.add(tier);
        }
        this.validTiers = ImmutableSet.copyOf((Collection)tierList);
        this.isDisabled = c.get(category, "Disable", false).getBoolean();
        return this.validate();
    }

    @Override
    public ConfigOption validate() {
        return this;
    }
}

