/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.ConfigOptionOreGen;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfigHC;
import net.silentchaos512.gems.enchantment.EnchantmentGravity;
import net.silentchaos512.gems.enchantment.EnchantmentIceAspect;
import net.silentchaos512.gems.enchantment.EnchantmentLifeSteal;
import net.silentchaos512.gems.enchantment.EnchantmentLightningAspect;
import net.silentchaos512.gems.enchantment.EnchantmentMagicDamage;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.lib.module.ModuleAprilTricks;
import net.silentchaos512.gems.lib.module.ModuleCoffee;
import net.silentchaos512.gems.lib.module.ModuleEntityRandomEquipment;
import net.silentchaos512.gems.lib.module.ModuleHalloweenHijinks;
import net.silentchaos512.gems.lib.module.ModuleHolidayCheer;
import net.silentchaos512.gems.potion.PotionFreezing;
import net.silentchaos512.gems.potion.PotionShocking;
import net.silentchaos512.gems.util.WeightedRandomItemSG;
import net.silentchaos512.lib.config.AdaptiveConfig;

public class GemsConfig
extends AdaptiveConfig {
    public static boolean DEBUG_MODE = false;
    public static boolean DEBUG_LOG_POTS_AND_LIGHTS = false;
    public static int DEBUG_LOT_POTS_AND_LIGHTS_DELAY = 1200;
    public static int GLOW_ROSE_LIGHT_LEVEL = 10;
    public static int TELEPORTER_FREE_RANGE = 64;
    public static int TELEPORTER_COST_PER_BLOCK = 100;
    public static int TELEPORTER_COST_CROSS_DIMENSION = 100000;
    public static int TELEPORTER_MAX_CHARGE = 1000000;
    public static float TELEPORTER_REDSTONE_SEARCH_RADIUS = 2.0f;
    public static boolean TELEPORTER_ALLOW_DUMB = true;
    public static int BURN_TIME_CHAOS_COAL = 6400;
    public static boolean SPAWN_PLAYER_WITH_GUIDE_BOOK = true;
    public static int FOOD_SUPPORT_DURATION = 600;
    public static float FOOD_SECRET_DONUT_CHANCE = 0.33f;
    public static float FOOD_SECRET_DONUT_TEXT_CHANCE = 0.6f;
    public static int RETURN_HOME_USE_TIME = 16;
    public static int RETURN_HOME_USE_COST = 10000;
    public static int RETURN_HOME_MAX_CHARGE = 100000;
    public static int FLUFFY_PUFF_SEED_WEIGHT = 2;
    public static float VARIETY_BONUS = 0.075f;
    public static int VARIETY_CAP = 3;
    public static int TOMAHAWK_MAX_AMMO = 4;
    public static int TOMAHAWK_AMMO_PER_MAT = 1;
    public static boolean SWITCH_AXE_SUPER = false;
    public static ConfigOptionToolClass sword = new ConfigOptionToolClass("sword");
    public static ConfigOptionToolClass dagger = new ConfigOptionToolClass("dagger");
    public static ConfigOptionToolClass katana = new ConfigOptionToolClass("katana");
    public static ConfigOptionToolClass machete = new ConfigOptionToolClass("machete");
    public static ConfigOptionToolClass scepter = new ConfigOptionToolClass("scepter");
    public static ConfigOptionToolClass tomahawk = new ConfigOptionToolClass("tomahawk");
    public static ConfigOptionToolClass pickaxe = new ConfigOptionToolClass("pickaxe");
    public static ConfigOptionToolClass shovel = new ConfigOptionToolClass("shovel");
    public static ConfigOptionToolClass axe = new ConfigOptionToolClass("axe");
    public static ConfigOptionToolClass paxel = new ConfigOptionToolClass("paxel");
    public static ConfigOptionToolClass hoe = new ConfigOptionToolClass("hoe");
    public static ConfigOptionToolClass sickle = new ConfigOptionToolClass("sickle");
    public static ConfigOptionToolClass bow = new ConfigOptionToolClass("hoe");
    public static ConfigOptionToolClass shield = new ConfigOptionToolClass("shield");
    public static ConfigOptionToolClass armor = new ConfigOptionToolClass("armor");
    public static boolean SOULS_GAIN_XP_FROM_FAKE_PLAYERS;
    public static boolean PART_DISABLE_ALL_MUNDANE;
    public static boolean PART_DISABLE_ALL_REGULAR;
    public static boolean PART_DISABLE_ALL_SUPER;
    public static List<String> PART_BLACKLIST;
    public static boolean CHAOS_NODE_SALT_DELAY;
    public static int CHAOS_NODE_PARTICLE_OVERRIDE;
    public static Set<Item> NODE_REPAIR_WHITELIST;
    public static Set<Item> NODE_REPAIR_BLACKLIST;
    public static int ENDER_SLIME_SPAWN_WEIGHT;
    public static int ENDER_SLIME_SPAWN_MIN;
    public static int ENDER_SLIME_SPAWN_MAX;
    public static boolean SHOW_BONUS_ARMOR_BAR;
    public static boolean CHAOS_BAR_SHOW_ALWAYS;
    public static boolean SHOW_ARROW_COUNT;
    public static int CHAOS_GEM_BAR_POS_X;
    public static int CHAOS_GEM_BAR_POS_Y;
    public static int CHAOS_BAR_OFFSET_X;
    public static int CHAOS_BAR_OFFSET_Y;
    public static boolean CHAOS_BAR_BUMP_HEIGHT;
    public static boolean RECIPE_TELEPORTER_DISABLE;
    public static boolean RECIPE_TELEPORTER_ANCHOR_DISABLE;
    public static boolean RECIPE_TELEPORTER_REDSTONE_DISABLE;
    public static boolean RECIPE_TOKEN_FROST_WALKER_DISABLE;
    public static boolean RECIPE_TOKEN_MENDING_DISABLE;
    public static boolean HIDE_FLAVOR_TEXT_ALWAYS;
    public static boolean HIDE_FLAVOR_TEXT_UNTIL_SHIFT;
    public static boolean RIGHT_CLICK_TO_PLACE_ENABLED;
    public static boolean RIGHT_CLICK_TO_PLACE_ON_SNEAK_ONLY;
    public static boolean ENABLE_SGEAR_MATERIALS;
    public static ConfigOptionOreGen WORLD_GEN_GEMS;
    public static ConfigOptionOreGen WORLD_GEN_GEMS_DARK;
    public static ConfigOptionOreGen WORLD_GEN_GEMS_LIGHT;
    public static boolean GEM_CLASSIC_USE_MULTI_ORE;
    public static boolean GEM_DARK_USE_MULTI_ORE;
    public static boolean GEM_LIGHT_USE_MULTI_ORE;
    public static ConfigOptionOreGen WORLD_GEN_CHAOS;
    public static ConfigOptionOreGen WORLD_GEN_ENDER;
    public static List<WeightedRandomItemSG> GEM_WEIGHTS;
    public static List<WeightedRandomItemSG> GEM_WEIGHTS_DARK;
    public static List<WeightedRandomItemSG> GEM_WEIGHTS_LIGHT;
    public static boolean GEM_REGIONS_ENABLED;
    public static int GEM_REGIONS_SIZE;
    public static float GEM_REGIONS_SECOND_GEM_CHANCE;
    public static float GEODE_DARK_FREQUENCY;
    public static float GEODE_LIGHT_FREQUENCY;
    public static int GEODE_MIN_Y;
    public static int GEODE_MAX_Y;
    public static float GEODE_FILL_RATIO;
    public static float GEODE_GEM_DENSITY;
    public static boolean GEODE_SEAL_BREAKS;
    public static int GLOW_ROSE_PER_CHUNK;
    public static final Set<Integer> GLOW_ROSE_DIMENSION_BLACKLIST;
    public static float CHAOS_NODES_PER_CHUNK;
    public static final Set<Integer> CHAOS_NODE_DIMENSION_BLACKLIST;
    static final String split = ".";
    public static final String CAT_MAIN = "main";
    public static final String CAT_DEBUG = "main.debug";
    public static final String CAT_BLOCK = "main.blocks";
    public static final String CAT_CHAOS = "main.chaos";
    public static final String CAT_COMPAT = "main.compat";
    public static final String CAT_CONTROLS = "main.controls";
    public static final String CAT_ENCHANTMENT = "main.enchantment";
    public static final String CAT_ENTITY = "main.entity";
    public static final String CAT_GUI = "main.gui";
    public static final String CAT_ITEM = "main.items";
    public static final String CAT_MISC = "main.misc";
    public static final String CAT_NODES = "main.chaos nodes";
    public static final String CAT_RECIPE = "main.recipes";
    public static final String CAT_TOOL_PARTS = "main.items.tool_parts";
    public static final String CAT_TOOL_SOULS = "main.items.tool_souls";
    public static final String CAT_TOOLS = "main.items.tools";
    public static final String CAT_TOOLTIPS = "main.tooltips";
    public static final String CAT_WORLD_GEN = "main.world generation";
    public static final String CAT_WORLD_GEN_GEM_WEIGHT = "main.world generation.gem weights";
    public static final String CAT_WORLD_GEN_GEODES = "main.world generation.gem geodes";
    public static final String CAT_WORLD_GEN_REGIONS = "main.world generation.gem regions";
    public static final GemsConfig INSTANCE;

    public GemsConfig() {
        super("silentgems", true, 327);
    }

    public void load() {
        try {
            String[] partBlacklistTemp;
            this.config.setCategoryComment(CAT_DEBUG, "Options for debugging. Generally, you should leave these alone unless I tell you to change them. Enabling debug options will likely result in log spam, but may help me track down issues.");
            DEBUG_MODE = this.config.getBoolean("Debug Mode", CAT_DEBUG, DEBUG_MODE, "Generic debug mode option. May add text to GUIs and WIT HUD.");
            DEBUG_LOG_POTS_AND_LIGHTS = this.config.getBoolean("Log Pots and Lights", CAT_DEBUG, DEBUG_LOG_POTS_AND_LIGHTS, "Logs the existence of Chaos Flower Pots and Phantom Lights. Their tile entities, to be more precise. Also lists the position of each one.");
            DEBUG_LOT_POTS_AND_LIGHTS_DELAY = this.config.getInt("Log Pots and Lights - Delay", CAT_DEBUG, DEBUG_LOT_POTS_AND_LIGHTS_DELAY, 600, 72000, "Pot and Light logging will occur every this many ticks. 1200 ticks = 1 minute.");
            String catGlowRose = "main.blocks.Glow Rose";
            GLOW_ROSE_LIGHT_LEVEL = this.config.getInt("Light Level", "main.blocks.Glow Rose", GLOW_ROSE_LIGHT_LEVEL, 0, 15, "The light level glow roses emit.");
            String catTeleporter = "main.blocks.Teleporter";
            TELEPORTER_ALLOW_DUMB = this.config.getBoolean("Allow Dumb Teleporters", "main.blocks.Teleporter", TELEPORTER_ALLOW_DUMB, "Allows teleports to happen even if the destination teleporter has been removed.");
            TELEPORTER_COST_CROSS_DIMENSION = this.config.getInt("Chaos Cost Cross Dimension", "main.blocks.Teleporter", TELEPORTER_COST_CROSS_DIMENSION, 0, Integer.MAX_VALUE, "The amount of Chaos charged for traveling between dimensions.");
            TELEPORTER_COST_PER_BLOCK = this.config.getInt("Chaos Cost Per Block", "main.blocks.Teleporter", TELEPORTER_COST_PER_BLOCK, 0, Integer.MAX_VALUE, "The amount of Chaos charged per block traveled.");
            TELEPORTER_FREE_RANGE = this.config.getInt("Free Range", "main.blocks.Teleporter", TELEPORTER_FREE_RANGE, 0, Integer.MAX_VALUE, "The distance that can be teleported for free.");
            TELEPORTER_MAX_CHARGE = this.config.getInt("Max Chaos", "main.blocks.Teleporter", TELEPORTER_MAX_CHARGE, 0, Integer.MAX_VALUE, "The maximum amount of Chaos a teleporter can store.");
            BURN_TIME_CHAOS_COAL = this.loadInt("Chaos Coal Burn Time", CAT_ITEM, BURN_TIME_CHAOS_COAL, 0, Integer.MAX_VALUE, "The burn time of Chaos Coal. Regular coal is 1600 ticks.");
            SPAWN_PLAYER_WITH_GUIDE_BOOK = this.loadBoolean("Spawn with Guide Book", CAT_ITEM, SPAWN_PLAYER_WITH_GUIDE_BOOK, "Should players be given a copy of the guide book when they first spawn?");
            if (ModItems.guideBook != null) {
                ModItems.guideBook.giveBookOnFirstLogin = SPAWN_PLAYER_WITH_GUIDE_BOOK;
            }
            String catFood = "main.items.Food";
            FOOD_SUPPORT_DURATION = this.loadInt("Support Duration", "main.items.Food", FOOD_SUPPORT_DURATION, 0, 72000, "The base duration of potion effects from food. The actual duration will vary by effect.");
            FOOD_SECRET_DONUT_CHANCE = this.config.getFloat("Secret Donut Effect Chance", "main.items.Food", FOOD_SECRET_DONUT_CHANCE, 0.0f, 1.0f, "The chance of secret donuts giving potion effects.");
            FOOD_SECRET_DONUT_TEXT_CHANCE = this.config.getFloat("Secret Donut Text Chance", "main.items.Food", FOOD_SECRET_DONUT_TEXT_CHANCE, 0.0f, 1.0f, "The chance of secrets donuts putting weird text in your chat.");
            String catReturnHome = "main.items.Return Home Charm";
            RETURN_HOME_USE_TIME = this.loadInt("Use Time", "main.items.Return Home Charm", RETURN_HOME_USE_TIME, 0, Integer.MAX_VALUE, "The number of ticks the Return Home Charm must be 'charged' to use. Set to 0 for instant use.");
            RETURN_HOME_USE_COST = this.loadInt("Use Cost", "main.items.Return Home Charm", RETURN_HOME_USE_COST, 0, Integer.MAX_VALUE, "The amount of Chaos required to teleport.");
            RETURN_HOME_MAX_CHARGE = this.loadInt("Max Charge", "main.items.Return Home Charm", RETURN_HOME_MAX_CHARGE, 0, Integer.MAX_VALUE, "The maximum amount of Chaos a charm can hold.");
            FLUFFY_PUFF_SEED_WEIGHT = this.loadInt("Fluffy Puff Seeds Weight", CAT_ITEM, 2, "Chance of fluffy puff seeds dropping from tall grass (larger number = more likely). Wheat seeds are 10. Set to zero to disable. (requires restart)");
            VARIETY_BONUS = this.config.getFloat("Variety Bonus", CAT_TOOLS, VARIETY_BONUS, 0.0f, 1.0f, "The \"variety bonus\" for mixed-material tools and armor. Default is a 7.5% bonus for each additional unique part.");
            VARIETY_CAP = this.config.getInt("Variety Cap", CAT_TOOLS, VARIETY_CAP, 1, 9, "The maximum number of unique parts that can affect the variety bonus");
            TOMAHAWK_MAX_AMMO = this.loadInt("Tomahawk Max Ammo", CAT_TOOLS, TOMAHAWK_MAX_AMMO, 0, 127, "The maximum \"ammo\" for tomahawks. This is the number that can be thrown before retrieval/repairs are required. Setting this to 0 will make it so tomahawks cannot be thrown.");
            TOMAHAWK_AMMO_PER_MAT = this.loadInt("Tomahawk Ammo per Material", CAT_TOOLS, TOMAHAWK_AMMO_PER_MAT, 0, 127, "The \"ammo\" restored by each material (gem, etc.) when decorating a tomahawk.");
            SWITCH_AXE_SUPER = this.loadBoolean("Switch Axe Super Skill to Area Miner", CAT_TOOLS, SWITCH_AXE_SUPER, "Change the super skill for axes to Area Miner. Useful if playing with Veinminer installed.");
            sword.loadValue(this.config);
            dagger.loadValue(this.config);
            katana.loadValue(this.config);
            machete.loadValue(this.config);
            scepter.loadValue(this.config);
            tomahawk.loadValue(this.config);
            pickaxe.loadValue(this.config);
            shovel.loadValue(this.config);
            axe.loadValue(this.config);
            paxel.loadValue(this.config);
            hoe.loadValue(this.config);
            sickle.loadValue(this.config);
            bow.loadValue(this.config);
            shield.loadValue(this.config);
            armor.loadValue(this.config);
            SOULS_GAIN_XP_FROM_FAKE_PLAYERS = this.loadBoolean("Gain XP From Fake Players", CAT_TOOL_SOULS, false, "If true, tools with souls can gain XP when used by fake players.");
            String catPartDisable = "main.items.tool_parts.disable";
            this.config.setCategoryRequiresMcRestart(catPartDisable, true);
            this.config.setCategoryComment(catPartDisable, "Disable specific tool parts or entire tiers. As a reminder: Mundane includes flint, Regular is ordinary gems, and Super is supercharged gems. Hover over the item for the tool part and hold Ctrl to see the tier.");
            PART_DISABLE_ALL_MUNDANE = this.config.get(catPartDisable, "All Mundane Tier", false).getBoolean();
            PART_DISABLE_ALL_REGULAR = this.config.get(catPartDisable, "All Regular Tier", false).getBoolean();
            PART_DISABLE_ALL_SUPER = this.config.get(catPartDisable, "All Super Tier", false).getBoolean();
            for (String str : partBlacklistTemp = this.config.getStringList("Blacklist", catPartDisable, new String[0], "You can disable individual parts by listing the part keys here, if disabling groups with the other settings doesn't cut it. Hover over the item in-game and hold Ctrl+Shift to reveal the part key.")) {
                PART_BLACKLIST.add(str);
            }
            String enchEnabledComment = "Allow this enchantment to be applied at the enchanting table. Enchantment tokens will still work.";
            EnchantmentGravity.ENABLED = this.loadBoolean("Gravity - Enabled", CAT_ENCHANTMENT, true, enchEnabledComment);
            EnchantmentIceAspect.ENABLED = this.loadBoolean("Ice Aspect - Enabled", CAT_ENCHANTMENT, true, enchEnabledComment);
            EnchantmentLifeSteal.ENABLED = this.loadBoolean("Life Steal - Enabled", CAT_ENCHANTMENT, true, enchEnabledComment);
            EnchantmentLightningAspect.ENABLED = this.loadBoolean("Lightning Aspect - Enabled", CAT_ENCHANTMENT, true, enchEnabledComment);
            EnchantmentMagicDamage.ENABLED = this.loadBoolean("Concentration - Enabled", CAT_ENCHANTMENT, true, enchEnabledComment);
            PotionFreezing.CONTINUOUS_DAMAGE_ENABLED = this.loadBoolean("Ice Aspect - DoT Enabled", CAT_ENCHANTMENT, true, "Allow the damage over time (DoT) of Ice Aspect. Disabling will still apply the slowing effect.");
            PotionShocking.CONTINUOUS_DAMAGE_ENABLED = this.loadBoolean("Lightning Aspect - DoT Enabled", CAT_ENCHANTMENT, true, "Allow the damage over time (DoT) of Lightning Aspect. Disabling will still apply the slowing effect.");
            PotionShocking.CHAINING_ENABLED = this.loadBoolean("Lightning Aspect - Chaining Enabled", CAT_ENCHANTMENT, true, "Allow the chaining effect of Lightning Aspect, where the effect spreads to nearby entities.");
            CHAOS_NODE_SALT_DELAY = this.loadBoolean("Salted Delay", CAT_NODES, true, "Adds a extra value to the delays on node activity. The value is not truly random but based on the position of the node. If disabled, all nodes will try the same effect at the same time.");
            CHAOS_NODE_PARTICLE_OVERRIDE = this.loadInt("Particle Setting Override", CAT_NODES, CHAOS_NODE_PARTICLE_OVERRIDE, -1, 2, "Override vanilla particle settings for chaos nodes. -1 will use vanilla settings, 0 is All, 1 is Decreased, and 2 is Minimal");
            GemsConfig.loadNodeItemList(true, this.config.getStringList("Repair Whitelist", CAT_NODES, new String[0], "Repair packets will try to repair these items, if possible. REMOVING ITEMS REQUIRES A RESTART."));
            GemsConfig.loadNodeItemList(false, this.config.getStringList("Repair Blacklist", CAT_NODES, new String[0], "Repair packets will not try to repair these items. REMOVING ITEMS REQUIRES A RESTART."));
            String catEnderSlime = "main.entity.ender_slime";
            this.config.setCategoryRequiresMcRestart(catEnderSlime, true);
            ENDER_SLIME_SPAWN_WEIGHT = this.loadInt("Spawn Weight", catEnderSlime, ENDER_SLIME_SPAWN_WEIGHT, 0, Integer.MAX_VALUE, "Spawn weight (how common they are). Set to 0 to disable.");
            ENDER_SLIME_SPAWN_MIN = this.loadInt("Spawn Min", catEnderSlime, ENDER_SLIME_SPAWN_MIN, 1, 8, "Minimum group size. Should be less than or equal to max.");
            ENDER_SLIME_SPAWN_MAX = this.loadInt("Spawn Max", catEnderSlime, ENDER_SLIME_SPAWN_MAX, 1, 8, "Maximum group size. Should be greater than or equal to min.");
            if (ENDER_SLIME_SPAWN_MIN > ENDER_SLIME_SPAWN_MAX) {
                ENDER_SLIME_SPAWN_MIN = ENDER_SLIME_SPAWN_MAX;
            }
            SHOW_BONUS_ARMOR_BAR = this.loadBoolean("Show Bonus Armor Bar", CAT_GUI, SHOW_BONUS_ARMOR_BAR, "Shows armor points beyond 20 on the bar as yellow armor pieces above the normal ones.");
            CHAOS_BAR_SHOW_ALWAYS = this.loadBoolean("Show Chaos Bar Always", CAT_GUI, CHAOS_BAR_SHOW_ALWAYS, "Show the chaos bar at all times. By default, it only shows when you gain/lose chaos.");
            SHOW_ARROW_COUNT = this.loadBoolean("Show Arrow Count", CAT_GUI, true, "Show how many arrows you have (and what kind will be fired) when you have a bow equipped. Compatible with quivers!");
            CHAOS_GEM_BAR_POS_X = this.loadInt("Chaos Gem Charge Bar X", CAT_GUI, CHAOS_GEM_BAR_POS_X, "The X position for chaos gem charge bars. Negative numbers will anchor to the right of the screen.");
            CHAOS_GEM_BAR_POS_Y = this.loadInt("Chaos Gem Charge Bar Y", CAT_GUI, CHAOS_GEM_BAR_POS_Y, "The Y position for chaos gem charge bars. Negative numbers will anchor to the bottom of the screen.");
            CHAOS_BAR_OFFSET_X = this.loadInt("Chaos Bar Offset X", CAT_GUI, CHAOS_BAR_OFFSET_X, "X offset for the player's chaos bar, relative to its normal position.");
            CHAOS_BAR_OFFSET_Y = this.loadInt("Chaos Bar Offset Y", CAT_GUI, CHAOS_BAR_OFFSET_Y, "Y offset for the player's chaos bar, relative to its normal position.");
            CHAOS_BAR_BUMP_HEIGHT = this.loadBoolean("Chaos Bar Bump Height", CAT_GUI, true, "Set false if you are moving the chaos bar to a different position. If true, increases the \"GUI height\" variable when drawing the chaos bar. The variable affects the position of other bars drawn on the same side.");
            this.config.setCategoryRequiresMcRestart(CAT_RECIPE, true);
            RECIPE_TELEPORTER_DISABLE = this.loadBoolean("Disable Regular Teleporter Recipes", CAT_RECIPE, RECIPE_TELEPORTER_DISABLE, "Disable recipes for regular gem teleporters.");
            RECIPE_TELEPORTER_ANCHOR_DISABLE = this.loadBoolean("Disable Teleporter Anchor Recipes", CAT_RECIPE, RECIPE_TELEPORTER_ANCHOR_DISABLE, "Disable recipes for teleporter anchors.");
            RECIPE_TELEPORTER_REDSTONE_DISABLE = this.loadBoolean("Disable Redstone Teleporter Recipes", CAT_RECIPE, RECIPE_TELEPORTER_REDSTONE_DISABLE, "Disable recipes for redstone gem teleporters.");
            RECIPE_TOKEN_FROST_WALKER_DISABLE = this.loadBoolean("Disable Frost Walker Token Recipe", CAT_RECIPE, RECIPE_TOKEN_FROST_WALKER_DISABLE, "Disables recipes for Frost Walker enchantment tokens.");
            RECIPE_TOKEN_MENDING_DISABLE = this.loadBoolean("Disable Mending Token Recipe", CAT_RECIPE, RECIPE_TOKEN_MENDING_DISABLE, "Disables recipes for Mending enchantment tokens.");
            HIDE_FLAVOR_TEXT_ALWAYS = this.loadBoolean("Hide Flavor Text - Always", CAT_TOOLTIPS, HIDE_FLAVOR_TEXT_ALWAYS, "Always hide the potentially funny, but useless item descriptions.");
            HIDE_FLAVOR_TEXT_UNTIL_SHIFT = this.loadBoolean("Hide Flavor Text - Until Shift", CAT_TOOLTIPS, HIDE_FLAVOR_TEXT_UNTIL_SHIFT, "Hide the flavor text until shift is pressed.");
            String catRctp = "main.controls.Right-click to place";
            this.config.setCategoryComment("main.controls.Right-click to place", "Mining tools have the ability to place blocks in the slot after them (or in slot 9 if that doesn't work) by right-clicking.");
            RIGHT_CLICK_TO_PLACE_ENABLED = this.loadBoolean("Enabled", "main.controls.Right-click to place", RIGHT_CLICK_TO_PLACE_ENABLED, "If set to false, the ability of mining tools to place blocks by right-clicking will be completely disabled.");
            RIGHT_CLICK_TO_PLACE_ON_SNEAK_ONLY = this.loadBoolean("Only When Sneaking", "main.controls.Right-click to place", RIGHT_CLICK_TO_PLACE_ON_SNEAK_ONLY, "If set to true and right-click to place is enabled, this ability will only activate while sneaking (holding shift, normally).");
            this.config.setCategoryRequiresMcRestart(CAT_COMPAT, true);
            ENABLE_SGEAR_MATERIALS = this.loadBoolean("Silent Gear Materials", CAT_COMPAT, true, "Set to false to disable registration of Silent Gear materials.");
            GLOW_ROSE_PER_CHUNK = this.loadInt("Flowers per Chunk", CAT_WORLD_GEN, GLOW_ROSE_PER_CHUNK, 0, 100, "The number of glow roses to attempt to spawn per chunk.");
            CHAOS_NODES_PER_CHUNK = this.config.getFloat("Chaos Nodes per Chunk", CAT_WORLD_GEN, CHAOS_NODES_PER_CHUNK, 0.0f, 8.0f, "The number of chaos nodes to try to spawn per chunk. If less than 1 (recommended), you can think of this as the chance to spawn in a chunk.");
            GLOW_ROSE_DIMENSION_BLACKLIST.clear();
            GLOW_ROSE_DIMENSION_BLACKLIST.addAll(this.tryParseDimensionList(this.config.getStringList("Flowers Dimension Blacklist", CAT_WORLD_GEN, new String[0], "The dimensions that glow roses may not spawn in.")));
            CHAOS_NODE_DIMENSION_BLACKLIST.clear();
            CHAOS_NODE_DIMENSION_BLACKLIST.addAll(this.tryParseDimensionList(this.config.getStringList("Chaos Node Dimension Blacklist", CAT_WORLD_GEN, new String[0], "The dimensions that chaos nodes may not spawn in.")));
            String catGemsClassic = "Gems (Overworld)";
            WORLD_GEN_GEMS = new ConfigOptionOreGen(catGemsClassic, 0, 10.0f, 8, 5, 45);
            WORLD_GEN_GEMS.loadValue(this.config, CAT_WORLD_GEN);
            GEM_CLASSIC_USE_MULTI_ORE = this.loadBoolean("Replace With Multi Gem Ore", "main.world generation." + catGemsClassic, false, "Replace all classic gem ores with multi-gem ore, a single block that drops random classic gems.");
            String catGemsDark = "Dark Gems (Nether)";
            WORLD_GEN_GEMS_DARK = new ConfigOptionOreGen(catGemsDark, -1, 12.5f, 10, 30, 100);
            WORLD_GEN_GEMS_DARK.loadValue(this.config, CAT_WORLD_GEN);
            GEM_DARK_USE_MULTI_ORE = this.loadBoolean("Replace With Multi Gem Ore", "main.world generation." + catGemsDark, false, "Replace all dark gem ores with multi-gem ore, a single block that drops random dark gems.");
            String catGemsLight = "Light Gems (The End)";
            WORLD_GEN_GEMS_LIGHT = new ConfigOptionOreGen(catGemsLight, 1, 12.5f, 8, 16, 64);
            WORLD_GEN_GEMS_LIGHT.loadValue(this.config, CAT_WORLD_GEN);
            GEM_LIGHT_USE_MULTI_ORE = this.loadBoolean("Replace With Multi Gem Ore", "main.world generation." + catGemsLight, false, "Replace all light gem ores with multi-gem ore, a single block that drops random light gems.");
            WORLD_GEN_CHAOS = new ConfigOptionOreGen("Chaos Ore", 0, 1.75f, 16, 5, 20);
            WORLD_GEN_CHAOS.loadValue(this.config, CAT_WORLD_GEN);
            WORLD_GEN_ENDER = new ConfigOptionOreGen("Ender Essence Ore", 1, 1.0f, 32, 10, 70);
            WORLD_GEN_ENDER.loadValue(this.config, CAT_WORLD_GEN);
            int weightMax = 1000;
            this.config.setCategoryComment(CAT_WORLD_GEN_GEM_WEIGHT, "The spawn weights of the gems. If two gems have different weights, the gem with the\nhigher weight is more likely to be selected when placing gems in the world.\nJust increasing weights will NOT increase the number of gems that spawn!\nValues must be between 1 and 1000, inclusive.");
            block8: for (EnumGem gem : EnumGem.values()) {
                int k = this.config.get(CAT_WORLD_GEN_GEM_WEIGHT, gem.getGemName(), 10).getInt();
                k = MathHelper.func_76125_a((int)k, (int)1, (int)1000);
                WeightedRandomItemSG item = new WeightedRandomItemSG(k, gem.ordinal() & 0xF);
                switch (gem.getSet()) {
                    case CLASSIC: {
                        GEM_WEIGHTS.add(item);
                        continue block8;
                    }
                    case DARK: {
                        GEM_WEIGHTS_DARK.add(item);
                        continue block8;
                    }
                    case LIGHT: {
                        GEM_WEIGHTS_LIGHT.add(item);
                    }
                }
            }
            this.config.setCategoryComment(CAT_WORLD_GEN_REGIONS, "Settings for \"gem regions\". This will randomly assign one or two gems to spawn in each region in the overworld. This does not consider things like biomes, it's purely random. The usual world gen configs still apply, this only changes which gem type is selected for each vein.");
            GEM_REGIONS_ENABLED = this.loadBoolean("Enable", CAT_WORLD_GEN_REGIONS, false, "Enables gem regions.");
            GEM_REGIONS_SIZE = this.loadInt("Region Size", CAT_WORLD_GEN_REGIONS, 12, 1, 256, "Each region is a square of this many chunks on each side.");
            GEM_REGIONS_SECOND_GEM_CHANCE = this.config.getFloat("Second Gem Chance", CAT_WORLD_GEN_REGIONS, 0.75f, 0.0f, 1.0f, "The chance of a second gem being selected to spawn in the region.");
            this.config.setCategoryComment(CAT_WORLD_GEN_GEODES, "Geodes are deposits of Nether/End gems that spawn rarely in the overworld and similar dimensions. They are large, but encased in a tough shell.");
            GEODE_DARK_FREQUENCY = this.config.getFloat("Dark Geode Frequency", CAT_WORLD_GEN_GEODES, 0.0125f, 0.0f, 1.0f, "The chance a geode of Nether (dark) gems will spawn in any given chunk.");
            GEODE_LIGHT_FREQUENCY = this.config.getFloat("Light Geode Frequency", CAT_WORLD_GEN_GEODES, 0.0125f, 0.0f, 1.0f, "The chance a geode of End (light) gems will spawn in any given chunk.");
            GEODE_FILL_RATIO = this.config.getFloat("Fill Ratio", CAT_WORLD_GEN_GEODES, 0.6f, 0.0f, 1.0f, "The ratio of geodes that will attempt to fill with gems.");
            GEODE_GEM_DENSITY = this.config.getFloat("Gem Density", CAT_WORLD_GEN_GEODES, 0.75f, 0.0f, 1.0f, "The density of gems in the filled region of the geode.");
            GEODE_MIN_Y = this.loadInt("Min Y", CAT_WORLD_GEN_GEODES, 20, 0, 255, "The minimum height geodes will attempt to spawn at.");
            GEODE_MAX_Y = this.loadInt("Max Y", CAT_WORLD_GEN_GEODES, 40, 0, 255, "The maximum height geodes will attempt to spawn at.");
            GEODE_SEAL_BREAKS = this.loadBoolean("Seal Breaks", CAT_WORLD_GEN_GEODES, true, "If the geode is \"broken\" (intersects with a cave or something), the world generator will seal the break.");
            GemsConfigHC.load(this);
        }
        catch (Exception e) {
            SilentGems.logHelper.error("Could not load configuration file!", new Object[0]);
            SilentGems.logHelper.catching((Throwable)e);
        }
    }

    public static void loadNodeItemList(boolean whitelist, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            Item item = Item.func_111206_d((String)list[i]);
            if (item == null) continue;
            if (whitelist) {
                NODE_REPAIR_WHITELIST.add(item);
                continue;
            }
            NODE_REPAIR_BLACKLIST.add(item);
        }
    }

    public void loadModuleConfigs() {
        ModuleCoffee.loadConfig(this.config);
        ModuleEntityRandomEquipment.loadConfig(this.config);
        ModuleHolidayCheer.instance.loadConfig(this.config);
        ModuleAprilTricks.instance.loadConfig(this.config);
        ModuleHalloweenHijinks.instance.loadConfig(this.config);
    }

    private Collection<Integer> tryParseDimensionList(String[] dims) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String str : dims) {
            try {
                list.add(Integer.parseInt(str));
            }
            catch (NumberFormatException ex) {
                SilentGems.logHelper.debug("Could not parse \"" + str + "\" as integer for dimension blacklist.", new Object[0]);
            }
        }
        return list;
    }

    static {
        PART_DISABLE_ALL_MUNDANE = false;
        PART_DISABLE_ALL_REGULAR = false;
        PART_DISABLE_ALL_SUPER = false;
        PART_BLACKLIST = Lists.newArrayList();
        CHAOS_NODE_SALT_DELAY = true;
        CHAOS_NODE_PARTICLE_OVERRIDE = -1;
        NODE_REPAIR_WHITELIST = new HashSet<Item>();
        NODE_REPAIR_BLACKLIST = new HashSet<Item>();
        ENDER_SLIME_SPAWN_WEIGHT = 3;
        ENDER_SLIME_SPAWN_MIN = 1;
        ENDER_SLIME_SPAWN_MAX = 2;
        SHOW_BONUS_ARMOR_BAR = true;
        CHAOS_BAR_SHOW_ALWAYS = false;
        SHOW_ARROW_COUNT = true;
        CHAOS_GEM_BAR_POS_X = 5;
        CHAOS_GEM_BAR_POS_Y = 5;
        CHAOS_BAR_OFFSET_X = 0;
        CHAOS_BAR_OFFSET_Y = 0;
        CHAOS_BAR_BUMP_HEIGHT = true;
        RECIPE_TELEPORTER_DISABLE = false;
        RECIPE_TELEPORTER_ANCHOR_DISABLE = false;
        RECIPE_TELEPORTER_REDSTONE_DISABLE = false;
        RECIPE_TOKEN_FROST_WALKER_DISABLE = false;
        RECIPE_TOKEN_MENDING_DISABLE = false;
        HIDE_FLAVOR_TEXT_ALWAYS = false;
        HIDE_FLAVOR_TEXT_UNTIL_SHIFT = true;
        RIGHT_CLICK_TO_PLACE_ENABLED = true;
        RIGHT_CLICK_TO_PLACE_ON_SNEAK_ONLY = false;
        ENABLE_SGEAR_MATERIALS = true;
        GEM_WEIGHTS = new ArrayList<WeightedRandomItemSG>();
        GEM_WEIGHTS_DARK = new ArrayList<WeightedRandomItemSG>();
        GEM_WEIGHTS_LIGHT = new ArrayList<WeightedRandomItemSG>();
        GLOW_ROSE_PER_CHUNK = 2;
        GLOW_ROSE_DIMENSION_BLACKLIST = new HashSet<Integer>();
        CHAOS_NODES_PER_CHUNK = 0.006f;
        CHAOS_NODE_DIMENSION_BLACKLIST = new HashSet<Integer>();
        INSTANCE = new GemsConfig();
    }
}

