/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentFireAspect;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.silentchaos512.gems.enchantment.EnchantmentLightningAspect;
import net.silentchaos512.gems.init.ModPotions;

public class EnchantmentIceAspect
extends Enchantment {
    public static final int EFFECT_DURATION = 80;
    public static boolean ENABLED = true;

    public EnchantmentIceAspect() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b("silentgems.iceaspect");
    }

    public boolean func_77326_a(Enchantment ench) {
        return !(ench instanceof EnchantmentFireAspect) && !(ench instanceof EnchantmentLightningAspect) && super.func_77326_a(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (!ENABLED) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemSword;
    }

    public int func_77321_a(int level) {
        return 10 + 20 * (level - 1);
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 2;
    }

    public void applyTo(EntityLivingBase entityLiving, int enchLevel) {
        int duration = this.getEffectDuration(entityLiving, enchLevel);
        int amplifier = enchLevel - 1;
        entityLiving.func_70690_d(new PotionEffect((Potion)ModPotions.freezing, duration, amplifier, true, false));
    }

    private int getEffectDuration(EntityLivingBase entityLiving, int enchLevel) {
        int ret = 80 + (enchLevel - 1) * 80 / 2;
        if (entityLiving instanceof EntityPlayer) {
            ret /= 2;
        }
        return ret;
    }
}

