/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.silentchaos512.gems.entity.EntityChaosProjectile;

public class EntityChaosProjectileScatter
extends EntityChaosProjectile {
    static final float SPEED_MULTI = 2.0f;
    static final float SCATTER_ANGLE = 3.455752f;

    public EntityChaosProjectileScatter(World worldIn) {
        super(worldIn);
        this.setProperties();
    }

    public EntityChaosProjectileScatter(EntityLivingBase shooter, ItemStack castingStack, float damage) {
        super(shooter, castingStack, damage);
        this.setProperties();
    }

    private void setProperties() {
        this.bounciness = 0.5;
        this.bounces = 2;
        this.gravity = 0.0f;
    }

    @Override
    protected void setStartingVelocity(EntityLivingBase shooter, Random random) {
        float pitch = (float)((double)shooter.field_70125_A + 3.455751895904541 * (2.0 * random.nextDouble() - 1.0));
        float yaw = (float)((double)shooter.field_70177_z + 3.455751895904541 * (2.0 * random.nextDouble() - 1.0));
        Vec3d vec = Vec3d.func_189986_a((float)pitch, (float)yaw);
        this.field_70159_w = 2.0 * vec.field_72450_a + shooter.field_70159_w;
        this.field_70181_x = 2.0 * vec.field_72448_b + shooter.field_70181_x;
        this.field_70179_y = 2.0 * vec.field_72449_c + shooter.field_70179_y;
    }

    @Override
    public int getMaxLife() {
        return 40;
    }

    @Override
    public float func_70185_h() {
        return 0.0f;
    }

    @Override
    public void onImpactWithEntity(RayTraceResult mop) {
        if (!mop.field_72308_g.field_70170_p.field_72995_K) {
            DamageQueue.addDamage(mop.field_72308_g, (Entity)this.shooter, this.damage);
        }
        this.func_70106_y();
    }

    public static class DamageQueue {
        private static List<DamageQueue> list = new ArrayList<DamageQueue>();
        Entity target;
        Entity shooter;
        float totalDamage;

        static void addDamage(Entity target, Entity shooter, float amount) {
            for (DamageQueue d : list) {
                if (d.target != target || d.shooter != shooter) continue;
                d.totalDamage += amount;
                return;
            }
            DamageQueue d = new DamageQueue();
            d.target = target;
            d.shooter = shooter;
            d.totalDamage = amount;
            list.add(d);
        }

        public static void processDamage() {
            for (DamageQueue d : list) {
                d.target.func_70097_a(DamageSource.func_76354_b((Entity)d.shooter, (Entity)d.shooter), d.totalDamage);
                d.target.field_70172_ad = 0;
            }
            list.clear();
        }
    }
}

