/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.lib.util.PlayerHelper;

public class EntityThrownTomahawk
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public static final int SPIN_RATE = 45;
    public static final float MAX_SPEED = 1.7f;
    protected EntityLivingBase field_70192_c;
    protected ItemStack thrownStack;
    protected float initialSpeed = 0.0f;
    public float throwYaw = 0.0f;
    public int spin = 270;
    public boolean inAir = true;
    public boolean hasHit = false;

    public EntityThrownTomahawk(World worldIn) {
        super(worldIn);
    }

    public EntityThrownTomahawk(EntityLivingBase throwerIn, ItemStack thrownStackIn, float speed) {
        super(throwerIn.field_70170_p);
        this.field_70192_c = throwerIn;
        this.thrownStack = thrownStackIn;
        this.throwYaw = this.field_70192_c.field_70177_z;
        Vec3d vec = this.field_70192_c.func_70040_Z();
        this.initialSpeed = speed;
        this.field_70159_w = (double)speed * (vec.field_72450_a + this.field_70192_c.field_70159_w);
        this.field_70181_x = (double)speed * (vec.field_72448_b + this.field_70192_c.field_70181_x);
        this.field_70179_y = (double)speed * (vec.field_72449_c + this.field_70192_c.field_70179_y);
    }

    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74782_a("item", (NBTBase)this.thrownStack.serializeNBT());
    }

    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.thrownStack = new ItemStack((Item)ModItems.tomahawk);
        this.thrownStack.deserializeNBT(tags.func_74775_l("item"));
    }

    public void writeSpawnData(ByteBuf data) {
        int id = this.field_70192_c == null ? this.func_145782_y() : this.field_70192_c.func_145782_y();
        data.writeInt(id);
        data.writeFloat(this.field_70177_z);
        data.writeInt(this.spin);
        data.writeDouble(this.field_70159_w);
        data.writeDouble(this.field_70181_x);
        data.writeDouble(this.field_70179_y);
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.thrownStack);
    }

    public void readSpawnData(ByteBuf data) {
        Entity entity = this.field_70170_p.func_73045_a(data.readInt());
        if (entity instanceof EntityLivingBase) {
            this.field_70192_c = (EntityLivingBase)entity;
        }
        this.field_70177_z = data.readFloat();
        this.spin = data.readInt();
        this.field_70159_w = data.readInt();
        this.field_70181_x = data.readInt();
        this.field_70179_y = data.readInt();
        try {
            this.thrownStack = ByteBufUtils.readItemStack((ByteBuf)data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d vec1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec1, vec2, false, true, false);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.func_70184_a(raytraceresult);
        }
        if (this.thrownStack == null || this.thrownStack.func_77973_b() == null || this.field_70173_aa > 12000) {
            this.func_70106_y();
            if (this.field_70173_aa > 10) {
                for (int i = 0; i < 15; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.01 * SilentGems.random.nextGaussian(), 0.05 * SilentGems.random.nextGaussian(), 0.01 * SilentGems.random.nextGaussian(), new int[0]);
                }
            }
        }
        if (!this.inAir && this.field_70173_aa > 10) {
            for (EntityPlayer player : this.field_70170_p.func_175661_b(EntityPlayer.class, p -> p.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) < 2.0)) {
                for (ItemStack stack : PlayerHelper.getNonEmptyStacks((EntityPlayer)player)) {
                    if (!ToolHelper.areToolsEqual(stack, this.thrownStack)) continue;
                    ModItems.tomahawk.addAmmo(this.thrownStack, 1);
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 0.5f, 1.5f);
                    this.func_70106_y();
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.hasHit && !this.inAir && this.field_70173_aa % 4 == 0) {
            SilentGems.proxy.spawnParticles(EnumModParticles.CHAOS, Color.WHITE, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.01 * SilentGems.random.nextGaussian(), 0.125, 0.01 * SilentGems.random.nextGaussian());
        }
        float spinRate = (float)(this.inAir ? 45.0 : 30.0 * Math.abs(this.field_70181_x));
        this.spin = (int)((float)this.spin + spinRate);
        if (this.spin >= 360) {
            this.spin -= 360;
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != this.field_70192_c && !this.hasHit) {
            this.onImpactWithEntity(result);
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.onImpactWithBlock(result.func_178782_a(), this.field_70170_p.func_180495_p(result.func_178782_a()));
        }
    }

    protected void onImpactWithEntity(RayTraceResult result) {
        Entity entityHit = result.field_72308_g;
        this.hasHit = true;
        this.field_70159_w = (double)0.001f * SilentGems.random.nextGaussian();
        this.field_70181_x = Math.abs((double)0.01f * SilentGems.random.nextGaussian());
        this.field_70179_y = (double)0.001f * SilentGems.random.nextGaussian();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (entityHit instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityHit;
            float entityHealthBeforeDamage = entityLiving.func_110143_aJ();
            boolean headshot = this.isHeadshot(result);
            float damageDealt = ModItems.tomahawk.getThrownDamage(this.thrownStack) * this.initialSpeed / 1.7f;
            if (headshot) {
                damageDealt *= 2.0f;
            }
            if (this.field_70192_c instanceof EntityPlayer) {
                entityHit.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.field_70192_c)), damageDealt);
            } else {
                entityHit.func_70097_a(DamageSource.func_76356_a((Entity)this.field_70192_c, (Entity)entityHit), damageDealt);
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, headshot ? SoundEvents.field_187718_dS : SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 0.75f, 1.0f);
            if (this.field_70170_p instanceof WorldServer) {
                WorldServer world = (WorldServer)this.field_70170_p;
                float healthDiff = entityHealthBeforeDamage - entityLiving.func_110143_aJ();
                world.func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, entityHit.field_70165_t, entityHit.field_70163_u + (double)(entityHit.field_70131_O / 2.0f), entityHit.field_70161_v, (int)(healthDiff / 2.0f), 0.1, 0.0, 0.1, 0.2, new int[0]);
                if (headshot && this.field_70192_c instanceof EntityPlayer) {
                    ((EntityPlayer)this.field_70192_c).func_71009_b(entityHit);
                }
            }
        }
    }

    protected boolean isHeadshot(RayTraceResult result) {
        Entity entity = result.field_72308_g;
        float eyeHeight = entity.func_70047_e();
        float height = entity.field_70131_O;
        float minY = (float)(entity.field_70163_u + (double)eyeHeight - (double)(height / 7.0f));
        float maxY = (float)(entity.field_70163_u + (double)eyeHeight + (double)(height / 2.0f));
        return this.field_70163_u > (double)minY && this.field_70163_u < (double)maxY;
    }

    protected void onImpactWithBlock(BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        AxisAlignedBB boundingBox = state.func_185900_c((IBlockAccess)this.field_70170_p, pos);
        if (boundingBox != null) {
            Material mat = state.func_185904_a();
            if (block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175698_g(pos);
                    this.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.field_70159_w *= (double)0.7f;
                this.field_70179_y *= (double)0.7f;
            } else if (mat == Material.field_151584_j || mat == Material.field_151585_k || mat == Material.field_151582_l) {
                SoundEvent sound = block.getSoundType(state, this.field_70170_p, pos, (Entity)this).func_185841_e();
                this.field_70170_p.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 0.25f, 1.0f);
            } else {
                if (this.field_70159_w > (double)0.1f || this.field_70179_y > (double)0.1f) {
                    SoundEvent sound = block.getSoundType(state, this.field_70170_p, pos, (Entity)this).func_185841_e();
                    this.field_70170_p.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.hasHit = true;
                this.inAir = false;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
        }
    }

    public EntityLivingBase func_85052_h() {
        return this.field_70192_c;
    }

    public ItemStack getThrownStack() {
        return this.thrownStack;
    }

    protected void func_70044_A() {
    }

    public void func_181015_d(BlockPos pos) {
    }
}

