/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.guide.page;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.lib.soul.EnumSoulElement;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.page.PageTextOnly;

public class PageSoulSkill
extends PageTextOnly {
    private final SoulSkill skill;

    public PageSoulSkill(GuideBook book, SoulSkill skill) {
        super(book, 0);
        this.skill = skill;
    }

    public String getInfoText() {
        String elementPreference = this.skill.favoredElements.length == 0 ? "none" : (this.skill.isLockedToFavoredElements() ? "lockedTo" : "favors");
        Object[] elements = "";
        for (EnumSoulElement elem : this.skill.favoredElements) {
            if (!elements.isEmpty()) {
                elements = (String)elements + ", ";
            }
            elements = (String)elements + elem.getDisplayName();
        }
        elementPreference = this.book.i18n.translate("guide.silentgems.soulSkillPage.elements." + elementPreference, new Object[]{elementPreference.equals("none") ? new Object[]{} : elements});
        String str = this.book.i18n.translate("guide", "soulSkillPage", new Object[]{this.skill.getLocalizedName(null, 0), Integer.toString(this.skill.maxLevel), Integer.toString(this.skill.apCost), elementPreference});
        str = str + "\n\n" + this.book.i18n.translate(this.getLocalizationKey(), new Object[0]);
        return this.doTextReplacements(str);
    }

    @SideOnly(value=Side.CLIENT)
    protected String getLocalizationKey() {
        return "guide." + this.book.getModId() + ".chapter." + this.chapter.getIdentifier() + "." + this.skill.id;
    }
}

