/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.RecipeMaker;

public enum CraftingItems {
    CHAOS_ESSENCE(0, "chaosessence"),
    ENRICHED_CHAOS_ESSENCE(1, "chaosessenceplus"),
    CRYSTALLIZED_CHAOS_ESSENCE(2, "chaosessenceplus2"),
    CHAOS_ESSENCE_SHARD(3, "chaosessenceshard"),
    ENDER_ESSENCE(4, "enderessence"),
    ENDER_FROST(18, "enderfrost"),
    ENDER_ESSENCE_SHARD(5, "enderessenceshard"),
    CHAOS_IRON_UNFIRED(29, "chaosironunfired"),
    CHAOS_IRON(30, "chaosiron"),
    NETHER_SHARD(19, "nethershard"),
    NETHER_CLUSTER(20, "nethercluster"),
    ENDER_SLIMEBALL(31, "enderslimeball"),
    SOUL_SHELL(32, "soulshell"),
    CHAOS_COAL(6, "chaoscoal"),
    STONE_ROD(33, "stickstone"),
    IRON_ROD(7, "stickiron"),
    ORNATE_GOLD_ROD(8, "ornatestickgold"),
    ORNATE_SILVER_ROD(9, "ornatesticksilver"),
    ARMOR_LATTICE_MUNDANE(24, "armorlatticemundane"),
    ARMOR_LATTICE_REGULAR(25, "armorlatticeregular"),
    ARMOR_LATTICE_SUPER(26, "armorlatticesuper"),
    GILDED_STRING(21, "gildedstring"),
    BLAZESTONE(27, "blazestone"),
    MYSTERY_GOO(28, "mysterygoo"),
    IRON_POTATO(10, "ironpotato"),
    CHAOS_CORE(14, "chaoscore"),
    FLUFFY_FABRIC(11, "fluffyfabric"),
    PLUME(16, "plume"),
    SHINY_PLUME(17, "shinyplume"),
    YARN_BALL(22, "yarnball"),
    RAWHIDE_BONE(23, "rawhidebone"),
    MAGNIFYING_GLASS(15, "magnifyingglass"),
    NAME_PLATE(13, "nameplate"),
    UPGRADE_BASE(12, "upgradebase"),
    URN_UPGRADE_BASE(34, "urn_upgrade_base");

    private final int metadata;
    private final String name;

    private CraftingItems(int metadata, String name) {
        this.metadata = metadata;
        this.name = name;
    }

    public Item getItem() {
        return ItemCrafting.INSTANCE;
    }

    public ItemStack getStack() {
        return this.getStack(1);
    }

    public ItemStack getStack(int count) {
        return new ItemStack(this.getItem(), count, this.getMetadata());
    }

    @Nullable
    public static CraftingItems byMetadata(int meta) {
        for (CraftingItems item : CraftingItems.values()) {
            if (item.getMetadata() != meta) continue;
            return item;
        }
        return null;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public static class ItemCrafting
    extends Item
    implements IAddRecipes,
    ICustomModel {
        public static final ItemCrafting INSTANCE = new ItemCrafting();
        public static final Map<Integer, IRecipe> guideRecipeMap = Maps.newHashMap();
        public static IRecipe recipeLatticeMundane;
        public static IRecipe recipeLatticeRegular;
        public static IRecipe recipeLatticeSuper;

        private ItemCrafting() {
            this.func_77627_a(true);
        }

        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
            if (!this.func_194125_a(tab)) {
                return;
            }
            for (CraftingItems item : CraftingItems.values()) {
                items.add((Object)item.getStack());
            }
        }

        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            String key;
            tooltip.add(TextFormatting.GOLD + SilentGems.i18n.itemSubText("craftingmaterial", "desc", new Object[0]));
            if (KeyTracker.isShiftDown() && SilentGems.i18n.hasKey(key = this.func_77667_c(stack) + ".desc")) {
                tooltip.add(TextFormatting.ITALIC + SilentGems.i18n.translate(key, new Object[0]));
            }
        }

        public void registerModels() {
            for (CraftingItems item : CraftingItems.values()) {
                SilentGems.registry.setModel((Item)this, item.getMetadata(), item.getName());
            }
        }

        public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
            if (stack.func_77969_a(NAME_PLATE.getStack())) {
                if (!stack.func_82837_s()) {
                    return false;
                }
                if (target instanceof EntityLiving) {
                    EntityLiving entityLiving = (EntityLiving)target;
                    if (entityLiving.func_145818_k_() && entityLiving.func_95999_t().equals(stack.func_82833_r())) {
                        return false;
                    }
                    entityLiving.func_96094_a(stack.func_82833_r());
                    entityLiving.func_110163_bv();
                    stack.func_190918_g(1);
                    return true;
                }
            }
            return super.func_111207_a(stack, player, target, hand);
        }

        public int getItemBurnTime(ItemStack fuel) {
            return fuel.func_77973_b() == this && fuel.func_77952_i() == CHAOS_COAL.getMetadata() ? GemsConfig.BURN_TIME_CHAOS_COAL : 0;
        }

        public String func_77667_c(ItemStack stack) {
            CraftingItems item = CraftingItems.byMetadata(stack.func_77952_i());
            return SilentGems.i18n.getKey("item", item != null ? item.getName() : "null");
        }

        public void addOreDict() {
            if (!OreDictionary.doesOreNameExist((String)"paper")) {
                OreDictionary.registerOre((String)"paper", (Item)Items.field_151121_aF);
            }
            if (!OreDictionary.doesOreNameExist((String)"feather")) {
                OreDictionary.registerOre((String)"feather", (Item)Items.field_151008_G);
            }
            OreDictionary.registerOre((String)"gemChaos", (ItemStack)CHAOS_ESSENCE.getStack());
            OreDictionary.registerOre((String)"gemEnderEssence", (ItemStack)ENDER_ESSENCE.getStack());
            OreDictionary.registerOre((String)"nuggetChaos", (ItemStack)CHAOS_ESSENCE_SHARD.getStack());
            OreDictionary.registerOre((String)"nuggetEnderEssence", (ItemStack)ENDER_ESSENCE_SHARD.getStack());
            OreDictionary.registerOre((String)"paper", (ItemStack)FLUFFY_FABRIC.getStack());
            OreDictionary.registerOre((String)"rodGold", (ItemStack)ORNATE_GOLD_ROD.getStack());
            OreDictionary.registerOre((String)"rodIron", (ItemStack)IRON_ROD.getStack());
            OreDictionary.registerOre((String)"rodSilver", (ItemStack)ORNATE_SILVER_ROD.getStack());
            OreDictionary.registerOre((String)"rodStone", (ItemStack)STONE_ROD.getStack());
            OreDictionary.registerOre((String)"slimeball", (ItemStack)ENDER_SLIMEBALL.getStack());
        }

        public void addRecipes(RecipeMaker recipes) {
            ItemStack chaosEssenceEnriched = ENRICHED_CHAOS_ESSENCE.getStack();
            ItemStack chaosEssenceCrystallized = CRYSTALLIZED_CHAOS_ESSENCE.getStack();
            ItemStack enderEssence = ENDER_ESSENCE.getStack();
            ItemStack netherShard = NETHER_SHARD.getStack();
            ItemStack chaosEssenceShard = CHAOS_ESSENCE_SHARD.getStack();
            ItemStack chaosEssence = CHAOS_ESSENCE.getStack();
            ItemStack enderEssenceShard = ENDER_ESSENCE_SHARD.getStack();
            ItemStack toolRodIron = IRON_ROD.getStack();
            ItemStack toolRodGold = ORNATE_GOLD_ROD.getStack();
            ItemStack toolRodSilver = ORNATE_SILVER_ROD.getStack();
            ItemStack upgradeBase = UPGRADE_BASE.getStack();
            ItemStack chaosCoal = CHAOS_COAL.getStack();
            ItemStack namePlate = NAME_PLATE.getStack();
            ItemStack chaosCore = CHAOS_CORE.getStack();
            ItemStack magnifyingGlass = MAGNIFYING_GLASS.getStack();
            ItemStack plume = PLUME.getStack();
            ItemStack shinyPlume = SHINY_PLUME.getStack();
            ItemStack enderFrost = ENDER_FROST.getStack();
            ItemStack yarnBall = YARN_BALL.getStack();
            ItemStack rawhideBone = RAWHIDE_BONE.getStack();
            ItemStack blazestone = BLAZESTONE.getStack();
            ItemStack netherCluster = NETHER_CLUSTER.getStack();
            ItemStack fluffyFabric = FLUFFY_FABRIC.getStack();
            ItemStack chaosIronUnfired = CHAOS_IRON_UNFIRED.getStack();
            ItemStack chaosIron = CHAOS_IRON.getStack();
            ItemStack gildedString = GILDED_STRING.getStack();
            IRecipe recipe = recipes.addSurroundOre("chaos_essence_enriched", chaosEssenceEnriched, (Object)"dustGlowstone", new Object[]{"dustRedstone", "gemChaos"});
            guideRecipeMap.put(chaosEssenceEnriched.func_77952_i(), recipe);
            recipe = recipes.addSurroundOre("chaos_essence_crystallized", chaosEssenceCrystallized, (Object)enderEssence, new Object[]{netherShard, chaosEssenceEnriched});
            guideRecipeMap.put(chaosEssenceCrystallized.func_77952_i(), recipe);
            recipes.addCompression("chaos_essence", chaosEssenceShard, chaosEssence, 9);
            guideRecipeMap.put(chaosEssenceShard.func_77952_i(), recipes.makeShapelessOre(new ItemStack((Item)this, 9, chaosEssenceShard.func_77952_i()), new Object[]{chaosEssence}));
            recipes.addCompression("ender_essence", enderEssenceShard, enderEssence, 9);
            guideRecipeMap.put(enderEssenceShard.func_77952_i(), recipes.makeShapeless(new ItemStack((Item)this, 9, enderEssenceShard.func_77952_i()), new ItemStack[]{enderEssence}));
            recipe = recipes.addShapedOre("iron_rod", IRON_ROD.getStack(8), new Object[]{"igi", "igi", "igi", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE)});
            guideRecipeMap.put(toolRodIron.func_77952_i(), recipe);
            recipe = recipes.addShapedOre("ornate_rod_gold", ORNATE_GOLD_ROD.getStack(8), new Object[]{"ifi", "ici", "ifi", Character.valueOf('i'), "ingotGold", Character.valueOf('f'), "ingotIron", Character.valueOf('c'), "gemChaos"});
            guideRecipeMap.put(toolRodGold.func_77952_i(), recipe);
            if (OreDictionary.doesOreNameExist((String)"ingotSilver")) {
                recipe = recipes.addShapedOre("ornate_rod_silver", ORNATE_SILVER_ROD.getStack(8), new Object[]{"ifi", "ici", "ifi", Character.valueOf('i'), "ingotSilver", Character.valueOf('f'), "ingotIron", Character.valueOf('c'), "gemChaos"});
                guideRecipeMap.put(toolRodSilver.func_77952_i(), recipe);
            }
            recipe = recipes.addShapelessOre("upgrade_base", UPGRADE_BASE.getStack(4), new Object[]{Items.field_151145_ak, Items.field_151145_ak, "plankWood", "stickWood"});
            guideRecipeMap.put(upgradeBase.func_77952_i(), recipe);
            recipe = recipes.addSurroundOre("chaos_coal_0", CHAOS_COAL.getStack(8), (Object)"gemChaos", new Object[]{new ItemStack(Items.field_151044_h)});
            recipes.addSurroundOre("chaos_coal_1", CHAOS_COAL.getStack(4), (Object)"gemChaos", new Object[]{new ItemStack(Items.field_151044_h, 1, 1)});
            guideRecipeMap.put(chaosCoal.func_77952_i(), recipe);
            recipes.addShapedOre("torches_chaos_coal", new ItemStack(Blocks.field_150478_aa, 16), new Object[]{"c", "s", Character.valueOf('c'), chaosCoal, Character.valueOf('s'), "stickWood"});
            recipe = recipes.addShapedOre("name_plate", NAME_PLATE.getStack(4), new Object[]{"iii", "pcp", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), "paper", Character.valueOf('c'), "gemChaos"});
            guideRecipeMap.put(namePlate.func_77952_i(), recipe);
            recipe = recipes.addShapedOre("chaos_core", chaosCore, new Object[]{" c ", "cqc", " c ", Character.valueOf('c'), chaosEssenceEnriched, Character.valueOf('q'), "blockQuartz"});
            guideRecipeMap.put(chaosCore.func_77952_i(), recipe);
            recipe = recipes.addShapedOre("magnifying_glass", magnifyingGlass, new Object[]{" g ", "gpg", "rg ", Character.valueOf('g'), "ingotGold", Character.valueOf('p'), "paneGlass", Character.valueOf('r'), toolRodGold});
            guideRecipeMap.put(magnifyingGlass.func_77952_i(), recipe);
            recipe = recipes.addSurroundOre("plume", plume, (Object)new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE), new Object[]{"feather"});
            guideRecipeMap.put(plume.func_77952_i(), recipe);
            recipe = recipes.addSurroundOre("shiny_plume", shinyPlume, (Object)plume, new Object[]{"gemChaos", "ingotGold"});
            guideRecipeMap.put(shinyPlume.func_77952_i(), recipe);
            recipe = recipes.addSurround("ender_frost", enderFrost, enderEssence, new Object[]{Blocks.field_150432_aD});
            guideRecipeMap.put(enderFrost.func_77952_i(), recipe);
            recipe = recipes.addShapedOre("gilded_string", new ItemStack((Item)this, 3, gildedString.func_77952_i()), new Object[]{"gsg", "gsg", "gsg", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('g'), "nuggetGold"});
            guideRecipeMap.put(gildedString.func_77952_i(), recipe);
            recipe = recipes.addSurround("yarn_ball", yarnBall, new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE), new Object[]{Items.field_151007_F});
            guideRecipeMap.put(yarnBall.func_77952_i(), recipe);
            recipe = recipes.addShapedOre("rawhide_bone", rawhideBone, new Object[]{" l ", "lbl", " l ", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('b'), Items.field_151103_aS});
            guideRecipeMap.put(rawhideBone.func_77952_i(), recipe);
            recipe = recipes.addSurroundOre("blazestone", blazestone, (Object)"dustRedstone", new Object[]{Items.field_151065_br});
            guideRecipeMap.put(blazestone.func_77952_i(), recipe);
            ItemStack netherStar = new ItemStack(Items.field_151156_bN);
            recipe = recipes.addSurroundOre("nether_shard", NETHER_SHARD.getStack(24), (Object)netherStar, new Object[]{chaosEssenceEnriched, enderEssence});
            guideRecipeMap.put(netherShard.func_77952_i(), recipe);
            recipe = recipes.addShaped("nether_cluster", netherCluster, new Object[]{"sss", "s s", "sss", Character.valueOf('s'), netherShard});
            guideRecipeMap.put(netherCluster.func_77952_i(), recipe);
            recipes.addShapeless("nether_star", netherStar, new ItemStack[]{netherCluster, netherCluster, netherCluster});
            recipeLatticeMundane = recipes.addSurroundOre("armor_lattice_mundane", ARMOR_LATTICE_MUNDANE.getStack(24), (Object)"stickWood", new Object[]{"string", Items.field_151145_ak});
            guideRecipeMap.put(ARMOR_LATTICE_MUNDANE.getMetadata(), recipeLatticeMundane);
            recipeLatticeRegular = recipes.addSurroundOre("armor_lattice_regular", ARMOR_LATTICE_REGULAR.getStack(24), (Object)fluffyFabric, new Object[]{"ingotIron", new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE)});
            guideRecipeMap.put(ARMOR_LATTICE_REGULAR.getMetadata(), recipeLatticeRegular);
            recipeLatticeSuper = recipes.addSurroundOre("armor_lattice_super", ARMOR_LATTICE_SUPER.getStack(24), (Object)"gemLapis", new Object[]{"gemDiamond", chaosEssenceEnriched});
            guideRecipeMap.put(ARMOR_LATTICE_SUPER.getMetadata(), recipeLatticeSuper);
            recipe = recipes.addShapedOre("chaos_iron_unfired", chaosIronUnfired, new Object[]{"c", "i", "c", Character.valueOf('c'), "gemChaos", Character.valueOf('i'), "ingotIron"});
            guideRecipeMap.put(chaosIronUnfired.func_77952_i(), recipe);
            recipes.addSmelting(chaosIronUnfired, chaosIron, 0.4f);
            recipe = recipes.addShapedOre("soul_shell", SOUL_SHELL.getStack(2), new Object[]{" g ", "gdg", " g ", Character.valueOf('g'), "blockGlass", Character.valueOf('d'), "gemDiamond"});
            guideRecipeMap.put(SOUL_SHELL.getMetadata(), recipe);
            recipe = recipes.addShapedOre("stone_rod", STONE_ROD.getStack(4), new Object[]{"s", "s", Character.valueOf('s'), "cobblestone"});
            guideRecipeMap.put(STONE_ROD.getMetadata(), recipe);
            recipe = recipes.addShaped("urn_upgrade_base", URN_UPGRADE_BASE.getStack(6), new Object[]{"cic", "csc", "cic", Character.valueOf('c'), new ItemStack(Blocks.field_150405_ch), Character.valueOf('i'), CHAOS_IRON.getStack(), Character.valueOf('s'), new ItemStack((Item)ModItems.soulGem)});
        }
    }
}

