/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.util.NBTHelper;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.lib.util.DyeHelper;

public class ItemDrawingCompass
extends Item
implements IAddRecipes {
    public ItemDrawingCompass() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("state"), (stack, worldIn, entityIn) -> this.getState(stack).ordinal());
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.ITALIC + SilentGems.i18n.subText((IForgeRegistryEntry)this, "desc", new Object[0]));
    }

    public void addRecipes(RecipeMaker recipes) {
        ItemStack base = new ItemStack((Item)this);
        recipes.addShaped("drawing_compass", base, new Object[]{" c ", "r r", Character.valueOf('c'), CraftingItems.ENRICHED_CHAOS_ESSENCE.getStack(), Character.valueOf('r'), CraftingItems.ORNATE_GOLD_ROD.getStack()});
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            ItemStack result = new ItemStack((Item)this);
            NBTHelper.setTagInt(result, "Color", DyeHelper.getColor((EnumDyeColor)dye));
            String dyeName = DyeHelper.getOreName((EnumDyeColor)dye);
            recipes.addShapelessOre("drawing_compass_" + dye.name(), result, new Object[]{base, dyeName});
        }
    }

    public State getState(ItemStack stack) {
        if (this.getBlock2(stack).func_177956_o() > 0) {
            return State.BLOCK2;
        }
        if (this.getBlock1(stack).func_177956_o() > 0) {
            return State.BLOCK1;
        }
        return State.EMPTY;
    }

    @Deprecated
    public ItemStack setState(ItemStack stack, State state) {
        stack.func_77964_b(state.ordinal());
        return stack;
    }

    public BlockPos getBlock1(ItemStack stack) {
        return this.getBlock(stack, 1);
    }

    public BlockPos getBlock2(ItemStack stack) {
        return this.getBlock(stack, 2);
    }

    protected BlockPos getBlock(ItemStack stack, int index) {
        int x = NBTHelper.getTagInt(stack, "X" + index);
        int y = NBTHelper.getTagInt(stack, "Y" + index);
        int z = NBTHelper.getTagInt(stack, "Z" + index);
        return new BlockPos(x, y, z);
    }

    public void setBlock1(ItemStack stack, BlockPos pos) {
        this.setBlock(stack, pos, 1);
    }

    public void setBlock2(ItemStack stack, BlockPos pos) {
        this.setBlock(stack, pos, 2);
    }

    protected void setBlock(ItemStack stack, BlockPos pos, int index) {
        NBTHelper.setTagInt(stack, "X" + index, pos.func_177958_n());
        NBTHelper.setTagInt(stack, "Y" + index, pos.func_177956_o());
        NBTHelper.setTagInt(stack, "Z" + index, pos.func_177952_p());
    }

    public void clearBlocks(ItemStack stack) {
        if (stack.func_77942_o()) {
            this.setBlock1(stack, BlockPos.field_177992_a);
            this.setBlock2(stack, BlockPos.field_177992_a);
        }
    }

    public Color getColor(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Color")) {
            return Color.WHITE;
        }
        return new Color(NBTHelper.getTagInt(stack, "Color"));
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.PASS;
        }
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        State state = this.getState(stack);
        if (state == State.BLOCK1) {
            this.setBlock2(stack, pos.func_177972_a(facing));
            int radius = (int)Math.sqrt(this.getBlock1(stack).func_177951_i((Vec3i)this.getBlock2(stack)));
            String str = SilentGems.i18n.subText((IForgeRegistryEntry)this, "radius", new Object[]{radius});
            ChatHelper.sendMessage((EntityPlayer)playerIn, (String)str);
        } else if (state == State.EMPTY) {
            this.setBlock1(stack, pos.func_177972_a(facing));
        } else {
            String str = SilentGems.i18n.subText((IForgeRegistryEntry)this, "howToReset", new Object[0]);
            ChatHelper.sendMessage((EntityPlayer)playerIn, (String)str);
        }
        stack.func_77964_b(0);
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && playerIn.func_70093_af() && !worldIn.field_72995_K) {
            this.clearBlocks(stack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean spawnParticles(ItemStack stack, EntityPlayer player, World world) {
        Vec3d vec;
        float start;
        BlockPos pos1 = this.getBlock1(stack);
        BlockPos pos2 = this.getBlock2(stack);
        if (pos1.func_177956_o() <= 0 || pos2.func_177956_o() <= 0 || pos1.equals((Object)pos2)) {
            return false;
        }
        Color color = this.getColor(stack);
        BlockPos center = new BlockPos(pos1.func_177958_n(), pos2.func_177956_o(), pos1.func_177952_p());
        float radius = (float)Math.sqrt(center.func_177951_i((Vec3i)pos2));
        int count = (int)(5.0f * radius);
        float increment = (float)(Math.PI * 2 / (double)count);
        float angle = start = increment * (float)(world.func_82737_E() % 30L) / 30.0f;
        while ((double)angle < Math.PI * 2 + (double)start) {
            vec = new Vec3d((double)radius, 0.0, 0.0).func_178785_b(angle);
            this.particle(player, world, color, (double)center.func_177958_n() + 0.5 + vec.field_72450_a, (double)center.func_177956_o() + 0.5 + vec.field_72448_b, (double)center.func_177952_p() + 0.5 + vec.field_72449_c);
            angle += increment;
        }
        double distance = Math.sqrt(pos1.func_177951_i((Vec3i)pos2));
        count = (int)(2.0 * distance);
        double dx = (double)(pos2.func_177958_n() - pos1.func_177958_n()) / (double)count;
        double dy = (double)(pos2.func_177956_o() - pos1.func_177956_o()) / (double)count;
        double dz = (double)(pos2.func_177952_p() - pos1.func_177952_p()) / (double)count;
        for (int i = 0; i < count; ++i) {
            vec = new Vec3d((double)pos1.func_177958_n() + 0.5 + (double)i * dx, (double)pos1.func_177956_o() + 0.5 + (double)i * dy, (double)pos1.func_177952_p() + 0.5 + (double)i * dz);
            this.particle(player, world, color, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
        return true;
    }

    private void particle(EntityPlayer player, World world, Color color, double x, double y, double z) {
        if (player.func_70092_e(x, y, z) < 2048.0) {
            SilentGems.proxy.spawnParticles(EnumModParticles.DRAWING_COMPASS, color, world, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static enum State {
        EMPTY,
        BLOCK1,
        BLOCK2;

    }
}

