/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.handler.ClientTickHandler;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.recipe.RecipeJsonHell;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.RecipeMaker;

public class ItemEnchantmentToken
extends Item
implements IAddRecipes,
ICustomModel {
    private static final String NBT_ENCHANTMENTS = "TokenEnchantments";
    private static final Map<Enchantment, String> RECIPE_MAP = new HashMap<Enchantment, String>();
    private static final Map<Enchantment, Integer> OUTLINE_COLOR_MAP = new HashMap<Enchantment, Integer>();
    private static final Map<String, Icon> MODELS_BY_TYPE = new HashMap<String, Icon>();
    private boolean modRecipesInitialized = false;
    public static final int BLANK_META = 256;
    private static final float OUTLINE_PULSATE_SPEED = 0.10610329f;

    public ItemEnchantmentToken() {
        this.func_185043_a(new ResourceLocation("model_index"), ItemEnchantmentToken::getModel);
    }

    @Nullable
    private static ResourceLocation tryGetId(String id) {
        try {
            return new ResourceLocation(id);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public ItemStack constructToken(Enchantment enchantment) {
        return this.constructToken(enchantment, 1);
    }

    public ItemStack constructToken(Enchantment enchantment, int level) {
        ItemStack stack = new ItemStack((Item)this);
        ItemEnchantmentToken.addEnchantment(stack, new EnchantmentData(enchantment, level));
        return stack;
    }

    public ItemStack constructToken(Map<Enchantment, Integer> enchantmentMap) {
        ItemStack result = new ItemStack((Item)this);
        ItemEnchantmentToken.setEnchantments(result, enchantmentMap);
        return result;
    }

    public static void addEnchantment(ItemStack stack, EnchantmentData data) {
        NBTTagList tagList = ItemEnchantmentToken.getEnchantments(stack);
        boolean needToAddEnchantment = true;
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)data.field_76302_b);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tags = tagList.func_150305_b(i);
            ResourceLocation existingId = ItemEnchantmentToken.tryGetId(tags.func_74779_i("id"));
            if (existingId == null || !existingId.equals((Object)id)) continue;
            if (tags.func_74762_e("lvl") < data.field_76303_c) {
                tags.func_74777_a("lvl", (short)data.field_76303_c);
            }
            needToAddEnchantment = false;
            break;
        }
        if (needToAddEnchantment) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("id", String.valueOf(id));
            tags.func_74777_a("lvl", (short)data.field_76303_c);
            tagList.func_74742_a((NBTBase)tags);
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a(NBT_ENCHANTMENTS, (NBTBase)tagList);
    }

    public static void setEnchantments(ItemStack token, Map<Enchantment, Integer> map) {
        if (token.func_190926_b()) {
            return;
        }
        if (token.func_77978_p() == null) {
            token.func_77982_d(new NBTTagCompound());
        }
        if (token.func_77978_p().func_74764_b(NBT_ENCHANTMENTS)) {
            token.func_77978_p().func_82580_o(NBT_ENCHANTMENTS);
        }
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            ResourceLocation registryName = entry.getKey().getRegistryName();
            String name = Objects.requireNonNull(registryName).toString();
            int level = entry.getValue();
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("name", name);
            compound.func_74777_a("lvl", (short)level);
            tagList.func_74742_a((NBTBase)compound);
        }
        token.func_77978_p().func_74782_a(NBT_ENCHANTMENTS, (NBTBase)tagList);
    }

    public static NBTTagList getEnchantments(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        return tags != null ? tags.func_150295_c(NBT_ENCHANTMENTS, 10) : new NBTTagList();
    }

    private static Map<Enchantment, Integer> getEnchantmentMap(ItemStack stack) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        NBTTagList tagList = ItemEnchantmentToken.getEnchantments(stack);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            Enchantment enchantment;
            NBTTagCompound tag = tagList.func_150305_b(i);
            ResourceLocation id = ItemEnchantmentToken.tryGetId(tag.func_74779_i("id"));
            if (id == null || (enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id)) == null) continue;
            map.put(enchantment, tag.func_74762_e("lvl"));
        }
        return map;
    }

    public static boolean applyTokenToTool(ItemStack token, ItemStack tool) {
        if (token.func_190926_b() || tool.func_190926_b()) {
            return false;
        }
        Map<Enchantment, Integer> enchantmentsOnToken = ItemEnchantmentToken.getEnchantmentMap(token);
        if (enchantmentsOnToken.isEmpty()) {
            return false;
        }
        Map enchantmentsOnTool = EnchantmentHelper.func_82781_a((ItemStack)tool);
        for (Map.Entry<Enchantment, Integer> entry : enchantmentsOnToken.entrySet()) {
            Enchantment ench = entry.getKey();
            if (!ench.func_92089_a(tool)) {
                return false;
            }
            for (Enchantment enchTool : enchantmentsOnTool.keySet()) {
                if (ench.equals(enchTool) || ench.func_191560_c(enchTool)) continue;
                return false;
            }
        }
        if (!ItemEnchantmentToken.mergeEnchantmentLists(enchantmentsOnToken, enchantmentsOnTool)) {
            return false;
        }
        EnchantmentHelper.func_82782_a(enchantmentsOnToken, (ItemStack)tool);
        return true;
    }

    public static boolean mergeEnchantmentLists(Map<Enchantment, Integer> ench1, Map<Enchantment, Integer> ench2) {
        for (Enchantment enchantment : ench2.keySet()) {
            int newLevel;
            int level = newLevel = ench2.get(enchantment).intValue();
            if (ench1.containsKey(enchantment) && (newLevel = ench1.get(enchantment) + level) > enchantment.func_77325_b()) {
                return false;
            }
            ench1.put(enchantment, newLevel);
        }
        return true;
    }

    private static float getModel(ItemStack stack, World world, EntityLivingBase entity) {
        return ItemEnchantmentToken.getModelIcon(stack).ordinal();
    }

    private static Icon getModelIcon(ItemStack stack) {
        Map<Enchantment, Integer> map = ItemEnchantmentToken.getEnchantmentMap(stack);
        if (map.isEmpty()) {
            return Icon.EMPTY;
        }
        EnumEnchantmentType type = map.keySet().iterator().next().field_77351_y;
        if (type == null) {
            return Icon.UNKNOWN;
        }
        return MODELS_BY_TYPE.getOrDefault(type.toString(), Icon.UNKNOWN);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        Map<Enchantment, Integer> enchants = ItemEnchantmentToken.getEnchantmentMap(stack);
        if (enchants.size() == 1) {
            Enchantment ench = enchants.keySet().iterator().next();
            list.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "maxLevel", new Object[]{ench.func_77325_b()}));
            if (KeyTracker.isControlDown()) {
                list.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "materials", new Object[0]));
                String recipeString = RECIPE_MAP.get(ench);
                if (recipeString != null && !recipeString.isEmpty()) {
                    for (String str : recipeString.split(";")) {
                        list.add("  " + str);
                    }
                }
            } else {
                list.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "pressCtrl", new Object[0]));
            }
            if (KeyTracker.isAltDown()) {
                ResourceLocation registryName = ench.getRegistryName();
                list.add(TextFormatting.DARK_GRAY + Objects.requireNonNull(registryName).toString());
            }
        }
        for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
            Enchantment e = entry.getKey();
            String enchName = e.func_77316_c(entry.getValue().intValue());
            ResourceLocation registryName = Objects.requireNonNull(e.getRegistryName());
            String modName = ((ModContainer)Loader.instance().getIndexedModList().get(registryName.func_110624_b())).getName();
            list.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "enchNameWithMod", new Object[]{enchName, modName}));
            String descKey = e.func_77320_a().replaceAll(":", ".").toLowerCase(Locale.ROOT) + ".desc";
            String desc = SilentGems.i18n.translate(descKey, new Object[0]);
            if (desc.equals(descKey)) continue;
            list.add(TextFormatting.ITALIC + "  " + desc);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ArrayList<ItemStack> tokens = new ArrayList<ItemStack>();
        ForgeRegistries.ENCHANTMENTS.forEach(enchantment -> tokens.add(this.constructToken((Enchantment)enchantment)));
        tokens.sort(this::compareEnchantmentNames);
        tokens.add(0, new ItemStack((Item)this, 1, 256));
        list.addAll(tokens);
    }

    private int compareEnchantmentNames(ItemStack o1, ItemStack o2) {
        int k = -ItemEnchantmentToken.getModelIcon(o1).compareTo(ItemEnchantmentToken.getModelIcon(o2));
        if (k == 0) {
            Enchantment ench1 = this.getSingleEnchantment(o1);
            Enchantment ench2 = this.getSingleEnchantment(o2);
            if (ench1 != null && ench2 != null) {
                k = ench1.func_77316_c(1).compareTo(ench2.func_77316_c(1));
            }
        }
        return k;
    }

    @Nullable
    public Enchantment getSingleEnchantment(ItemStack token) {
        Map<Enchantment, Integer> map = ItemEnchantmentToken.getEnchantmentMap(token);
        if (map.size() != 1) {
            return null;
        }
        return map.keySet().iterator().next();
    }

    public String func_77667_c(ItemStack stack) {
        boolean hasEnchants = stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(NBT_ENCHANTMENTS);
        return super.func_77667_c(stack) + (hasEnchants ? "" : "_blank");
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public int getOutlineColor(ItemStack stack) {
        Enchantment ench = this.getSingleEnchantment(stack);
        if (ench != null && OUTLINE_COLOR_MAP.containsKey(ench)) {
            int k = OUTLINE_COLOR_MAP.get(ench);
            int r = k >> 16 & 0xFF;
            int g = k >> 8 & 0xFF;
            int b = k & 0xFF;
            int j = (int)(160.0f * MathHelper.func_76126_a((float)((float)ClientTickHandler.ticksInGame * 0.10610329f)));
            j = MathHelper.func_76125_a((int)j, (int)0, (int)255);
            r = MathHelper.func_76125_a((int)(r + j), (int)0, (int)255);
            g = MathHelper.func_76125_a((int)(g + j), (int)0, (int)255);
            b = MathHelper.func_76125_a((int)(b + j), (int)0, (int)255);
            return r << 16 | g << 8 | b;
        }
        return 0xFFFFFF;
    }

    public void setColorsForDefaultTokens() {
    }

    public void addRecipes(RecipeMaker recipes) {
        SilentGems.registry.getRecipeMaker().setRecipeSerializer((Item)this, (result, components) -> {
            JsonObject json = RecipeJsonHell.ShapedSerializer.INSTANCE.serialize(result, components);
            json.remove("type");
            json.addProperty("type", "silentgems:enchantment_token");
            Enchantment enchantment = this.getSingleEnchantment(result);
            if (enchantment != null) {
                ResourceLocation name = Objects.requireNonNull(enchantment.getRegistryName());
                json.getAsJsonObject("result").addProperty("enchantment", name.toString());
            }
            return json;
        });
    }

    @Deprecated
    public void addModRecipes() {
        if (this.modRecipesInitialized) {
            return;
        }
        this.modRecipesInitialized = true;
        if (Loader.isModLoaded((String)"endercore")) {
            SilentGems.logHelper.info("Adding enchantment token recipes for Ender Core:", new Object[0]);
            this.addModTokenRecipe("endercore:xpboost", EnumGem.MOLDAVITE, Blocks.field_150340_R, 1);
            this.addModTokenRecipe("endercore:autosmelt", EnumGem.GARNET, new ItemStack((Block)ModBlocks.miscBlock, 1, 3), 4);
        }
        if (Loader.isModLoaded((String)"enderio")) {
            SilentGems.logHelper.info("Adding enchantment token recipes for Ender IO:", new Object[0]);
            this.addModTokenRecipe("enderio:soulBound", EnumGem.OPAL, "itemEnderCrystal", 1);
        }
        if (Loader.isModLoaded((String)"enderzoo")) {
            SilentGems.logHelper.info("Adding enchantment token recipes for Ender Zoo:", new Object[0]);
            Item witherDust = Item.func_111206_d((String)"enderzoo:witheringDust");
            if (witherDust != null) {
                this.addModTokenRecipe("enderzoo:witherWeapon", EnumGem.ONYX, witherDust, 5);
                this.addModTokenRecipe("enderzoo:witherArrow", EnumGem.BLACK_DIAMOND, witherDust, 5);
            }
        }
    }

    @Deprecated
    public void addTokenRecipe(Enchantment ench, EnumGem gem, Object other, int otherCount) {
        String line2;
        if (ench == Enchantments.field_185301_j && GemsConfig.RECIPE_TOKEN_FROST_WALKER_DISABLE || ench == Enchantments.field_185296_A && GemsConfig.RECIPE_TOKEN_MENDING_DISABLE) {
            return;
        }
        if (!OUTLINE_COLOR_MAP.containsKey(ench)) {
            OUTLINE_COLOR_MAP.put(ench, gem.getColor());
        }
        String line1 = "g g";
        String string = line2 = otherCount > 3 ? "oto" : " t ";
        String line3 = otherCount == 3 || otherCount > 4 ? "ooo" : (otherCount == 2 || otherCount == 4 ? "o o" : " o ");
        ItemStack token = this.constructToken(ench);
        String recipeName = "enchantment_token_" + ench.func_77320_a().replaceAll(":", "_");
        SilentGems.registry.getRecipeMaker().addShapedOre(recipeName, token, new Object[]{line1, line2, line3, Character.valueOf('g'), gem.getItemOreName(), Character.valueOf('o'), other, Character.valueOf('t'), new ItemStack((Item)this, 1, 256)});
        String recipeString = "2 " + gem.getItemOreName() + ";" + otherCount + " ";
        if (other instanceof String) {
            recipeString = recipeString + (String)other;
        } else if (other instanceof ItemStack) {
            recipeString = recipeString + ((ItemStack)other).func_82833_r();
        } else if (other instanceof Block) {
            recipeString = recipeString + new ItemStack((Block)other).func_82833_r();
        } else if (other instanceof Item) {
            recipeString = recipeString + new ItemStack((Item)other).func_82833_r();
        }
        RECIPE_MAP.put(ench, recipeString);
    }

    @Deprecated
    public void addModTokenRecipe(String enchantmentName, EnumGem gem, Object other, int otherCount) {
        SilentGems.logHelper.info("    Attempting to add token recipe for {}...", new Object[]{enchantmentName});
        Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(enchantmentName));
        if (enchantment == null) {
            SilentGems.logHelper.warn("    Failed to add! Enchantment is null?", new Object[0]);
            return;
        }
        this.addTokenRecipe(enchantment, gem, other, otherCount);
    }

    public void registerModels() {
        SilentGems.registry.setModel((Item)this, 0, "enchantmenttoken");
        int i = 1;
        for (Icon type : Icon.values()) {
            SilentGems.registry.setModel((Item)this, i++, "enchantmenttoken_" + type.getName());
        }
        SilentGems.registry.setModel((Item)this, 256, "enchantmenttoken");
    }

    static {
        MODELS_BY_TYPE.put(EnumEnchantmentType.ALL.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnumEnchantmentType.BREAKABLE.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnumEnchantmentType.ARMOR.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnumEnchantmentType.ARMOR_CHEST.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnumEnchantmentType.ARMOR_FEET.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnumEnchantmentType.ARMOR_HEAD.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnumEnchantmentType.ARMOR_LEGS.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnumEnchantmentType.WEARABLE.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnumEnchantmentType.BOW.toString(), Icon.BOW);
        MODELS_BY_TYPE.put(EnumEnchantmentType.DIGGER.toString(), Icon.TOOL);
        MODELS_BY_TYPE.put(EnumEnchantmentType.FISHING_ROD.toString(), Icon.FISHING_ROD);
        MODELS_BY_TYPE.put(EnumEnchantmentType.WEAPON.toString(), Icon.SWORD);
    }

    public static enum Icon {
        ANY,
        ARMOR,
        BOW,
        EMPTY,
        FISHING_ROD,
        SWORD,
        TOOL,
        UNKNOWN;


        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

