/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.entity.EntityGemArrow;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.util.ToolHelper;

public class ItemGemArrow
extends ItemArrow {
    public static final String NBT_STATS = "SGArrowStats";
    public static final String NBT_DAMAGE = "Damage";
    public static final String NBT_COLOR_HEAD = "ColorHead";
    public static final String NBT_COLOR_SHAFT = "ColorShaft";
    public static final String NBT_COLOR_FLETCHING = "ColorFletching";

    public ItemStack construct(ItemStack ... stacks) {
        ItemStack result = new ItemStack((Item)this);
        result.func_77982_d(new NBTTagCompound());
        NBTTagCompound nbtStats = new NBTTagCompound();
        LinkedHashMap<ToolPart, EnumMaterialGrade> partMap = new LinkedHashMap<ToolPart, EnumMaterialGrade>();
        for (ItemStack stack : stacks) {
            ToolPart part = ToolPartRegistry.fromStack(stack);
            EnumMaterialGrade grade = EnumMaterialGrade.fromStack(stack);
            partMap.put(part, grade);
            if (part instanceof ToolPartMain) {
                nbtStats.func_74768_a(NBT_COLOR_HEAD, part.getColor(result, ToolPartPosition.ROD_DECO, 0));
                continue;
            }
            if (!(part instanceof ToolPartRod)) continue;
            nbtStats.func_74768_a(NBT_COLOR_SHAFT, part.getColor(result, ToolPartPosition.ROD_DECO, 0));
        }
        nbtStats.func_74768_a(NBT_COLOR_FLETCHING, 0xFFFFFF);
        ToolStats stats = new ToolStats(result, partMap);
        stats.calculate();
        nbtStats.func_74776_a(NBT_DAMAGE, stats.meleeDamage);
        result.func_77978_p().func_74782_a(NBT_STATS, (NBTBase)nbtStats);
        result.func_190920_e(MathHelper.func_76125_a((int)((int)Math.floor(stats.durability / 48.0f)), (int)4, (int)64));
        result.func_151001_c(ToolHelper.createToolName((Item)this, stacks));
        return result;
    }

    public EntityArrow func_185052_a(World worldIn, ItemStack stack, EntityLivingBase shooter) {
        EntityGemArrow entity = new EntityGemArrow(worldIn, shooter, stack);
        entity.func_70239_b(this.getBaseDamage(stack));
        return entity;
    }

    public double getBaseDamage(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_STATS)) {
            return 2.0;
        }
        float damage = stack.func_77978_p().func_74775_l(NBT_STATS).func_74760_g(NBT_DAMAGE);
        return 2.0 + ((double)damage - 1.5) / 2.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(String.format("Damage: %.1f", this.getBaseDamage(stack)));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack rodWood = new ItemStack(Items.field_151055_y);
        ItemStack rodGold = CraftingItems.ORNATE_GOLD_ROD.getStack();
        for (ToolPartMain part : ToolPartRegistry.getMains()) {
            ItemStack rod;
            ItemStack main = part.getCraftingStack();
            if (main.func_190926_b() || part.isBlacklisted(main)) continue;
            ItemStack itemStack = rod = part.getTier() == EnumMaterialTier.SUPER ? rodGold : rodWood;
            ItemStack arrow = this.construct(main, rod);
            if (arrow.func_190926_b()) continue;
            arrow.func_190920_e(1);
            list.add((Object)arrow);
        }
    }
}

