/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.ChatHelper;

public class ItemSkillOrb
extends Item {
    private static final String NBT_ID = "SG_Skill_ID";

    public ItemStack getStack(SoulSkill skill) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a(NBT_ID, skill.id);
        stack.func_77982_d(tags);
        return stack;
    }

    @Nullable
    private SoulSkill getSkill(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return null;
        }
        return SoulSkill.getById(stack.func_77978_p().func_74779_i(NBT_ID));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        SoulSkill.getSkillList().forEach(skill -> list.add((Object)this.getStack((SoulSkill)skill)));
    }

    public String func_77653_i(ItemStack stack) {
        SoulSkill skill = this.getSkill(stack);
        if (skill == null) {
            return this.func_77667_c(stack);
        }
        return SilentGems.i18n.subText((IForgeRegistryEntry)this, "name_proper", new Object[]{skill.getLocalizedName(ItemStack.field_190927_a, 0)});
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack offhand = player.func_184592_cb();
        if (hand != EnumHand.MAIN_HAND || offhand.func_190926_b() || !(offhand.func_77973_b() instanceof ITool) && !(offhand.func_77973_b() instanceof IArmor)) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        ItemStack orb = player.func_184614_ca();
        ToolSoul soul = SoulManager.getSoul(offhand);
        if (soul == null) {
            if (!world.field_72995_K) {
                ChatHelper.translate((EntityPlayer)player, (String)SilentGems.i18n.getKey((IForgeRegistryEntry)this, "no_soul"));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)orb);
        }
        SoulSkill skill = this.getSkill(orb);
        if (skill == null) {
            if (!world.field_72995_K) {
                ChatHelper.translate((EntityPlayer)player, (String)SilentGems.i18n.subText((IForgeRegistryEntry)this, "no_skill", new Object[0]));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)orb);
        }
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (soul.addOrLevelSkill(skill, offhand, player)) {
            ToolHelper.recalculateStats(offhand);
            orb.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)orb);
        }
        ChatHelper.translate((EntityPlayer)player, (String)SilentGems.i18n.getKey((IForgeRegistryEntry)this, "max_level"));
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }
}

