/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.entity.EntityEnderSlime;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.soul.EnumSoulElement;

public class ItemSoulGem
extends Item {
    private static final String NBT_SOUL = "sg_soul_gem";
    private List<Soul> listSorted = new ArrayList<Soul>();
    private Map<Class, Soul> classToSoul = new HashMap<Class, Soul>();
    private Map<String, Soul> idToSoul = new HashMap<String, Soul>();

    public ItemSoulGem() {
        this.func_77627_a(true);
        float blockDropRate = 0.025f;
        this.registerStackSoul(new Soul("Wheat", new ItemStack(Items.field_151015_O), 14015045, 4213264, EnumSoulElement.FLORA, EnumSoulElement.LIGHTNING).setDropRate(blockDropRate));
        this.registerStackSoul(new Soul("Potato", new ItemStack(Items.field_151174_bG), 15317602, 9398320, EnumSoulElement.FLORA, EnumSoulElement.EARTH).setDropRate(blockDropRate));
        this.registerStackSoul(new Soul("Carrot", new ItemStack(Items.field_151172_bF), 16748827, 2918954, EnumSoulElement.FLORA, EnumSoulElement.FIRE).setDropRate(blockDropRate));
        this.registerStackSoul(new Soul("Beetroot", new ItemStack(Items.field_185164_cV), 8464673, 10964308, EnumSoulElement.FLORA, EnumSoulElement.WATER).setDropRate(blockDropRate));
        this.registerStackSoul(new Soul("FluffyPuff", new ItemStack((Item)ModItems.fluffyPuff), 0xFFFFFF, 0x999999, EnumSoulElement.FLORA, EnumSoulElement.WIND).setDropRate(blockDropRate));
        float rateHigh = 0.075f;
        this.registerEntitySoul(EntityZombie.class, new Soul("Zombie", EnumSoulElement.MONSTER, EnumSoulElement.VENOM));
        this.registerEntitySoul(EntitySkeleton.class, new Soul("Skeleton", EnumSoulElement.MONSTER, EnumSoulElement.LIGHTNING));
        this.registerEntitySoul(EntityCreeper.class, new Soul("Creeper", EnumSoulElement.FIRE, EnumSoulElement.FLORA));
        this.registerEntitySoul(EntitySpider.class, new Soul("Spider", EnumSoulElement.WIND, EnumSoulElement.FAUNA));
        this.registerEntitySoul(EntityCaveSpider.class, new Soul("CaveSpider", "cave_spider", EnumSoulElement.VENOM, EnumSoulElement.FAUNA));
        this.registerEntitySoul(EntitySilverfish.class, new Soul("Silverfish", EnumSoulElement.EARTH, EnumSoulElement.FAUNA));
        this.registerEntitySoul(EntitySlime.class, new Soul("Slime", EnumSoulElement.WATER, EnumSoulElement.EARTH));
        this.registerEntitySoul(EntityWitch.class, new Soul("Witch", EnumSoulElement.VENOM, EnumSoulElement.ICE));
        this.registerEntitySoul(EntityGuardian.class, new Soul("Guardian", EnumSoulElement.WATER, EnumSoulElement.LIGHTNING));
        this.registerEntitySoul(EntityHusk.class, new Soul("Husk", EnumSoulElement.MONSTER, EnumSoulElement.EARTH));
        this.registerEntitySoul(EntityStray.class, new Soul("Stray", EnumSoulElement.MONSTER, EnumSoulElement.ICE));
        this.registerEntitySoul(EntityEvoker.class, new Soul("EvocationIllager", "evocation_illager", EnumSoulElement.ICE));
        this.registerEntitySoul(EntityVex.class, new Soul("Vex", EnumSoulElement.LIGHTNING));
        this.registerEntitySoul(EntityIllusionIllager.class, new Soul("IllusionIllager", "illusion_illager", EnumSoulElement.WATER));
        this.registerEntitySoul(EntityPigZombie.class, new Soul("PigZombie", "zombie_pigman", EnumSoulElement.EARTH, EnumSoulElement.FIRE));
        this.registerEntitySoul(EntityGhast.class, new Soul("Ghast", EnumSoulElement.LIGHTNING, EnumSoulElement.FIRE));
        this.registerEntitySoul(EntityBlaze.class, new Soul("Blaze", EnumSoulElement.FIRE, EnumSoulElement.WIND));
        this.registerEntitySoul(EntityMagmaCube.class, new Soul("LavaSlime", "magma_cube", EnumSoulElement.FIRE, EnumSoulElement.EARTH));
        this.registerEntitySoul(EntityWitherSkeleton.class, new Soul("WitherSkeleton", "wither_skeleton", EnumSoulElement.EARTH, EnumSoulElement.MONSTER));
        this.registerEntitySoul(EntityEnderman.class, new Soul("Enderman", EnumSoulElement.LIGHTNING, EnumSoulElement.ALIEN).setDropRate(rateHigh));
        this.registerEntitySoul(EntityEndermite.class, new Soul("Endermite", EnumSoulElement.EARTH, EnumSoulElement.ALIEN).setDropRate(rateHigh));
        this.registerEntitySoul(EntityShulker.class, new Soul("Shulker", EnumSoulElement.WATER, EnumSoulElement.ALIEN).setDropRate(2.0f * rateHigh));
        this.registerEntitySoul(EntityEnderSlime.class, new Soul("EnderSlime", 13107, 0xAA00AA, EnumSoulElement.FIRE, EnumSoulElement.ALIEN).setDropRate(rateHigh));
        this.registerEntitySoul(EntityPig.class, new Soul("Pig", EnumSoulElement.FAUNA, EnumSoulElement.EARTH));
        this.registerEntitySoul(EntitySheep.class, new Soul("Sheep", EnumSoulElement.FAUNA, EnumSoulElement.WIND));
        this.registerEntitySoul(EntityCow.class, new Soul("Cow", EnumSoulElement.FAUNA, EnumSoulElement.WATER));
        this.registerEntitySoul(EntityChicken.class, new Soul("Chicken", EnumSoulElement.FAUNA, EnumSoulElement.FIRE));
        this.registerEntitySoul(EntityRabbit.class, new Soul("Rabbit", EnumSoulElement.FAUNA, EnumSoulElement.LIGHTNING));
        this.registerEntitySoul(EntitySquid.class, new Soul("Squid", EnumSoulElement.FAUNA, EnumSoulElement.WATER));
        this.registerEntitySoul(EntityBat.class, new Soul("Bat", EnumSoulElement.FAUNA, EnumSoulElement.ICE));
        this.registerEntitySoul(EntityWolf.class, new Soul("Wolf", EnumSoulElement.FAUNA, EnumSoulElement.WIND));
        this.registerEntitySoul(EntityOcelot.class, new Soul("Ozelot", "ocelot", EnumSoulElement.FAUNA, EnumSoulElement.FIRE).setDropRate(rateHigh));
        this.registerEntitySoul(EntityParrot.class, new Soul("Parrot", EnumSoulElement.FAUNA, EnumSoulElement.WIND).setDropRate(2.0f * rateHigh));
        this.registerEntitySoul(EntityMooshroom.class, new Soul("MushroomCow", "mooshroom", EnumSoulElement.FAUNA, EnumSoulElement.FLORA));
        this.registerEntitySoul(EntityPolarBear.class, new Soul("PolarBear", "polar_bear", EnumSoulElement.FAUNA, EnumSoulElement.ICE).setDropRate(rateHigh));
        this.registerEntitySoul(EntitySnowman.class, new Soul("SnowMan", 0xFFFFFF, 0xFF8800, EnumSoulElement.MONSTER, EnumSoulElement.ICE));
        this.registerEntitySoul(EntityHorse.class, new Soul("Horse", EnumSoulElement.FAUNA, EnumSoulElement.FIRE).setDropRate(rateHigh));
        this.registerEntitySoul(EntityDonkey.class, new Soul("Donkey", EnumSoulElement.FAUNA, EnumSoulElement.EARTH).setDropRate(rateHigh));
        this.registerEntitySoul(EntityMule.class, new Soul("Mule", EnumSoulElement.FAUNA, EnumSoulElement.METAL).setDropRate(rateHigh));
        this.registerEntitySoul(EntityLlama.class, new Soul("Llama", EnumSoulElement.FAUNA, EnumSoulElement.WATER).setDropRate(rateHigh));
        this.registerEntitySoul(EntityIronGolem.class, new Soul("VillagerGolem", 0xEEEEEE, 0xFFAAAA, EnumSoulElement.METAL, EnumSoulElement.MONSTER).setDropRate(0.6f));
        this.registerEntitySoul(EntityVillager.class, new Soul("Villager", EnumSoulElement.EARTH).setDropRate(0.1f));
        this.registerEntitySoul(EntityDragon.class, new Soul("EnderDragon", 0x222222, 0xEE88EE, EnumSoulElement.FIRE, EnumSoulElement.ALIEN).setDropRate(1.0f).setDropCount(2));
        this.registerEntitySoul(EntityWither.class, new Soul("WitherBoss", 0x333333, 0xEECCEE, EnumSoulElement.LIGHTNING, EnumSoulElement.ALIEN).setDropRate(1.0f).setDropCount(2));
        this.registerEntitySoul(EntityElderGuardian.class, new Soul("ElderGuardian", "elder_guardian", EnumSoulElement.WATER, EnumSoulElement.ALIEN).setDropRate(1.0f).setDropCount(2));
    }

    public void registerEntitySoul(Class clazz, Soul soul) {
        this.listSorted.add(soul);
        this.classToSoul.put(clazz, soul);
        this.idToSoul.put(soul.id, soul);
    }

    public void registerStackSoul(Soul soul) {
        this.listSorted.add(soul);
        this.idToSoul.put(soul.id, soul);
    }

    public ItemStack getStack(Class clazz) {
        Soul soul = this.classToSoul.get(clazz);
        if (soul == null) {
            return ItemStack.field_190927_a;
        }
        return this.getStack(soul);
    }

    public ItemStack getStack(Soul soul) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a(NBT_SOUL, soul.id);
        stack.func_77982_d(tags);
        return stack;
    }

    public ItemStack getStack(String soulKey) {
        for (Soul soul : this.listSorted) {
            if (!soul.id.equals(soulKey)) continue;
            return this.getStack(soul);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public Soul getSoul(ItemStack soulGem) {
        if (soulGem.func_190926_b() || !soulGem.func_77942_o()) {
            return null;
        }
        return this.idToSoul.get(soulGem.func_77978_p().func_74779_i(NBT_SOUL));
    }

    public Soul getSoul(Class<? extends Entity> clazz) {
        return this.classToSoul.get(clazz);
    }

    @Nullable
    public Soul getSoul(BlockEvent.HarvestDropsEvent event) {
        for (Soul soul : this.listSorted) {
            if (soul.matchStack.func_190926_b()) continue;
            for (ItemStack stack : event.getDrops()) {
                if (!stack.func_77969_a(soul.matchStack)) continue;
                return soul;
            }
        }
        return null;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        this.listSorted.forEach(soul -> list.add((Object)this.getStack((Soul)soul)));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        Soul soul = this.getSoul(stack);
        if (soul != null) {
            list.add("Soul ID: " + soul.id);
            list.add("Elements: " + soul.getElementsForDisplay());
        }
    }

    public String func_77653_i(ItemStack stack) {
        Soul soul = this.getSoul(stack);
        if (soul == null) {
            return SilentGems.i18n.translatedName((Item)this);
        }
        if (!soul.matchStack.func_190926_b()) {
            return SilentGems.i18n.subText((IForgeRegistryEntry)this, "name_proper", new Object[]{soul.matchStack.func_82833_r()});
        }
        String name = "entity." + soul.id + ".name";
        name = SilentGems.i18n.translate(name, new Object[0]);
        return SilentGems.i18n.subText((IForgeRegistryEntry)this, "name_proper", new Object[]{name});
    }

    public static enum SoulType {
        MOB,
        CROP,
        BLOCK;

    }

    public static class Soul {
        public final SoulType soulType;
        public final String id;
        public final int colorPrimary;
        public final int colorSecondary;
        @Nonnull
        public final EnumSoulElement element1;
        @Nonnull
        public final EnumSoulElement element2;
        public final ItemStack matchStack;
        float dropRate = 0.05f;
        int dropCount = 1;

        public Soul(String id, int colorPrimary, int colorSecondary, EnumSoulElement ... elements) {
            this.id = id;
            this.colorPrimary = colorPrimary;
            this.colorSecondary = colorSecondary;
            this.element1 = elements[0];
            this.element2 = elements.length > 1 ? elements[1] : EnumSoulElement.NONE;
            this.matchStack = ItemStack.field_190927_a;
            this.soulType = SoulType.MOB;
        }

        public Soul(String entityId, EnumSoulElement ... elements) {
            this(entityId, entityId, elements);
        }

        public Soul(String entityId, String eggName, EnumSoulElement ... elements) {
            this.id = entityId;
            EntityList.EntityEggInfo info = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(new ResourceLocation(eggName));
            if (info != null) {
                this.colorPrimary = info.field_75611_b;
                this.colorSecondary = info.field_75612_c;
            } else {
                this.colorSecondary = 0xFF00FF;
                this.colorPrimary = 0xFF00FF;
            }
            this.element1 = elements[0];
            this.element2 = elements.length > 1 ? elements[1] : EnumSoulElement.NONE;
            this.matchStack = ItemStack.field_190927_a;
            this.soulType = SoulType.MOB;
        }

        public Soul(String id, ItemStack match, int colorPrimary, int colorSecondary, EnumSoulElement ... elements) {
            this.id = id;
            this.colorPrimary = colorPrimary;
            this.colorSecondary = colorSecondary;
            this.element1 = elements[0];
            this.element2 = elements.length > 1 ? elements[1] : EnumSoulElement.NONE;
            this.matchStack = match;
            this.soulType = SoulType.CROP;
        }

        public float getDropRate() {
            return this.dropRate;
        }

        public Soul setDropRate(float value) {
            this.dropRate = value;
            return this;
        }

        public int getDropCount() {
            return this.dropCount;
        }

        public Soul setDropCount(int value) {
            this.dropCount = value;
            return this;
        }

        public String getElementsForDisplay() {
            if (this.element2 == EnumSoulElement.NONE) {
                return this.element1.getDisplayName();
            }
            return this.element1.getDisplayName() + ", " + this.element2.getDisplayName();
        }

        public ItemStack getStack() {
            return ModItems.soulGem.getStack(this);
        }
    }
}

