/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.util.DimensionalPosition;

public class ItemTeleporterLinker
extends Item
implements ICustomModel {
    public ItemTeleporterLinker() {
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        DimensionalPosition pos = this.getLinkedPosition(stack);
        if (pos != null) {
            list.add(pos.toString());
        }
    }

    public void registerModels() {
        SilentGems.registry.setModel((Item)this, 0, "teleporter_linker");
        SilentGems.registry.setModel((Item)this, 1, "teleporter_linker");
    }

    public boolean isLinked(ItemStack stack) {
        return stack.func_77952_i() != 0;
    }

    public void setLinked(ItemStack stack, boolean value) {
        stack.func_77964_b(value ? 1 : 0);
    }

    @Nullable
    public DimensionalPosition getLinkedPosition(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return DimensionalPosition.readFromNBT((NBTTagCompound)stack.func_77978_p());
    }

    public void setLinkedPosition(ItemStack stack, DimensionalPosition pos) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        pos.writeToNBT(stack.func_77978_p());
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isLinked(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderGameOverlay(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack heldItem = mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            heldItem = mc.field_71439_g.func_184586_b(EnumHand.OFF_HAND);
        }
        if (heldItem.func_77973_b() == this) {
            ScaledResolution res = new ScaledResolution(mc);
            FontRenderer fontRender = mc.field_71466_p;
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            if (this.isLinked(heldItem)) {
                DimensionalPosition pos = this.getLinkedPosition(heldItem);
                if (pos == null) {
                    return;
                }
                double x = (double)pos.x - player.field_70165_t;
                double z = (double)pos.z - player.field_70161_v;
                int distance = (int)Math.sqrt(x * x + z * z);
                String str = SilentGems.i18n.subText((IForgeRegistryEntry)this, "distance", new Object[]{distance});
                int textX = width / 2 - fontRender.func_78256_a(str) / 2;
                int textY = height * 3 / 5;
                int color = 0xFFFF00;
                if (pos.dim != player.field_71093_bK) {
                    color = 0xFF6600;
                    str = SilentGems.i18n.subText((IForgeRegistryEntry)this, "differentDimension", new Object[0]);
                } else if (distance < GemsConfig.TELEPORTER_FREE_RANGE) {
                    color = 43775;
                }
                fontRender.func_175063_a(str, (float)textX, (float)textY, color);
            }
        }
    }
}

