/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartTip;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.RecipeMaker;

public class ItemTipUpgrade
extends Item
implements IAddRecipes,
ICustomModel {
    private static final String[] NAMES = new String[]{"upgradeirontip", "upgradegoldtip", "upgradediamondtip", "upgradeemeraldtip"};
    public static List<IRecipe> RECIPES = Lists.newArrayList();

    public ItemTipUpgrade() {
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        ToolPartTip part = (ToolPartTip)ToolPartRegistry.fromStack(stack);
        if (part != null) {
            list.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "willReplace", new Object[0]));
            list.add(SilentGems.i18n.subText((IForgeRegistryEntry)this, "harvestLevel", new Object[]{part.getHarvestLevel()}));
            this.tooltipLine(list, "durability", part.getDurability());
            this.tooltipLine(list, "harvestSpeed", Float.valueOf(part.getHarvestSpeed()));
            this.tooltipLine(list, "meleeDamage", Float.valueOf(part.getMeleeDamage()));
            this.tooltipLine(list, "magicDamage", Float.valueOf(part.getMagicDamage()));
        }
    }

    private void tooltipLine(List<String> list, String key, Number value) {
        if (value.floatValue() == 0.0f) {
            return;
        }
        String numberString = (value.floatValue() < 0.0f ? "-" : "+") + String.format(value instanceof Integer ? "%d" : "%.1f", value);
        String line = SilentGems.i18n.subText((IForgeRegistryEntry)this, key, new Object[]{numberString});
        list.add(String.format(line, numberString));
    }

    public ItemStack applyToTool(ItemStack tool, ItemStack upgrade) {
        ToolPart part = ToolPartRegistry.fromStack(upgrade);
        if (part == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = tool.func_77946_l();
        ToolHelper.setConstructionTip(result, part);
        ToolHelper.recalculateStats(result);
        return result;
    }

    public void addRecipes(RecipeMaker recipes) {
        ItemStack base = CraftingItems.UPGRADE_BASE.getStack();
        RECIPES.add(recipes.makeShapelessOre("tip_upgrade_iron", new ItemStack((Item)this, 1, 0), new Object[]{"ingotIron", base}));
        RECIPES.add(recipes.makeShapelessOre("tip_upgrade_gold", new ItemStack((Item)this, 1, 1), new Object[]{"ingotGold", base}));
        RECIPES.add(recipes.makeShapelessOre("tip_upgrade_diamond", new ItemStack((Item)this, 1, 2), new Object[]{"gemDiamond", base}));
        RECIPES.add(recipes.makeShapelessOre("tip_upgrade_emerald", new ItemStack((Item)this, 1, 3), new Object[]{"gemEmerald", base}));
    }

    public String func_77667_c(ItemStack stack) {
        return "item.silentgems." + NAMES[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(NAMES.length - 1))];
    }

    public void registerModels() {
        for (int i = 0; i < NAMES.length; ++i) {
            SilentGems.registry.setModel((Item)this, i, NAMES[i]);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < NAMES.length; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }
}

