/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartTip;
import net.silentchaos512.gems.client.handler.ClientTickHandler;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.client.render.ToolItemOverrideHandler;
import net.silentchaos512.gems.client.render.ToolModel;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ToolRenderHelperBase;
import net.silentchaos512.gems.item.tool.ItemGemAxe;
import net.silentchaos512.gems.item.tool.ItemGemBow;
import net.silentchaos512.gems.item.tool.ItemGemHoe;
import net.silentchaos512.gems.item.tool.ItemGemShield;
import net.silentchaos512.gems.item.tool.ItemGemShovel;
import net.silentchaos512.gems.item.tool.ItemGemSword;
import net.silentchaos512.gems.item.tool.ItemGemTomahawk;
import net.silentchaos512.gems.lib.TooltipHelper;
import net.silentchaos512.gems.lib.client.ArmorModelData;
import net.silentchaos512.gems.lib.client.IModelData;
import net.silentchaos512.gems.lib.client.ToolModelData;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.EnumMagicType;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.ICustomModel;

public class ToolRenderHelper
extends ToolRenderHelperBase
implements ICustomModel {
    public static final String NBT_MODEL_INDEX = "SGModel";
    public static final String SMART_MODEL_NAME = "silentgems:".toLowerCase() + "tool";
    public static final ModelResourceLocation SMART_MODEL = new ModelResourceLocation(SMART_MODEL_NAME, "inventory");
    private Set<ModelResourceLocation> modelSet = null;
    private ModelResourceLocation[] arrowModels;
    private Map<UUID, IModelData> modelCache = new HashMap<UUID, IModelData>();
    private Map<UUID, IModelData> modelCacheExamples = new HashMap<UUID, IModelData>();
    public ModelResourceLocation modelBlank;
    public ModelResourceLocation modelError;
    public ModelResourceLocation modelGooglyEyes;

    public static ToolRenderHelper getInstance() {
        return (ToolRenderHelper)instance;
    }

    public void func_77624_a(ItemStack tool, World world, List<String> list, ITooltipFlag flag) {
        ToolSoul soul;
        String line;
        boolean controlDown = KeyTracker.isControlDown();
        boolean altDown = KeyTracker.isAltDown();
        boolean shiftDown = KeyTracker.isShiftDown();
        ToolPartTip partTip = (ToolPartTip)ToolHelper.getConstructionTip(tool);
        if (partTip != null) {
            String tipName = partTip.getUnlocalizedName().replaceFirst("[^:]+:", "");
            tipName = SilentGems.i18n.miscText("tooltip." + tipName, new Object[0]);
            line = SilentGems.i18n.miscText("tooltip.tipped", new Object[]{tipName});
            list.add(line);
        }
        if (GemsConfig.DEBUG_MODE && controlDown && shiftDown) {
            UUID uuid = ToolHelper.hasUUID(tool) ? ToolHelper.getUUID(tool) : null;
            list.add(uuid == null ? "No UUID" : uuid.toString());
            uuid = ToolHelper.getSoulUUID(tool);
            list.add(uuid == null ? "No Soul UUID" : uuid.toString());
        }
        if ((soul = SoulManager.getSoul(tool)) != null) {
            soul.addInformation(tool, world, list, flag.func_194127_a());
        }
        if (controlDown) {
            String owner = ToolHelper.getOriginalOwner(tool);
            if (owner.equals(SilentGems.i18n.miscText("tooltip.OriginalOwner.Creative", new Object[0]))) {
                owner = TextFormatting.LIGHT_PURPLE + owner;
            }
            if (!owner.isEmpty()) {
                list.add(SilentGems.i18n.miscText("tooltip.OriginalOwner", new Object[]{owner}));
            } else {
                list.add(SilentGems.i18n.miscText("tooltip.OriginalOwner.Unknown", new Object[0]));
            }
        }
        if (controlDown && tool.func_77978_p().func_74767_n("SG_LockStats")) {
            list.add(SilentGems.i18n.miscText("tooltip.LockedStats", new Object[0]));
        }
        if (tool.func_77942_o() && tool.func_77978_p().func_74764_b("ExampleToolTier")) {
            EnumMaterialTier tier = EnumMaterialTier.values()[tool.func_77978_p().func_74762_e("ExampleToolTier")];
            list.add(SilentGems.i18n.miscText("tooltip.ExampleTool", new Object[]{tier}));
        } else if (ToolHelper.hasNoConstruction(tool)) {
            list.add(SilentGems.i18n.miscText("tooltip.NoData1", new Object[0]));
            list.add(SilentGems.i18n.miscText("tooltip.NoData2", new Object[0]));
        } else if (ToolHelper.isBroken(tool)) {
            line = SilentGems.i18n.miscText("tooltip.Broken", new Object[0]);
            list.add(line);
        }
        Item item = tool.func_77973_b();
        boolean isSword = item instanceof ItemGemSword;
        boolean isAxe = item instanceof ItemGemAxe;
        boolean isWeapon = isSword || isAxe;
        boolean isCaster = isSword && ToolHelper.getToolTier(tool).ordinal() >= EnumMaterialTier.SUPER.ordinal();
        boolean isBow = item instanceof ItemGemBow;
        boolean isDigger = item instanceof ItemTool;
        boolean isShield = item instanceof ItemGemShield;
        String sep = SilentGems.i18n.miscText("tooltip.Separator", new Object[0]);
        if (controlDown) {
            line = SilentGems.i18n.miscText("tooltip.Properties", new Object[0]);
            list.add(line);
            TextFormatting color = TextFormatting.YELLOW;
            EnumMaterialTier tier = ToolHelper.getToolTier(tool);
            line = TextFormatting.RESET + SilentGems.i18n.miscText("tooltier." + (Object)((Object)tier), new Object[0]);
            list.add("  " + color + SilentGems.i18n.miscText("tooltier", new Object[]{line}));
            int durabilityMax = tool.func_77958_k();
            int durability = durabilityMax - tool.func_77952_i();
            String s1 = String.format(durability > 9999 ? "%,d" : "%d", durability);
            String s2 = String.format(durabilityMax > 9999 ? "%,d" : "%d", durabilityMax);
            float durabilityBoost = ToolSoul.getDurabilityModifierForDisplay(soul);
            String durBoostLine = durabilityBoost == 0.0f ? "" : " (" + TooltipHelper.numberToPercent(durabilityBoost, 0, true) + TextFormatting.RESET + ")";
            line = SilentGems.i18n.miscText("tooltip.Durability", new Object[]{s1 + " / " + s2 + durBoostLine});
            list.add(color + "  " + line);
            if (isShield) {
                float magicProtection = (int)(ToolHelper.getMagicProtection(tool) * 100.0f);
                list.add(color + this.getTooltipLine("MagicProtection", magicProtection, 0.0f));
            }
            if (isDigger) {
                int harvestLevel = ToolHelper.getHarvestLevel(tool);
                String str = color + this.getTooltipLine("HarvestLevel", harvestLevel, 0.0f);
                String key = "tooltip.level" + harvestLevel;
                String val = SilentGems.i18n.miscText(key, new Object[0]);
                if (!val.equals("misc.silentgems:" + key)) {
                    str = str + " (" + val + ")";
                }
                list.add(str);
                float harvestSpeedModifier = ToolSoul.getHarvestSpeedModifierForDisplay(soul);
                list.add(color + this.getTooltipLine("HarvestSpeed", ToolHelper.getDigSpeedOnProperMaterial(tool), harvestSpeedModifier));
            }
            if (isWeapon) {
                float meleeSpeed = 4.0f + ToolHelper.getMeleeSpeedModifier(tool);
                list.add(color + this.getTooltipLine("MeleeSpeed", meleeSpeed, 0.0f).replaceFirst("%", ""));
                float meleeDamage = 1.0f + ToolHelper.getMeleeDamageModifier(tool);
                float meleeModifier = ToolSoul.getMeleeDamageModifierForDisplay(soul);
                list.add(color + this.getTooltipLine("MeleeDamage", meleeDamage, meleeModifier));
                if (isCaster) {
                    EnumMagicType magicType = EnumMagicType.getMagicType(tool);
                    float damagePerShot = magicType.getDamagePerShot(tool);
                    String damageString = damagePerShot == (float)((int)damagePerShot) ? Integer.toString((int)damagePerShot) : String.format("%.2f", Float.valueOf(damagePerShot));
                    String str = damageString + "" + TextFormatting.DARK_GRAY + "x" + magicType.getShotCount(tool);
                    float magicModifier = ToolSoul.getMagicDamageModifierForDisplay(soul);
                    list.add(color + this.getTooltipLine("MagicDamage", str, magicModifier));
                }
            }
            if (isBow) {
                ToolStats statsNoSoul = ToolHelper.getStats(tool, false);
                float drawSpeed = ModItems.bow.getDrawSpeedForDisplay(tool);
                float drawSpeedPreSoul = ItemGemBow.getDrawSpeedForDisplay(statsNoSoul.meleeSpeed, statsNoSoul.harvestSpeed);
                float drawSpeedBoost = (drawSpeed - drawSpeedPreSoul) / drawSpeedPreSoul;
                list.add(color + this.getTooltipLine("DrawSpeed", drawSpeed, drawSpeedBoost));
                float arrowDamage = ModItems.bow.getArrowDamageForDisplay(tool);
                float arrowDamagePreSoul = ItemGemBow.getArrowDamageForDisplay(statsNoSoul.meleeDamage);
                float arrowDamageBoost = (arrowDamage - arrowDamagePreSoul) / arrowDamagePreSoul;
                list.add(color + this.getTooltipLine("ArrowDamage", arrowDamage, arrowDamageBoost));
            }
            list.add(color + this.getTooltipLine("ChargeSpeed", ToolHelper.getChargeSpeed(tool), 0.0f));
        } else {
            list.add(TextFormatting.GOLD + SilentGems.i18n.miscText("tooltip.CtrlForProp", new Object[0]));
        }
        if (altDown) {
            list.add(sep);
            line = SilentGems.i18n.miscText("tooltip.Statistics", new Object[0]);
            list.add(line);
            list.add(this.getTooltipLine("BlocksMined", ToolHelper.getStatBlocksMined(tool), 0.0f));
            if (isDigger) {
                list.add(this.getTooltipLine("BlocksPlaced", ToolHelper.getStatBlocksPlaced(tool), 0.0f));
            }
            if (item instanceof ItemGemShovel) {
                list.add(this.getTooltipLine("PathsMade", ToolHelper.getStatPathsMade(tool), 0.0f));
            }
            if (item instanceof ItemGemHoe) {
                list.add(this.getTooltipLine("BlocksTilled", ToolHelper.getStatBlocksTilled(tool), 0.0f));
            }
            list.add(this.getTooltipLine("HitsLanded", ToolHelper.getStatHitsLanded(tool), 0.0f));
            if (isCaster || isBow) {
                list.add(this.getTooltipLine("ShotsFired", ToolHelper.getStatShotsFired(tool), 0.0f));
            }
            if (item instanceof ItemGemTomahawk) {
                list.add(this.getTooltipLine("ThrownCount", ToolHelper.getStatThrownCount(tool), 0.0f));
            }
            if (isWeapon) {
                list.add(this.getTooltipLine("KillCount", ToolHelper.getStatKillCount(tool), 0.0f));
            }
            list.add(this.getTooltipLine("Redecorated", ToolHelper.getStatRedecorated(tool), 0.0f));
            list.add(sep);
            line = SilentGems.i18n.miscText("tooltip.Construction", new Object[0]);
            list.add(line);
            ToolPart[] parts = ToolHelper.getConstructionParts(tool);
            EnumMaterialGrade[] grades = ToolHelper.getConstructionGrades(tool);
            for (int i = 0; i < parts.length; ++i) {
                ToolPart part = parts[i];
                EnumMaterialGrade grade = grades[i];
                line = "  " + TextFormatting.YELLOW + part.getKey() + TextFormatting.GOLD + " (" + (Object)((Object)grade) + ")";
                list.add(line);
            }
            ToolPart partRod = ToolHelper.getConstructionRod(tool);
            if (partRod != null) {
                list.add("  " + TextFormatting.YELLOW + partRod.getKey());
            }
            list.add(sep);
        } else {
            list.add(TextFormatting.GOLD + SilentGems.i18n.miscText("tooltip.AltForStat", new Object[0]));
        }
        if (controlDown && shiftDown && tool.func_77942_o()) {
            if (!altDown) {
                list.add(sep);
            }
            list.add("Render Layers");
            IModelData modelData = this.getModelCache(tool);
            if (modelData != null) {
                for (ToolPartPosition pos : ToolPartPosition.values()) {
                    String key = "Layer" + pos.ordinal();
                    String str = "  %s: %s, %X";
                    ToolPart renderPart = ToolHelper.getRenderPart(tool, pos);
                    ModelResourceLocation model = renderPart == null ? null : renderPart.getModel(tool, pos, 0);
                    str = String.format(str, pos.name(), model == null ? "null" : model.toString(), modelData.getColor(pos, 0));
                    list.add(str);
                }
            }
        }
        list.add(SilentGems.i18n.miscText("legacyItem", new Object[0]));
    }

    public String getTooltipLine(String key, int value, float soulBoost) {
        String line = TooltipHelper.get(key, value, true);
        if (soulBoost != 0.0f) {
            line = line + TextFormatting.RESET + " (" + TooltipHelper.numberToPercent(soulBoost, 0, true) + TextFormatting.RESET + ")";
        }
        return line;
    }

    public String getTooltipLine(String key, float value, float soulBoost) {
        String line = TooltipHelper.get(key, value, true);
        if (soulBoost != 0.0f) {
            line = line + TextFormatting.RESET + " (" + TooltipHelper.numberToPercent(soulBoost, 0, true) + TextFormatting.RESET + ")";
        }
        return line;
    }

    public String getTooltipLine(String key, String value, float soulBoost) {
        String line = TooltipHelper.get(key, value, true);
        if (soulBoost != 0.0f) {
            line = line + TextFormatting.RESET + " (" + TooltipHelper.numberToPercent(soulBoost, 0, true) + TextFormatting.RESET + ")";
        }
        return line;
    }

    @Nullable
    private IModelData getModelCache(ItemStack tool) {
        if (!ToolHelper.hasUUID(tool)) {
            return null;
        }
        UUID uuid = ToolHelper.getUUID(tool);
        if (ToolHelper.isExampleItem(tool)) {
            return this.modelCacheExamples.get(uuid);
        }
        return this.modelCache.get(uuid);
    }

    @Override
    public void updateModelCache(ItemStack toolOrArmor) {
        if (ToolHelper.hasUUID(toolOrArmor)) {
            IModelData modelData;
            UUID uuid = ToolHelper.getUUID(toolOrArmor);
            IModelData iModelData = modelData = toolOrArmor.func_77973_b() instanceof ITool ? new ToolModelData(toolOrArmor) : new ArmorModelData(toolOrArmor);
            if (ToolHelper.isExampleItem(toolOrArmor)) {
                this.modelCacheExamples.put(uuid, modelData);
            } else {
                this.modelCache.put(uuid, modelData);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (ClientTickHandler.ticksInGame % 12000 == 0) {
                this.modelCache.clear();
            }
            if (ClientTickHandler.ticksInGame % 1200 == 0) {
                this.modelCacheExamples.clear();
            }
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        Object object = event.getModelRegistry().func_82594_a((Object)SMART_MODEL);
        if (object != null) {
            IBakedModel existingModel = (IBakedModel)object;
            ToolModel customModel = new ToolModel(existingModel);
            event.getModelRegistry().func_82595_a((Object)SMART_MODEL, (Object)customModel);
            ToolItemOverrideHandler.baseModel = customModel;
        }
    }

    private void buildModelSet() {
        if (this.modelSet != null) {
            return;
        }
        Set set = Sets.newConcurrentHashSet();
        for (ToolPart part : ToolPartRegistry.getValues()) {
            for (ToolPartPosition pos : ToolPartPosition.values()) {
                for (Item itemTool : ModItems.tools) {
                    for (int frame = 0; frame < (itemTool instanceof ItemGemBow ? 4 : 1); ++frame) {
                        ModelResourceLocation model = part.getModel(new ItemStack(itemTool), pos, frame);
                        if (model == null) continue;
                        set.add(model);
                    }
                }
            }
        }
        this.arrowModels = new ModelResourceLocation[8];
        for (int i = 0; i < 8; ++i) {
            String tier = i < 4 ? "regular" : "super";
            ModelResourceLocation model = new ModelResourceLocation("silentgems:bow/bow_arrow_" + tier + (i & 3));
            set.add(model);
            this.arrowModels[i] = model;
        }
        this.modelSet = set;
        ModelResourceLocation[] models = set.toArray(new ModelResourceLocation[0]);
    }

    private int getAnimationFrame(ItemStack tool) {
        if (tool.func_77973_b() instanceof ItemGemBow) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float pull = tool.func_77973_b().func_185045_a(ItemGemBow.RESOURCE_PULL).func_185085_a(tool, player.field_70170_p, (EntityLivingBase)player);
            float pulling = tool.func_77973_b().func_185045_a(ItemGemBow.RESOURCE_PULLING).func_185085_a(tool, player.field_70170_p, (EntityLivingBase)player);
            if (pull > 0.9f) {
                return 3;
            }
            if (pull > 0.65f) {
                return 2;
            }
            if (pulling > 0.0f) {
                return 1;
            }
        }
        return 0;
    }

    public int getTotalAnimationFrames(ItemStack tool) {
        return tool.func_77973_b() instanceof ItemGemBow ? 4 : 1;
    }

    public int getColor(ItemStack toolOrArmor, @Nullable IPartPosition pos) {
        if (toolOrArmor.func_190926_b() || pos == null) {
            return 0xFFFFFF;
        }
        IModelData modelData = this.getModelCache(toolOrArmor);
        if (modelData == null) {
            this.updateModelCache(toolOrArmor);
            modelData = this.getModelCache(toolOrArmor);
        }
        if (modelData == null) {
            return 0xFFFFFF;
        }
        return modelData.getColor(pos, this.getAnimationFrame(toolOrArmor));
    }

    @Nullable
    public ModelResourceLocation getModel(ItemStack tool, ToolPartPosition pos) {
        if (tool.func_190926_b()) {
            return this.modelError;
        }
        IModelData modelData = this.getModelCache(tool);
        int frame = this.getAnimationFrame(tool);
        boolean isBow = tool.func_77973_b() instanceof ItemGemBow;
        if (modelData == null) {
            this.updateModelCache(tool);
            modelData = this.getModelCache(tool);
        }
        if (ToolHelper.isBroken(tool) || modelData == null || modelData.getModel(pos, frame) == null) {
            if (pos == ToolPartPosition.ROD_GRIP && isBow) {
                return this.getArrowModel(tool, frame);
            }
            ToolPart part = ToolHelper.getRenderPart(tool, pos);
            if (part == null) {
                return null;
            }
            return !ToolHelper.isBroken(tool) ? part.getModel(tool, pos, frame) : part.getBrokenModel(tool, pos, frame);
        }
        return modelData.getModel(pos, frame);
    }

    @Nullable
    private ModelResourceLocation getArrowModel(ItemStack tool, int frame) {
        if (frame < 0 || frame > 3) {
            return null;
        }
        if (ToolHelper.isBroken(tool)) {
            return this.modelBlank;
        }
        boolean superTier = ToolHelper.getToolTier(tool).ordinal() >= EnumMaterialTier.SUPER.ordinal();
        return this.arrowModels[superTier ? frame + 4 : frame];
    }

    public void registerModels() {
        this.buildModelSet();
        AtomicInteger index = new AtomicInteger();
        this.modelSet.forEach(model -> ModelLoader.setCustomModelResourceLocation((Item)this, (int)index.getAndIncrement(), (ModelResourceLocation)model));
        this.modelGooglyEyes = new ModelResourceLocation("silentgems:googlyeyes", "inventory");
        this.modelError = new ModelResourceLocation("silentgems:error", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)index.getAndIncrement(), (ModelResourceLocation)this.modelGooglyEyes);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)index.getAndIncrement(), (ModelResourceLocation)this.modelError);
        for (String str : new String[]{"sword", "dagger", "katana", "machete", "scepter", "tomahawk", "pickaxe", "shovel", "axe", "paxel", "hoe", "sickle", "bow"}) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)index.getAndIncrement(), (ModelResourceLocation)new ModelResourceLocation("silentgems:" + str + "/_error", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)index.getAndIncrement(), (ModelResourceLocation)new ModelResourceLocation("silentgems:" + str + "/" + str + "_broken", "inventory"));
        }
    }
}

