/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.RecipeMaker;

public class ItemGemSickle
extends ItemTool
implements ITool,
IAddRecipes,
ICustomModel {
    public static final Material[] effectiveMaterials = new Material[]{Material.field_151570_A, Material.field_151584_j, Material.field_151585_k, Material.field_151582_l, Material.field_151569_G};
    public static final int DURABILITY_USAGE = 2;
    public static final int BREAK_RANGE = 4;
    public static final int HARVEST_RANGE = 2;

    public ItemGemSickle() {
        super(ToolHelper.FAKE_MATERIAL, (Set)Sets.newHashSet((Object[])new Block[0]));
        this.setNoRepair();
    }

    public ItemStack constructTool(boolean supercharged, ItemStack material) {
        return this.constructTool(supercharged, material, material, material);
    }

    public ItemStack constructTool(boolean supercharged, ItemStack ... materials) {
        ItemStack rod = supercharged ? CraftingItems.ORNATE_GOLD_ROD.getStack() : new ItemStack(Items.field_151055_y);
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.sickle;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return ItemStack.field_190927_a;
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeDamageModifier() {
        return 1.0f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 0.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return -1.8f;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (ToolHelper.isBroken(stack)) {
            return EnumActionResult.PASS;
        }
        boolean flag = false;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IGrowable) {
            int radius = 2;
            for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
                for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
                    IGrowable crop;
                    BlockPos targetPos = new BlockPos(x, pos.func_177956_o(), z);
                    state = world.func_180495_p(targetPos);
                    Block block = state.func_177230_c();
                    if (!(block instanceof IGrowable) || block instanceof BlockDoublePlant || (crop = (IGrowable)block).func_176473_a(world, targetPos, state, world.field_72995_K)) continue;
                    NonNullList drops = NonNullList.func_191196_a();
                    int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                    block.getDrops(drops, (IBlockAccess)world, targetPos, state, fortune);
                    ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)targetPos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
                    boolean foundSeed = false;
                    for (ItemStack dropStack : drops) {
                        if (!foundSeed && dropStack.func_77973_b() instanceof IPlantable) {
                            IPlantable seed = (IPlantable)dropStack.func_77973_b();
                            if (seed.getPlant((IBlockAccess)world, targetPos) != block.func_176223_P()) continue;
                            foundSeed = true;
                            continue;
                        }
                        Block.func_180635_a((World)world, (BlockPos)targetPos, (ItemStack)dropStack);
                    }
                    world.func_180501_a(targetPos, block.func_176223_P(), 2);
                    flag = true;
                }
            }
        }
        if (flag) {
            ToolHelper.attemptDamageTool(stack, 2, (EntityLivingBase)player);
            player.func_71020_j(0.02f);
        }
        return flag ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public static boolean isEffectiveOnMaterial(Material material) {
        for (Material m : effectiveMaterials) {
            if (material != m) continue;
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack sickle, BlockPos pos, EntityPlayer player) {
        return this.onSickleStartBreak(sickle, pos, player, 4);
    }

    public boolean onSickleStartBreak(ItemStack sickle, BlockPos pos, EntityPlayer player, int range) {
        if (ToolHelper.isBroken(sickle)) {
            return false;
        }
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!ItemGemSickle.isEffectiveOnMaterial(state.func_185904_a())) {
            ToolHelper.incrementStatBlocksMined(sickle, 1);
            return false;
        }
        int blocksBroken = 1;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xPos = x - range; xPos <= x + range; ++xPos) {
            for (int zPos = z - range; zPos <= z + range; ++zPos) {
                if (xPos == x && zPos == z || world.func_180495_p(new BlockPos(xPos, y, zPos)) != state || !this.breakExtraBlock(sickle, world, xPos, y, zPos, 0, player, x, y, z)) continue;
                ++blocksBroken;
            }
        }
        ToolHelper.incrementStatBlocksMined(sickle, blocksBroken);
        return super.onBlockStartBreak(sickle, pos, player);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return ToolHelper.onBlockDestroyed(stack, world, state, pos, entityLiving);
    }

    private boolean breakExtraBlock(ItemStack sickle, World world, int x, int y, int z, int sideHit, EntityPlayer player, int refX, int refY, int refZ) {
        boolean canceled;
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175623_d(pos) || !(player instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean effectiveOnBlock = false;
        for (Material mat : effectiveMaterials) {
            if (mat != state.func_185904_a()) continue;
            effectiveOnBlock = true;
            break;
        }
        if (!effectiveOnBlock) {
            return false;
        }
        int xpDropped = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
        boolean bl = canceled = xpDropped == -1;
        if (canceled) {
            return false;
        }
        if (playerMP.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_176208_a(world, pos, state, (EntityPlayer)playerMP);
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, null, sickle);
                block.func_180637_b(world, pos, xpDropped);
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            int meta = block.func_176201_c(state);
            world.func_175718_b(2001, pos, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, true)) {
                block.func_176206_d(world, pos, state);
            }
            sickle.func_179548_a(world, state, pos, (EntityPlayer)playerMP);
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getMaxDamage(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ToolRenderHelper.instance.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ToolRenderHelper.instance.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ToolRenderHelper.instance.func_77613_e(stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return ToolHelper.getItemEnchantability(stack);
    }

    public void func_77663_a(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(tool, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return ToolHelper.onEntityItemUpdate(entityItem);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (Material material : effectiveMaterials) {
            if (state.func_185904_a() != material) continue;
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_185904_a() == Material.field_151569_G;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState state) {
        if (super.getHarvestLevel(stack, toolClass, player, state) < 0) {
            return 0;
        }
        return ToolHelper.getHarvestLevel(stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return ToolHelper.getAttributeModifiers(slot, stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity1, EntityLivingBase entity2) {
        return ToolHelper.hitEntity(stack, entity1, entity2);
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return ToolHelper.getIsRepairable(stack1, stack2);
    }

    public void addRecipes(RecipeMaker recipes) {
        if (!this.getConfig().isDisabled) {
            ToolHelper.addExampleRecipe((Item)this, " h", "hh", "r ");
        }
    }

    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        ToolRenderHelper.getInstance().func_77624_a(stack, world, list, flag);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems((Item)this, 3));
    }

    public void registerModels() {
        SilentGems.registry.setModel((Item)this, 0, "tool");
    }
}

